/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.conditions;

import java.util.ArrayList;
import java.util.List;
import mchorse.mappet.CommonProxy;
import mchorse.mappet.api.conditions.blocks.AbstractConditionBlock;
import mchorse.mappet.api.utils.DataContext;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.INBTSerializable;

public class Condition
implements INBTSerializable<NBTTagCompound> {
    public final List<AbstractConditionBlock> blocks = new ArrayList<AbstractConditionBlock>();
    private boolean defaultValue;

    public Condition(boolean defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean execute(DataContext context) {
        if (this.blocks.isEmpty()) {
            return this.defaultValue;
        }
        boolean result = this.blocks.get(0).evaluate(context);
        for (int i = 1; i < this.blocks.size(); ++i) {
            AbstractConditionBlock block = this.blocks.get(i);
            boolean value = block.evaluate(context);
            result = block.or ? result || value : result && value;
        }
        return result;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList blocks = new NBTTagList();
        for (AbstractConditionBlock block : this.blocks) {
            NBTTagCompound blockTag = block.serializeNBT();
            blockTag.func_74778_a("Type", CommonProxy.getConditionBlocks().getType(block));
            blocks.func_74742_a((NBTBase)blockTag);
        }
        if (blocks.func_74745_c() > 0) {
            tag.func_74782_a("Blocks", (NBTBase)blocks);
        }
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        NBTTagList blocks = tag.func_150295_c("Blocks", 10);
        this.blocks.clear();
        for (int i = 0; i < blocks.func_74745_c(); ++i) {
            NBTTagCompound blockTag = blocks.func_150305_b(i);
            AbstractConditionBlock block = CommonProxy.getConditionBlocks().create(blockTag.func_74779_i("Type"));
            if (block == null) continue;
            block.deserializeNBT(blockTag);
            this.blocks.add(block);
        }
    }
}

