/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.conditions.blocks;

import mchorse.mappet.api.conditions.blocks.TargetConditionBlock;
import mchorse.mappet.api.utils.DataContext;
import mchorse.mappet.api.utils.TargetMode;
import mchorse.mappet.utils.EnumUtils;
import mchorse.mappet.utils.InventoryUtils;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemConditionBlock
extends TargetConditionBlock {
    public ItemStack stack = ItemStack.field_190927_a;
    public ItemCheck check = ItemCheck.HELD;

    @Override
    public boolean evaluateBlock(DataContext context) {
        EntityPlayer player;
        if (this.target.mode != TargetMode.GLOBAL && (player = this.target.getPlayer(context)) != null) {
            if (this.check == ItemCheck.HELD) {
                ItemStack main = player.func_184582_a(EntityEquipmentSlot.MAINHAND);
                ItemStack off = player.func_184582_a(EntityEquipmentSlot.OFFHAND);
                boolean a = InventoryUtils.areStacksSimilar(main, this.stack);
                boolean b = InventoryUtils.areStacksSimilar(off, this.stack);
                return a || b;
            }
            if (this.check == ItemCheck.EQUIPMENT) {
                return InventoryUtils.countItems((NonNullList<ItemStack>)player.field_71071_by.field_70460_b, this.stack, true) >= this.stack.func_190916_E();
            }
            return InventoryUtils.countItems((NonNullList<ItemStack>)player.field_71071_by.field_70462_a, this.stack, true) >= this.stack.func_190916_E();
        }
        return false;
    }

    @Override
    protected TargetMode getDefaultTarget() {
        return TargetMode.SUBJECT;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String stringify() {
        String name = this.stack.func_82833_r();
        if (this.check == ItemCheck.HELD) {
            return I18n.func_135052_a((String)"mappet.gui.conditions.item.holds", (Object[])new Object[]{name});
        }
        if (this.check == ItemCheck.EQUIPMENT) {
            return I18n.func_135052_a((String)"mappet.gui.conditions.item.equipment", (Object[])new Object[]{name});
        }
        return I18n.func_135052_a((String)"mappet.gui.conditions.item.inventory", (Object[])new Object[]{name + "x" + this.stack.func_190916_E()});
    }

    @Override
    public void serializeNBT(NBTTagCompound tag) {
        super.serializeNBT(tag);
        tag.func_74782_a("Stack", (NBTBase)this.stack.serializeNBT());
        tag.func_74768_a("Check", this.check.ordinal());
    }

    @Override
    public void deserializeNBT(NBTTagCompound tag) {
        super.deserializeNBT(tag);
        this.stack = new ItemStack(tag.func_74775_l("Stack"));
        this.check = EnumUtils.getValue(tag.func_74762_e("Check"), ItemCheck.values(), ItemCheck.HELD);
    }

    public static enum ItemCheck {
        HELD,
        EQUIPMENT,
        INVENTORY;

    }
}

