/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.crafting;

import java.util.ArrayList;
import java.util.List;
import mchorse.mappet.api.crafting.CraftingRecipe;
import mchorse.mappet.api.utils.AbstractData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class CraftingTable
extends AbstractData {
    public String title = "";
    public String action = "";
    public List<CraftingRecipe> recipes = new ArrayList<CraftingRecipe>();

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList recipes = new NBTTagList();
        for (CraftingRecipe recipe : this.recipes) {
            NBTTagCompound recipeTag = recipe.serializeNBT();
            if (recipeTag.func_186856_d() <= 0) continue;
            recipes.func_74742_a((NBTBase)recipeTag);
        }
        if (!this.title.isEmpty()) {
            tag.func_74778_a("Title", this.title);
        }
        if (!this.action.isEmpty()) {
            tag.func_74778_a("Action", this.action);
        }
        if (recipes.func_74745_c() > 0) {
            tag.func_74782_a("Recipes", (NBTBase)recipes);
        }
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("Title")) {
            this.title = tag.func_74779_i("Title");
        }
        if (tag.func_74764_b("Action")) {
            this.action = tag.func_74779_i("Action");
        }
        if (tag.func_74764_b("Recipes")) {
            NBTTagList recipes = tag.func_150295_c("Recipes", 10);
            for (int i = 0; i < recipes.func_74745_c(); ++i) {
                CraftingRecipe recipe = new CraftingRecipe();
                recipe.deserializeNBT(recipes.func_150305_b(i));
                this.recipes.add(recipe);
            }
        }
    }

    public void filter(EntityPlayerMP player) {
        this.recipes.removeIf(recipe -> !recipe.isAvailable((EntityPlayer)player));
    }
}

