/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.dialogues.nodes;

import mchorse.mappet.Mappet;
import mchorse.mappet.api.dialogues.DialogueContext;
import mchorse.mappet.api.events.EventContext;
import mchorse.mappet.api.events.nodes.EventBaseNode;
import mchorse.mappet.api.quests.Quest;
import mchorse.mappet.capabilities.character.Character;
import mchorse.mappet.capabilities.character.ICharacter;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class QuestDialogueNode
extends EventBaseNode {
    public String quest = "";
    public boolean skipIfCompleted;

    @Override
    public int execute(EventContext context) {
        if (context instanceof DialogueContext) {
            EntityPlayer player = context.data.getPlayer();
            if (this.skipIfCompleted && this.isPlayerCompletedQuest(player)) {
                return 0;
            }
            ((DialogueContext)context).setQuest(this);
        }
        return -1;
    }

    private boolean isPlayerCompletedQuest(EntityPlayer player) {
        ICharacter character;
        Quest quest = (Quest)Mappet.quests.load(this.quest);
        if (quest != null && (character = Character.get(player)) != null) {
            return character.getStates().wasQuestCompleted(this.quest);
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected String getDisplayTitle() {
        return this.quest;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = super.serializeNBT();
        tag.func_74778_a("Quest", this.quest);
        tag.func_74757_a("SkipIfCompleted", this.skipIfCompleted);
        return tag;
    }

    @Override
    public void deserializeNBT(NBTTagCompound tag) {
        super.deserializeNBT(tag);
        if (tag.func_74764_b("Quest")) {
            this.quest = tag.func_74779_i("Quest");
        }
        this.skipIfCompleted = tag.func_74767_n("SkipIfCompleted");
    }
}

