/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.misc;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import mchorse.mappet.Mappet;
import mchorse.mappet.api.misc.hotkeys.TriggerHotkeys;
import mchorse.mappet.api.triggers.Trigger;
import mchorse.mappet.events.RegisterServerTriggerEvent;
import mchorse.mappet.utils.NBTToJsonLike;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ServerSettings
implements INBTSerializable<NBTTagCompound> {
    private File file;
    private Map<String, String> keyToAlias = new HashMap<String, String>();
    public final Map<String, Trigger> registered = new LinkedHashMap<String, Trigger>();
    public final TriggerHotkeys hotkeys = new TriggerHotkeys();
    public final Trigger blockBreak;
    public final Trigger blockPlace;
    public final Trigger blockInteract;
    public final Trigger blockClick;
    public final Trigger entityDamaged;
    public final Trigger entityDeath;
    public final Trigger serverLoad;
    public final Trigger serverTick;
    public final Trigger playerChat;
    public final Trigger playerLogIn;
    public final Trigger playerLeftClick;
    public final Trigger playerRightClick;
    public final Trigger playerRespawn;
    public final Trigger playerDeath;
    public final Trigger playerItemPickup;
    public final Trigger playerCloseContainer;
    public final Trigger playerJournal;

    public Trigger register(String key, Trigger trigger) {
        return this.register(key, null, trigger);
    }

    public Trigger register(String key, String alias, Trigger trigger) {
        if (this.registered.containsKey(key)) {
            throw new IllegalStateException("Server trigger '" + key + "' is already registered!");
        }
        if (alias != null) {
            this.keyToAlias.put(key, alias);
        }
        this.registered.put(key, trigger);
        return trigger;
    }

    public ServerSettings(File file) {
        this.file = file;
        this.blockBreak = this.register("block_break", "break_block", new Trigger());
        this.blockPlace = this.register("block_place", "place_block", new Trigger());
        this.blockInteract = this.register("block_interact", "interact_block", new Trigger());
        this.blockClick = this.register("block_click", new Trigger());
        this.entityDamaged = this.register("entity_damaged", "damage_entity", new Trigger());
        this.entityDeath = this.register("entity_death", new Trigger());
        this.serverLoad = this.register("server_load", new Trigger());
        this.serverTick = this.register("server_tick", new Trigger());
        this.playerChat = this.register("player_chat", "chat", new Trigger());
        this.playerLogIn = this.register("player_login", new Trigger());
        this.playerLeftClick = this.register("player_lmb", new Trigger());
        this.playerRightClick = this.register("player_rmb", new Trigger());
        this.playerRespawn = this.register("player_respawn", new Trigger());
        this.playerDeath = this.register("player_death", new Trigger());
        this.playerItemPickup = this.register("player_item_pickup", new Trigger());
        this.playerCloseContainer = this.register("player_close_container", new Trigger());
        this.playerJournal = this.register("player_journal", new Trigger());
        Mappet.EVENT_BUS.post((Event)new RegisterServerTriggerEvent(this));
    }

    public void load() {
        if (this.file == null || !this.file.isFile()) {
            return;
        }
        try {
            File hotkeys;
            NBTTagCompound tag = NBTToJsonLike.read(this.file);
            if (!tag.func_74764_b("Hotkeys") && (hotkeys = new File(this.file.getParentFile(), "hotkeys.json")).isFile()) {
                try {
                    NBTTagCompound hotkeysTag = NBTToJsonLike.read(hotkeys);
                    tag.func_74782_a("Hotkeys", (NBTBase)hotkeysTag);
                    hotkeys.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.deserializeNBT(tag);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void save() {
        try {
            NBTToJsonLike.write(this.file, this.serializeNBT());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound triggers = new NBTTagCompound();
        for (Map.Entry<String, Trigger> entry : this.registered.entrySet()) {
            this.writeTrigger(triggers, entry.getKey(), entry.getValue());
        }
        if (!triggers.func_82582_d()) {
            tag.func_74782_a("Triggers", (NBTBase)triggers);
        }
        tag.func_74782_a("Hotkeys", (NBTBase)this.hotkeys.serializeNBT());
        return tag;
    }

    private void writeTrigger(NBTTagCompound tag, String key, Trigger trigger) {
        NBTTagCompound triggerTag;
        if (trigger != null && !(triggerTag = trigger.serializeNBT()).func_82582_d()) {
            tag.func_74782_a(key, (NBTBase)triggerTag);
        }
    }

    public void deserializeNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("Triggers")) {
            NBTTagCompound triggers = tag.func_74775_l("Triggers");
            for (Map.Entry<String, Trigger> entry : this.registered.entrySet()) {
                String oldAlias = this.keyToAlias.get(entry.getKey());
                if (triggers.func_150297_b(oldAlias, 10)) {
                    this.readTrigger(triggers, oldAlias, entry.getValue());
                    continue;
                }
                this.readTrigger(triggers, entry.getKey(), entry.getValue());
            }
        }
        if (tag.func_74764_b("Hotkeys")) {
            this.hotkeys.deserializeNBT(tag.func_74775_l("Hotkeys"));
        }
    }

    private void readTrigger(NBTTagCompound tag, String key, Trigger trigger) {
        NBTTagCompound triggerTag;
        if (tag.func_150297_b(key, 10) && !(triggerTag = tag.func_74775_l(key)).func_82582_d()) {
            trigger.deserializeNBT(triggerTag);
        }
    }
}

