/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.quests.objectives;

import mchorse.mappet.api.quests.objectives.AbstractObjective;
import mchorse.mappet.utils.InventoryUtils;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CollectObjective
extends AbstractObjective {
    public ItemStack stack = ItemStack.field_190927_a;
    public boolean ignoreNBT;

    public CollectObjective() {
    }

    public CollectObjective(ItemStack stack) {
        this.stack = stack == null ? ItemStack.field_190927_a : stack;
    }

    @Override
    public boolean isComplete(EntityPlayer player) {
        return this.countItems(player) >= this.stack.func_190916_E();
    }

    @Override
    public void complete(EntityPlayer player) {
        player.field_71071_by.func_174925_a(this.stack.func_77973_b(), -1, this.stack.func_190916_E(), null);
    }

    private int countItems(EntityPlayer player) {
        return InventoryUtils.countItems(player, this.stack, true, this.ignoreNBT);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String stringifyObjective(EntityPlayer player) {
        String name = this.stack.func_82833_r();
        int count = Math.min(this.countItems(player), this.stack.func_190916_E());
        if (!this.message.isEmpty()) {
            return this.message.replace("${name}", name).replace("${count}", String.valueOf(count)).replace("${total}", String.valueOf(this.stack.func_190916_E()));
        }
        return I18n.func_135052_a((String)"mappet.gui.quests.objective_collect.string", (Object[])new Object[]{name, count, this.stack.func_190916_E()});
    }

    @Override
    public String getType() {
        return "collect";
    }

    @Override
    public NBTTagCompound partialSerializeNBT() {
        return new NBTTagCompound();
    }

    @Override
    public void partialDeserializeNBT(NBTTagCompound tag) {
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = super.serializeNBT();
        if (!this.stack.func_190926_b()) {
            tag.func_74782_a("Item", (NBTBase)this.stack.serializeNBT());
        }
        tag.func_74757_a("IgnoreNBT", this.ignoreNBT);
        return tag;
    }

    @Override
    public void deserializeNBT(NBTTagCompound tag) {
        super.deserializeNBT(tag);
        if (tag.func_74764_b("Item")) {
            this.stack = new ItemStack(tag.func_74775_l("Item"));
        }
        this.ignoreNBT = tag.func_74767_n("IgnoreNBT");
    }
}

