/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.quests.objectives;

import mchorse.mappet.api.quests.objectives.AbstractObjective;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class KillObjective
extends AbstractObjective {
    public ResourceLocation entity = new ResourceLocation("");
    public NBTTagCompound tag;
    public int count;
    public int killed;

    public KillObjective() {
    }

    public KillObjective(ResourceLocation entity, int quantity) {
        this.entity = entity;
        this.count = quantity;
    }

    public void playerKilled(EntityPlayer player, Entity mob) {
        if (this.entity.equals((Object)EntityList.func_191301_a((Entity)mob))) {
            if (!this.compareTag(mob)) {
                return;
            }
            ++this.killed;
        }
    }

    private boolean compareTag(Entity mob) {
        if (this.tag == null) {
            return true;
        }
        NBTTagCompound tag = mob.func_189511_e(new NBTTagCompound());
        return this.compareTagPartial((NBTBase)this.tag, (NBTBase)tag);
    }

    private boolean compareTagPartial(NBTBase a, NBTBase b) {
        if (a instanceof NBTTagCompound && b instanceof NBTTagCompound) {
            NBTTagCompound tagA = (NBTTagCompound)a;
            NBTTagCompound tagB = (NBTTagCompound)b;
            for (String key : tagA.func_150296_c()) {
                NBTBase tagBase = tagB.func_74781_a(key);
                if (this.compareTagPartial(tagA.func_74781_a(key), tagBase)) continue;
                return false;
            }
            return true;
        }
        return a.equals((Object)b);
    }

    @Override
    public boolean isComplete(EntityPlayer player) {
        return this.killed >= this.count;
    }

    @Override
    public void complete(EntityPlayer player) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String stringifyObjective(EntityPlayer player) {
        String entity = EntityList.func_191302_a((ResourceLocation)this.entity);
        int count = Math.min(this.killed, this.count);
        entity = entity != null ? I18n.func_135052_a((String)("entity." + entity + ".name"), (Object[])new Object[0]) : this.entity.toString();
        if (!this.message.isEmpty()) {
            return this.message.replace("${entity}", entity).replace("${count}", String.valueOf(count)).replace("${total}", String.valueOf(this.count));
        }
        return I18n.func_135052_a((String)"mappet.gui.quests.objective_kill.string", (Object[])new Object[]{entity, count, this.count});
    }

    @Override
    public String getType() {
        return "kill";
    }

    @Override
    public NBTTagCompound partialSerializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("Killed", this.killed);
        return tag;
    }

    @Override
    public void partialDeserializeNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("Killed")) {
            this.killed = tag.func_74762_e("Killed");
        }
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = super.serializeNBT();
        tag.func_74778_a("Entity", this.entity.toString());
        if (this.tag != null) {
            tag.func_74782_a("Tag", (NBTBase)this.tag);
        }
        tag.func_74768_a("Count", this.count);
        tag.func_74768_a("Killed", this.killed);
        return tag;
    }

    @Override
    public void deserializeNBT(NBTTagCompound tag) {
        super.deserializeNBT(tag);
        this.entity = new ResourceLocation(tag.func_74779_i("Entity"));
        if (tag.func_150297_b("Tag", 10)) {
            this.tag = tag.func_74775_l("Tag");
        }
        this.count = tag.func_74762_e("Count");
        this.killed = tag.func_74762_e("Killed");
    }
}

