/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.regions.shapes;

import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import mchorse.mappet.api.regions.shapes.AbstractShape;
import mchorse.mappet.api.regions.shapes.SphereShape;
import net.minecraft.nbt.NBTTagCompound;

public class BoxShape
extends AbstractShape {
    public Vector3d size = new Vector3d(1.0, 1.0, 1.0);

    @Override
    public void copyFrom(AbstractShape shape) {
        super.copyFrom(shape);
        if (shape instanceof BoxShape) {
            this.size.set((Tuple3d)((BoxShape)shape).size);
        } else if (shape instanceof SphereShape) {
            double h = ((SphereShape)shape).horizontal;
            double v = ((SphereShape)shape).vertical;
            this.size.set(h, v, h);
        }
    }

    @Override
    public boolean isInside(double x, double y, double z) {
        double dx = x - this.pos.x;
        double dy = y - this.pos.y;
        double dz = z - this.pos.z;
        return Math.abs(dx) < this.size.x && Math.abs(dy) < this.size.y && Math.abs(dz) < this.size.z;
    }

    @Override
    public String getType() {
        return "box";
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = super.serializeNBT();
        tag.func_74780_a("SizeX", this.size.x);
        tag.func_74780_a("SizeY", this.size.y);
        tag.func_74780_a("SizeZ", this.size.z);
        return tag;
    }

    @Override
    public void deserializeNBT(NBTTagCompound tag) {
        super.deserializeNBT(tag);
        if (tag.func_74764_b("SizeX") && tag.func_74764_b("SizeY") && tag.func_74764_b("SizeZ")) {
            this.size.x = tag.func_74769_h("SizeX");
            this.size.y = tag.func_74769_h("SizeY");
            this.size.z = tag.func_74769_h("SizeZ");
        }
    }
}

