/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.scripts.code.entities;

import mchorse.mappet.api.scripts.code.ScriptRayTrace;
import mchorse.mappet.api.scripts.code.entities.ScriptNpc;
import mchorse.mappet.api.scripts.code.entities.ScriptPlayer;
import mchorse.mappet.api.scripts.code.items.ScriptItemStack;
import mchorse.mappet.api.scripts.code.mappet.MappetStates;
import mchorse.mappet.api.scripts.code.nbt.ScriptNBTCompound;
import mchorse.mappet.api.scripts.user.IScriptRayTrace;
import mchorse.mappet.api.scripts.user.data.ScriptVector;
import mchorse.mappet.api.scripts.user.entities.IScriptEntity;
import mchorse.mappet.api.scripts.user.entities.IScriptPlayer;
import mchorse.mappet.api.scripts.user.items.IScriptItemStack;
import mchorse.mappet.api.scripts.user.mappet.IMappetStates;
import mchorse.mappet.api.scripts.user.nbt.INBTCompound;
import mchorse.mappet.api.states.States;
import mchorse.mappet.client.morphs.WorldMorph;
import mchorse.mappet.entities.EntityNpc;
import mchorse.mappet.network.Dispatcher;
import mchorse.mappet.network.common.scripts.PacketEntityRotations;
import mchorse.mappet.network.common.scripts.PacketWorldMorph;
import mchorse.mappet.utils.EntityUtils;
import mchorse.mclib.utils.RayTracing;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;

public class ScriptEntity<T extends Entity>
implements IScriptEntity {
    protected T entity;
    protected IMappetStates states;

    public static IScriptEntity create(Entity entity) {
        if (entity instanceof EntityPlayerMP) {
            return new ScriptPlayer((EntityPlayerMP)entity);
        }
        if (entity instanceof EntityNpc) {
            return new ScriptNpc((EntityNpc)entity);
        }
        if (entity != null) {
            return new ScriptEntity<Entity>(entity);
        }
        return null;
    }

    protected ScriptEntity(T entity) {
        this.entity = entity;
    }

    @Override
    public Entity getMinecraftEntity() {
        return this.entity;
    }

    @Override
    public ScriptVector getPosition() {
        return new ScriptVector(((Entity)this.entity).field_70165_t, ((Entity)this.entity).field_70163_u, ((Entity)this.entity).field_70161_v);
    }

    @Override
    public void setPosition(double x, double y, double z) {
        this.entity.func_70634_a(x, y, z);
    }

    @Override
    public ScriptVector getMotion() {
        return new ScriptVector(((Entity)this.entity).field_70159_w, ((Entity)this.entity).field_70181_x, ((Entity)this.entity).field_70179_y);
    }

    @Override
    public void setMotion(double x, double y, double z) {
        ((Entity)this.entity).field_70159_w = x;
        ((Entity)this.entity).field_70181_x = y;
        ((Entity)this.entity).field_70179_y = z;
    }

    @Override
    public ScriptVector getRotations() {
        return new ScriptVector(this.getPitch(), this.getYaw(), this.getYawHead());
    }

    @Override
    public void setRotations(float pitch, float yaw, float yawHead) {
        this.entity.func_70012_b(((Entity)this.entity).field_70165_t, ((Entity)this.entity).field_70163_u, ((Entity)this.entity).field_70161_v, yaw, pitch);
        this.entity.func_70034_d(yawHead);
        if (!this.isPlayer()) {
            EntityTracker tracker = ((WorldServer)((Entity)this.entity).field_70170_p).func_73039_n();
            for (EntityPlayer player : tracker.getTrackingPlayers(this.entity)) {
                Dispatcher.sendTo(new PacketEntityRotations(this.entity.func_145782_y(), yaw, yawHead, pitch), (EntityPlayerMP)player);
            }
        }
    }

    @Override
    public float getPitch() {
        return ((Entity)this.entity).field_70125_A;
    }

    @Override
    public float getYaw() {
        return ((Entity)this.entity).field_70177_z;
    }

    @Override
    public float getYawHead() {
        return this.entity.func_70079_am();
    }

    @Override
    public ScriptVector getLook() {
        return new ScriptVector(this.entity.func_70040_Z());
    }

    @Override
    public float getWidth() {
        return ((Entity)this.entity).field_70130_N;
    }

    @Override
    public float getHeight() {
        return ((Entity)this.entity).field_70131_O;
    }

    @Override
    public float getHp() {
        if (this.isLivingBase()) {
            return ((EntityLivingBase)this.entity).func_110143_aJ();
        }
        return 0.0f;
    }

    @Override
    public void setHp(float hp) {
        if (this.isLivingBase()) {
            ((EntityLivingBase)this.entity).func_70606_j(hp);
        }
    }

    @Override
    public float getMaxHp() {
        if (this.isLivingBase()) {
            return ((EntityLivingBase)this.entity).func_110138_aP();
        }
        return 0.0f;
    }

    @Override
    public boolean isBurning() {
        return this.entity.func_70027_ad();
    }

    @Override
    public void setBurning(int seconds) {
        if (seconds <= 0) {
            this.entity.func_70066_B();
        } else {
            this.entity.func_70015_d(seconds);
        }
    }

    @Override
    public boolean isSneaking() {
        return this.entity.func_70093_af();
    }

    @Override
    public boolean isSprinting() {
        return this.entity.func_70051_ag();
    }

    @Override
    public IScriptRayTrace rayTrace(double maxDistance) {
        return new ScriptRayTrace(RayTracing.rayTraceWithEntity(this.entity, (double)maxDistance));
    }

    @Override
    public IScriptRayTrace rayTraceBlock(double maxDistance) {
        return new ScriptRayTrace(RayTracing.rayTrace(this.entity, (double)maxDistance, (float)0.0f));
    }

    @Override
    public IScriptItemStack getMainItem() {
        if (this.isLivingBase()) {
            return ScriptItemStack.create(((EntityLivingBase)this.entity).func_184614_ca());
        }
        return ScriptItemStack.EMPTY;
    }

    @Override
    public void setMainItem(IScriptItemStack stack) {
        this.setItem(EnumHand.MAIN_HAND, stack);
    }

    @Override
    public IScriptItemStack getOffItem() {
        if (this.isLivingBase()) {
            return ScriptItemStack.create(((EntityLivingBase)this.entity).func_184592_cb());
        }
        return ScriptItemStack.EMPTY;
    }

    @Override
    public void setOffItem(IScriptItemStack stack) {
        this.setItem(EnumHand.OFF_HAND, stack);
    }

    private void setItem(EnumHand hand, IScriptItemStack stack) {
        if (stack == null) {
            stack = ScriptItemStack.EMPTY;
        }
        if (this.isLivingBase()) {
            ((EntityLivingBase)this.entity).func_184611_a(hand, stack.getMinecraftItemStack().func_77946_l());
        }
    }

    @Override
    public void setSpeed(float speed) {
        if (this.isLivingBase()) {
            ((EntityLivingBase)this.entity).func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)speed);
        }
    }

    @Override
    public IScriptEntity getTarget() {
        if (this.entity instanceof EntityLiving) {
            return ScriptEntity.create((Entity)((EntityLiving)this.entity).func_70638_az());
        }
        return null;
    }

    @Override
    public void setTarget(IScriptEntity entity) {
        if (this.entity instanceof EntityLiving && entity != null && entity.isLivingBase()) {
            ((EntityLiving)this.entity).func_70624_b((EntityLivingBase)entity.getMinecraftEntity());
        }
    }

    @Override
    public boolean isAIEnabled() {
        if (this.isLivingBase()) {
            return !((EntityLiving)this.entity).func_175446_cd();
        }
        return false;
    }

    @Override
    public void setAIEnabled(boolean enabled) {
        if (this.isLivingBase()) {
            ((EntityLiving)this.entity).func_94061_f(!enabled);
        }
    }

    @Override
    public String getUniqueId() {
        return this.entity.func_189512_bd();
    }

    @Override
    public String getEntityId() {
        ResourceLocation rl = EntityList.func_191301_a(this.entity);
        return rl == null ? "" : rl.toString();
    }

    @Override
    public int getTicks() {
        return ((Entity)this.entity).field_70173_aa;
    }

    @Override
    public String getName() {
        return this.entity.func_70005_c_();
    }

    @Override
    public INBTCompound getFullData() {
        return new ScriptNBTCompound(this.entity.func_189511_e(new NBTTagCompound()));
    }

    @Override
    public void setFullData(INBTCompound data) {
        this.entity.func_70020_e(data.getNBTTagComound());
    }

    @Override
    public INBTCompound getEntityData() {
        return new ScriptNBTCompound(this.entity.getEntityData());
    }

    @Override
    public boolean isPlayer() {
        return this.entity instanceof EntityPlayer;
    }

    @Override
    public boolean isNpc() {
        return this.entity instanceof EntityNpc;
    }

    @Override
    public boolean isLivingBase() {
        return this.entity instanceof EntityLivingBase;
    }

    @Override
    public boolean isSame(IScriptEntity entity) {
        return this.entity == entity.getMinecraftEntity();
    }

    @Override
    public void damage(float health) {
        if (this.isLivingBase()) {
            this.entity.func_70097_a(DamageSource.field_76380_i, health);
        }
    }

    @Override
    public void damageAs(IScriptEntity entity, float damage) {
        if (this.isLivingBase() && entity.isLivingBase()) {
            EntityLivingBase target = (EntityLivingBase)this.entity;
            EntityLivingBase source = (EntityLivingBase)entity.getMinecraftEntity();
            target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)source), damage);
        }
    }

    @Override
    public void damageWithItemsAs(IScriptPlayer player) {
        player.getMinecraftPlayer().func_71059_n(this.entity);
    }

    @Override
    public float getFallDistance() {
        return ((Entity)this.entity).field_70143_R;
    }

    @Override
    public void setFallDistance(float distance) {
        ((Entity)this.entity).field_70143_R = distance;
    }

    @Override
    public void remove() {
        this.entity.func_70106_y();
    }

    @Override
    public void kill() {
        this.entity.func_174812_G();
    }

    @Override
    public void swingArm(int arm) {
        if (this.isLivingBase()) {
            ((EntityLivingBase)this.entity).func_184609_a(arm == 1 ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND);
        }
    }

    @Override
    public void applyPotion(Potion potion, int duration, int amplifier, boolean particles) {
        if (this.isLivingBase()) {
            PotionEffect effect = new PotionEffect(potion, duration, amplifier, false, particles);
            ((EntityLivingBase)this.entity).func_70690_d(effect);
        }
    }

    @Override
    public boolean hasPotion(Potion potion) {
        if (this.isLivingBase()) {
            return ((EntityLivingBase)this.entity).func_70644_a(potion);
        }
        return false;
    }

    @Override
    public boolean removePotion(Potion potion) {
        if (this.isLivingBase()) {
            EntityLivingBase entity = (EntityLivingBase)this.entity;
            int size = entity.func_193076_bZ().size();
            entity.func_184589_d(potion);
            return size != entity.func_193076_bZ().size();
        }
        return false;
    }

    @Override
    public void clearPotions() {
        if (this.isLivingBase()) {
            ((EntityLivingBase)this.entity).func_70674_bp();
        }
    }

    @Override
    public IMappetStates getStates() {
        States states;
        if (this.states == null && (states = EntityUtils.getStates(this.entity)) != null) {
            this.states = new MappetStates(states);
        }
        return this.states;
    }

    @Override
    public boolean setMorph(AbstractMorph morph) {
        return false;
    }

    @Override
    public void displayMorph(AbstractMorph morph, int expiration, double x, double y, double z, float yaw, float pitch, boolean rotate) {
        if (morph == null) {
            return;
        }
        WorldMorph worldMorph = new WorldMorph();
        worldMorph.morph = morph;
        worldMorph.expiration = expiration;
        worldMorph.rotate = rotate;
        worldMorph.x = x;
        worldMorph.y = y;
        worldMorph.z = z;
        worldMorph.yaw = yaw;
        worldMorph.pitch = pitch;
        worldMorph.entity = this.entity;
        PacketWorldMorph message = new PacketWorldMorph(worldMorph);
        Dispatcher.sendToTracked(this.entity, message);
        if (this.isPlayer()) {
            Dispatcher.sendTo(message, (EntityPlayerMP)this.entity);
        }
    }
}

