/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.states;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import mchorse.mappet.Mappet;
import mchorse.mappet.events.StateChangedEvent;
import mchorse.mappet.utils.Utils;
import mchorse.mclib.utils.JsonUtils;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.commons.io.FileUtils;

public class States
implements INBTSerializable<NBTTagCompound> {
    public static final String QUEST_PREFIX = "quests.";
    public static final String DIALOGUE_PREFIX = "dialogue.";
    public static final String FACTIONS_PREFIX = "factions.";
    public Map<String, Object> values = new HashMap<String, Object>();
    private File file;

    public States() {
    }

    public States(File file) {
        this.file = file;
    }

    protected void post(String id, Object previous, Object current) {
        Mappet.EVENT_BUS.post((Event)new StateChangedEvent(this, id, previous, current));
    }

    public void add(String id, double value) {
        Object previous = this.values.get(id);
        if (previous == null || previous instanceof Number) {
            this.values.put(id, (previous == null ? 0.0 : ((Number)previous).doubleValue()) + value);
            this.post(id, previous, value);
        }
    }

    public void setNumber(String id, double value) {
        Object previous = this.values.get(id);
        this.values.put(id, value);
        this.post(id, previous, value);
    }

    public void setString(String id, String value) {
        Object previous = this.values.get(id);
        this.values.put(id, value);
        this.post(id, previous, value);
    }

    public double getNumber(String id) {
        Object object = this.values.get(id);
        return object instanceof Number ? ((Number)object).doubleValue() : 0.0;
    }

    public String getString(String id) {
        Object object = this.values.get(id);
        return object instanceof String ? (String)object : "";
    }

    public boolean reset(String id) {
        Object previous = this.values.remove(id);
        this.post(id, previous, null);
        return previous != null;
    }

    public boolean resetMasked(String id) {
        if (id.trim().equals("*")) {
            boolean wasEmpty = this.values.isEmpty();
            if (!wasEmpty) {
                this.clear();
            }
            return !wasEmpty;
        }
        if (id.contains("*")) {
            id = id.replaceAll("\\*", ".*");
            Pattern pattern = Pattern.compile("^" + id + "$");
            int size = this.values.size();
            this.values.keySet().removeIf(key -> pattern.matcher((CharSequence)key).matches());
            if (this.values.size() != size) {
                this.post(null, null, null);
                return true;
            }
            return false;
        }
        return this.reset(id);
    }

    public void clear() {
        this.values.clear();
        this.post(null, null, null);
    }

    public void copy(States states) {
        this.values.clear();
        this.values.putAll(states.values);
        this.post(null, null, null);
    }

    public void completeQuest(String id) {
        this.add(QUEST_PREFIX + id, 1.0);
    }

    public int getQuestCompletedTimes(String id) {
        return (int)this.getNumber(QUEST_PREFIX + id);
    }

    public boolean wasQuestCompleted(String id) {
        return this.getQuestCompletedTimes(id) > 0;
    }

    public void addFactionScore(String id, int score, int defaultScore) {
        if (this.hasFaction(id)) {
            this.add(FACTIONS_PREFIX + id, score);
        } else {
            this.setNumber(FACTIONS_PREFIX + id, defaultScore + score);
        }
    }

    public void setFactionScore(String id, int score) {
        this.setNumber(FACTIONS_PREFIX + id, score);
    }

    public int getFactionScore(String id) {
        return (int)this.getNumber(FACTIONS_PREFIX + id);
    }

    public boolean clearFactionScore(String id) {
        return this.reset(FACTIONS_PREFIX + id);
    }

    public void clearAllFactionScores() {
        this.values.keySet().removeIf(key -> key.startsWith(FACTIONS_PREFIX));
    }

    public boolean hasFaction(String id) {
        return this.values.containsKey(FACTIONS_PREFIX + id);
    }

    public void readDialogue(String id, String marker) {
        this.add(this.getDialogueId(id, marker), 1.0);
    }

    public boolean hasReadDialogue(String id, String marker) {
        return this.getReadDialogueTimes(id, marker) > 0;
    }

    public int getReadDialogueTimes(String id, String marker) {
        return (int)this.getNumber(this.getDialogueId(id, marker));
    }

    private String getDialogueId(String id, String marker) {
        id = DIALOGUE_PREFIX + id;
        if (marker != null && !marker.isEmpty()) {
            id = id + ":" + marker;
        }
        return id;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        for (Map.Entry<String, Object> entry : this.values.entrySet()) {
            if (entry.getValue() instanceof Number) {
                tag.func_74780_a(entry.getKey(), ((Number)entry.getValue()).doubleValue());
                continue;
            }
            if (!(entry.getValue() instanceof String)) continue;
            tag.func_74778_a(entry.getKey(), (String)entry.getValue());
        }
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        this.values.clear();
        for (String key : tag.func_150296_c()) {
            NBTBase base = tag.func_74781_a(key);
            if (base.func_74732_a() == 8) {
                this.values.put(key, ((NBTTagString)base).func_150285_a_());
                continue;
            }
            if (!(base instanceof NBTPrimitive)) continue;
            this.values.put(key, ((NBTPrimitive)base).func_150286_g());
        }
    }

    public void load() {
        if (!this.file.exists()) {
            return;
        }
        try {
            String json = FileUtils.readFileToString((File)this.file, (Charset)Utils.getCharset());
            this.values = (Map)new Gson().fromJson(json, new TypeToken<Map<String, Double>>(){}.getType());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean save() {
        try {
            String json = JsonUtils.jsonToPretty((JsonElement)new Gson().toJsonTree(this.values));
            FileUtils.writeStringToFile((File)this.file, (String)json, (Charset)Utils.getCharset());
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

