/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.ui.components;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mchorse.mappet.api.ui.UIContext;
import mchorse.mappet.api.ui.utils.DiscardMethod;
import mchorse.mappet.api.ui.utils.UIContextItem;
import mchorse.mappet.api.ui.utils.UIKeybind;
import mchorse.mappet.api.ui.utils.UIUnit;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.context.GuiSimpleContextMenu;
import mchorse.mclib.client.gui.utils.Icon;
import mchorse.mclib.client.gui.utils.IconRegistry;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.Keybind;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.utils.Direction;
import mchorse.mclib.utils.TextUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class UIComponent
implements INBTSerializable<NBTTagCompound> {
    public static final int DELAY = 200;
    public String id = "";
    public String tooltip = "";
    public boolean visible = true;
    public boolean enabled = true;
    public int tooltipDirection;
    public int marginTop;
    public int marginBottom;
    public int marginLeft;
    public int marginRight;
    public UIUnit x = new UIUnit();
    public UIUnit y = new UIUnit();
    public UIUnit w = new UIUnit();
    public UIUnit h = new UIUnit();
    public int updateDelay = this.getDefaultUpdateDelay();
    public List<UIKeybind> keybinds = new ArrayList<UIKeybind>();
    public List<UIContextItem> context = new ArrayList<UIContextItem>();
    protected Set<String> changedProperties = new HashSet<String>();

    public UIComponent id(String id) {
        this.id = id;
        return this;
    }

    public UIComponent tooltip(String tooltip) {
        return this.tooltip(tooltip, 0);
    }

    public UIComponent tooltip(String tooltip, int direction) {
        this.change("Tooltip");
        this.tooltip = tooltip;
        this.tooltipDirection = direction;
        return this;
    }

    public UIComponent visible(boolean visible) {
        this.change("Visible");
        this.visible = visible;
        return this;
    }

    public UIComponent enabled(boolean enabled) {
        this.change("Enabled");
        this.enabled = enabled;
        return this;
    }

    public UIComponent margin(int margin) {
        this.change("Margin");
        this.marginTop = margin;
        this.marginBottom = margin;
        this.marginLeft = margin;
        this.marginRight = margin;
        return this;
    }

    public UIComponent marginTop(int margin) {
        this.change("Margin");
        this.marginTop = margin;
        return this;
    }

    public UIComponent marginBottom(int margin) {
        this.change("Margin");
        this.marginBottom = margin;
        return this;
    }

    public UIComponent marginLeft(int margin) {
        this.change("Margin");
        this.marginLeft = margin;
        return this;
    }

    public UIComponent marginRight(int margin) {
        this.change("Margin");
        this.marginRight = margin;
        return this;
    }

    public UIComponent keybind(int keyCode, String action, String label) {
        return this.keybind(keyCode, action, label, false, false, false);
    }

    public UIComponent keybind(int keyCode, String action, String label, boolean ctrl) {
        return this.keybind(keyCode, action, label, ctrl, false, false);
    }

    public UIComponent keybind(int keyCode, String action, String label, boolean ctrl, boolean shift) {
        return this.keybind(keyCode, action, label, ctrl, shift, false);
    }

    public UIComponent keybind(int keyCode, String action, String label, boolean ctrl, boolean shift, boolean alt) {
        this.change("Keybinds");
        this.keybinds.add(new UIKeybind(keyCode, action, label, UIKeybind.createModifier(shift, ctrl, alt)));
        return this;
    }

    public UIComponent context(String icon, String action, String label) {
        return this.context(icon, action, label, 0);
    }

    public UIComponent context(String icon, String action, String label, int color) {
        this.change("Context");
        this.context.add(new UIContextItem(icon, action, label, color));
        return this;
    }

    public UIComponent x(int value) {
        this.change("X");
        this.x.value = 0.0f;
        this.x.offset = value;
        return this;
    }

    public UIComponent rx(float value) {
        return this.rx(value, 0);
    }

    public UIComponent rx(float value, int offset) {
        this.change("X");
        this.x.value = value;
        this.x.offset = offset;
        return this;
    }

    public UIComponent y(int value) {
        this.change("Y");
        this.y.value = 0.0f;
        this.y.offset = value;
        return this;
    }

    public UIComponent ry(float value) {
        return this.ry(value, 0);
    }

    public UIComponent ry(float value, int offset) {
        this.change("Y");
        this.y.value = value;
        this.y.offset = offset;
        return this;
    }

    public UIComponent w(int value) {
        this.change("W");
        this.w.value = 0.0f;
        this.w.offset = value;
        return this;
    }

    public UIComponent rw(float value) {
        return this.rw(value, 0);
    }

    public UIComponent rw(float value, int offset) {
        this.change("W");
        this.w.value = value;
        this.w.offset = offset;
        return this;
    }

    public UIComponent h(int value) {
        this.change("H");
        this.h.value = 0.0f;
        this.h.offset = value;
        return this;
    }

    public UIComponent rh(float value) {
        return this.rh(value, 0);
    }

    public UIComponent rh(float value, int offset) {
        this.change("H");
        this.h.value = value;
        this.h.offset = offset;
        return this;
    }

    public UIComponent xy(int x, int y) {
        return this.x(x).y(y);
    }

    public UIComponent rxy(float x, float y) {
        return this.rx(x).ry(y);
    }

    public UIComponent wh(int w, int h) {
        return this.w(w).h(h);
    }

    public UIComponent rwh(float w, float h) {
        return this.rw(w).rh(h);
    }

    public UIComponent anchor(float anchor) {
        return this.anchor(anchor, anchor);
    }

    public UIComponent anchor(float anchorX, float anchorY) {
        return this.anchorX(anchorX).anchorY(anchorY);
    }

    public UIComponent anchorX(float anchor) {
        this.change("X");
        this.x.anchor = anchor;
        return this;
    }

    public UIComponent anchorY(float anchor) {
        this.change("Y");
        this.y.anchor = anchor;
        return this;
    }

    public UIComponent updateDelay(int updateDelay) {
        this.change("UpdateDelay");
        this.updateDelay = updateDelay;
        return this;
    }

    @DiscardMethod
    protected int getDefaultUpdateDelay() {
        return 0;
    }

    @DiscardMethod
    @SideOnly(value=Side.CLIENT)
    protected GuiElement apply(GuiElement element, UIContext context) {
        if (!this.tooltip.isEmpty()) {
            this.applyTooltip(element);
        }
        element.setVisible(this.visible);
        element.setEnabled(this.enabled);
        element.marginTop(this.marginTop);
        element.marginBottom(this.marginBottom);
        element.marginLeft(this.marginLeft);
        element.marginRight(this.marginRight);
        this.x.apply(element.flex().x, context);
        this.y.apply(element.flex().y, context);
        this.w.apply(element.flex().w, context);
        this.h.apply(element.flex().h, context);
        if (!this.id.isEmpty()) {
            context.registerElement(this.id, element, this.isDataReserved());
        }
        this.applyKeybinds(element, context);
        this.applyContext(element, context);
        return element;
    }

    @DiscardMethod
    @SideOnly(value=Side.CLIENT)
    protected GuiElement applyKeybinds(GuiElement element, UIContext context) {
        element.keys().keybinds.clear();
        for (UIKeybind keybind : this.keybinds) {
            Keybind key = element.keys().register(IKey.str((String)keybind.label), keybind.keyCode, () -> context.sendKey(keybind.action));
            ArrayList<Integer> held = new ArrayList<Integer>();
            if (keybind.isCtrl()) {
                held.add(29);
            }
            if (keybind.isShift()) {
                held.add(42);
            }
            if (keybind.isAlt()) {
                held.add(56);
            }
            if (held.isEmpty()) continue;
            key.held(held.stream().mapToInt(i -> i).toArray());
        }
        return element;
    }

    @DiscardMethod
    @SideOnly(value=Side.CLIENT)
    protected boolean isDataReserved() {
        return false;
    }

    @DiscardMethod
    @SideOnly(value=Side.CLIENT)
    private void applyTooltip(GuiElement element) {
        Direction direction = Direction.BOTTOM;
        if (this.tooltipDirection == 1) {
            direction = Direction.TOP;
        } else if (this.tooltipDirection == 2) {
            direction = Direction.RIGHT;
        } else if (this.tooltipDirection == 3) {
            direction = Direction.LEFT;
        }
        if (this.tooltip.trim().isEmpty()) {
            element.tooltip = null;
        } else {
            element.tooltip(IKey.str((String)TextUtils.processColoredText((String)this.tooltip)), direction);
        }
    }

    @DiscardMethod
    @SideOnly(value=Side.CLIENT)
    private void applyContext(GuiElement element, UIContext context) {
        if (this.context.isEmpty()) {
            this.resetContext(element, context);
        } else {
            element.context(() -> {
                GuiSimpleContextMenu menu = new GuiSimpleContextMenu(Minecraft.func_71410_x());
                this.createContext(menu, element, context);
                return menu;
            });
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void resetContext(GuiElement element, UIContext context) {
        element.context(null);
    }

    @SideOnly(value=Side.CLIENT)
    protected void createContext(GuiSimpleContextMenu menu, GuiElement element, UIContext context) {
        for (UIContextItem item : this.context) {
            Runnable runnable = () -> context.sendContext(item.action);
            Icon icon = (Icon)IconRegistry.icons.get(item.icon);
            if (icon == null) {
                icon = Icons.NONE;
            }
            if (item.color > 0) {
                menu.action(icon, IKey.str((String)item.label), runnable, item.color);
                continue;
            }
            menu.action(icon, IKey.str((String)item.label), runnable);
        }
    }

    @DiscardMethod
    protected void change(String ... properties) {
        this.changedProperties.addAll(Arrays.asList(properties));
    }

    @DiscardMethod
    public void clearChanges() {
        this.changedProperties.clear();
    }

    @DiscardMethod
    public Set<String> getChanges() {
        return Collections.unmodifiableSet(this.changedProperties);
    }

    @DiscardMethod
    @SideOnly(value=Side.CLIENT)
    public void handleChanges(UIContext context, NBTTagCompound changes, GuiElement element) {
        this.deserializeNBT(changes);
        for (String key : changes.func_150296_c()) {
            this.applyProperty(context, key, element);
        }
    }

    @DiscardMethod
    @SideOnly(value=Side.CLIENT)
    protected void applyProperty(UIContext context, String key, GuiElement element) {
        if (key.equals("Tooltip")) {
            this.applyTooltip(element);
        } else if (key.equals("Visible")) {
            element.setVisible(this.visible);
        } else if (key.equals("Enabled")) {
            element.setEnabled(this.enabled);
        } else if (key.equals("Margin")) {
            element.marginTop(this.marginTop);
            element.marginBottom(this.marginBottom);
            element.marginLeft(this.marginLeft);
            element.marginRight(this.marginRight);
        } else if (key.equals("X")) {
            this.x.apply(element.flex().x, context);
        } else if (key.equals("Y")) {
            this.y.apply(element.flex().y, context);
        } else if (key.equals("W")) {
            this.w.apply(element.flex().w, context);
        } else if (key.equals("H")) {
            this.h.apply(element.flex().h, context);
        } else if (key.equals("Keybinds")) {
            this.applyKeybinds(element, context);
        } else if (key.equals("Context")) {
            this.applyContext(element, context);
        }
    }

    @DiscardMethod
    @SideOnly(value=Side.CLIENT)
    public abstract GuiElement create(Minecraft var1, UIContext var2);

    @DiscardMethod
    public void populateData(NBTTagCompound tag) {
    }

    @DiscardMethod
    public List<UIComponent> getChildComponents() {
        return Collections.emptyList();
    }

    @DiscardMethod
    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        this.serializeNBT(tag);
        return tag;
    }

    @DiscardMethod
    public void serializeNBT(NBTTagCompound tag) {
        tag.func_74778_a("Id", this.id);
        NBTTagCompound tooltip = new NBTTagCompound();
        tooltip.func_74778_a("Label", this.tooltip);
        tooltip.func_74768_a("Direction", this.tooltipDirection);
        tag.func_74782_a("Tooltip", (NBTBase)tooltip);
        tag.func_74757_a("Visible", this.visible);
        tag.func_74757_a("Enabled", this.enabled);
        NBTTagList margins = new NBTTagList();
        margins.func_74742_a((NBTBase)new NBTTagInt(this.marginTop));
        margins.func_74742_a((NBTBase)new NBTTagInt(this.marginBottom));
        margins.func_74742_a((NBTBase)new NBTTagInt(this.marginLeft));
        margins.func_74742_a((NBTBase)new NBTTagInt(this.marginRight));
        tag.func_74782_a("Margin", (NBTBase)margins);
        tag.func_74782_a("X", (NBTBase)this.x.serializeNBT());
        tag.func_74782_a("Y", (NBTBase)this.y.serializeNBT());
        tag.func_74782_a("W", (NBTBase)this.w.serializeNBT());
        tag.func_74782_a("H", (NBTBase)this.h.serializeNBT());
        tag.func_74768_a("UpdateDelay", this.updateDelay);
        NBTTagList keybinds = new NBTTagList();
        for (UIKeybind keybind : this.keybinds) {
            keybinds.func_74742_a((NBTBase)keybind.serializeNBT());
        }
        tag.func_74782_a("Keybinds", (NBTBase)keybinds);
        NBTTagList context = new NBTTagList();
        for (UIContextItem contextItem : this.context) {
            context.func_74742_a((NBTBase)contextItem.serializeNBT());
        }
        tag.func_74782_a("Context", (NBTBase)context);
    }

    @DiscardMethod
    public void deserializeNBT(NBTTagCompound tag) {
        int i;
        int c;
        NBTTagList margins;
        if (tag.func_74764_b("Id")) {
            this.id = tag.func_74779_i("Id");
        }
        if (tag.func_150297_b("Tooltip", 10)) {
            NBTTagCompound tooltip = tag.func_74775_l("Tooltip");
            this.tooltip = tooltip.func_74779_i("Label");
            this.tooltipDirection = tooltip.func_74762_e("Direction");
        }
        if (tag.func_74764_b("Visible")) {
            this.visible = tag.func_74767_n("Visible");
        }
        if (tag.func_74764_b("Enabled")) {
            this.enabled = tag.func_74767_n("Enabled");
        }
        if (tag.func_74764_b("Margin") && (margins = tag.func_150295_c("Margin", 3)).func_74745_c() >= 4) {
            this.marginTop = margins.func_186858_c(0);
            this.marginBottom = margins.func_186858_c(1);
            this.marginLeft = margins.func_186858_c(2);
            this.marginRight = margins.func_186858_c(3);
        }
        if (tag.func_74764_b("X")) {
            this.x.deserializeNBT(tag.func_74775_l("X"));
        }
        if (tag.func_74764_b("Y")) {
            this.y.deserializeNBT(tag.func_74775_l("Y"));
        }
        if (tag.func_74764_b("W")) {
            this.w.deserializeNBT(tag.func_74775_l("W"));
        }
        if (tag.func_74764_b("H")) {
            this.h.deserializeNBT(tag.func_74775_l("H"));
        }
        if (tag.func_74764_b("UpdateDelay")) {
            this.updateDelay = tag.func_74762_e("UpdateDelay");
        }
        if (tag.func_74764_b("Keybinds")) {
            this.keybinds.clear();
            NBTTagList keybinds = tag.func_150295_c("Keybinds", 10);
            c = keybinds.func_74745_c();
            for (i = 0; i < c; ++i) {
                UIKeybind keybind = new UIKeybind();
                keybind.deserializeNBT(keybinds.func_150305_b(i));
                this.keybinds.add(keybind);
            }
        }
        if (tag.func_74764_b("Context")) {
            this.context.clear();
            NBTTagList context = tag.func_150295_c("Context", 10);
            c = context.func_74745_c();
            for (i = 0; i < c; ++i) {
                UIContextItem contextItem = new UIContextItem();
                contextItem.deserializeNBT(context.func_150305_b(i));
                this.context.add(contextItem);
            }
        }
    }
}

