/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.ui.components;

import mchorse.mappet.api.ui.UIContext;
import mchorse.mappet.api.ui.components.UILabelBaseComponent;
import mchorse.mappet.api.ui.utils.DiscardMethod;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiLabel;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.keys.IKey;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class UILabelComponent
extends UILabelBaseComponent {
    public Integer background;
    public float anchorX;
    public float anchorY;

    public UILabelComponent background(int background) {
        this.change("Background");
        this.background = background;
        return this;
    }

    public UILabelComponent labelAnchor(float anchor) {
        return this.labelAnchor(anchor, anchor);
    }

    public UILabelComponent labelAnchor(float anchorX, float anchorY) {
        this.change("AnchorX", "AnchorY");
        this.anchorX = anchorX;
        this.anchorY = anchorY;
        return this;
    }

    @Override
    @DiscardMethod
    @SideOnly(value=Side.CLIENT)
    public GuiElement create(Minecraft mc, UIContext context) {
        GuiLabel label = Elements.label((IKey)IKey.str((String)this.getLabel()));
        if (this.background != null) {
            label.background(this.background.intValue());
        }
        label.anchor(this.anchorX, this.anchorY);
        return this.apply((GuiElement)label, context);
    }

    @Override
    @DiscardMethod
    @SideOnly(value=Side.CLIENT)
    protected void applyProperty(UIContext context, String key, GuiElement element) {
        super.applyProperty(context, key, element);
        GuiLabel label = (GuiLabel)element;
        if (key.equals("Label")) {
            label.label = IKey.str((String)this.getLabel());
        } else if (key.equals("Background")) {
            label.background = this.background;
        } else if (key.equals("AnchorX")) {
            label.anchorX = this.anchorX;
        } else if (key.equals("AnchorY")) {
            label.anchorY = this.anchorY;
        }
    }

    @Override
    @DiscardMethod
    public void serializeNBT(NBTTagCompound tag) {
        super.serializeNBT(tag);
        if (this.background != null) {
            tag.func_74768_a("Background", this.background.intValue());
        }
        tag.func_74776_a("AnchorX", this.anchorX);
        tag.func_74776_a("AnchorY", this.anchorY);
    }

    @Override
    @DiscardMethod
    public void deserializeNBT(NBTTagCompound tag) {
        super.deserializeNBT(tag);
        if (tag.func_74764_b("Background")) {
            this.background = tag.func_74762_e("Background");
        }
        if (tag.func_74764_b("AnchorX")) {
            this.anchorX = tag.func_74760_g("AnchorX");
        }
        if (tag.func_74764_b("AnchorY")) {
            this.anchorY = tag.func_74760_g("AnchorY");
        }
    }
}

