/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.api.ui.utils;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;

public class UIKeybind
implements INBTSerializable<NBTTagCompound> {
    public int keyCode;
    public String action;
    public String label;
    public int modifier;

    public static int createModifier(boolean shift, boolean ctrl, boolean alt) {
        int modifier = shift ? 1 : 0;
        modifier += (ctrl ? 1 : 0) << 1;
        return modifier += (alt ? 1 : 0) << 2;
    }

    public UIKeybind() {
    }

    public UIKeybind(int keyCode, String action, String label, int modifier) {
        this.keyCode = keyCode;
        this.action = action;
        this.label = label;
        this.modifier = modifier;
    }

    public boolean isShift() {
        return (this.modifier & 1) == 1;
    }

    public boolean isCtrl() {
        return (this.modifier >> 1 & 1) == 1;
    }

    public boolean isAlt() {
        return (this.modifier >> 2 & 1) == 1;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("KeyCode", this.keyCode);
        tag.func_74778_a("Action", this.action);
        tag.func_74778_a("Label", this.label);
        tag.func_74768_a("Modifier", this.modifier);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        this.keyCode = tag.func_74762_e("KeyCode");
        this.action = tag.func_74779_i("Action");
        this.label = tag.func_74779_i("Label");
        this.modifier = tag.func_74762_e("Modifier");
    }
}

