/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.capabilities.character;

import java.time.Instant;
import mchorse.mappet.api.crafting.CraftingTable;
import mchorse.mappet.api.dialogues.Dialogue;
import mchorse.mappet.api.dialogues.DialogueContext;
import mchorse.mappet.api.quests.Quests;
import mchorse.mappet.api.states.States;
import mchorse.mappet.api.ui.UIContext;
import mchorse.mappet.capabilities.character.CharacterProvider;
import mchorse.mappet.capabilities.character.ICharacter;
import mchorse.mappet.utils.CurrentSession;
import mchorse.mappet.utils.PositionCache;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class Character
implements ICharacter {
    private Quests quests = new Quests();
    private States states = new States();
    private CraftingTable table;
    private Dialogue dialogue;
    private DialogueContext dialogueContext;
    private Instant lastClear = Instant.now();
    private PositionCache positionCache = new PositionCache();
    private CurrentSession session = new CurrentSession();
    private UIContext uiContext;
    private String skin;

    public static ICharacter get(EntityPlayer player) {
        return player == null ? null : (ICharacter)player.getCapability(CharacterProvider.CHARACTER, null);
    }

    @Override
    public States getStates() {
        return this.states;
    }

    @Override
    public Quests getQuests() {
        return this.quests;
    }

    @Override
    public void setCraftingTable(CraftingTable table) {
        this.table = table;
    }

    @Override
    public CraftingTable getCraftingTable() {
        return this.table;
    }

    @Override
    public void setDialogue(Dialogue dialogue, DialogueContext context) {
        if (dialogue == null && this.dialogue != null) {
            this.dialogue.onClose.trigger(this.dialogueContext.data);
        }
        this.dialogue = dialogue;
        this.dialogueContext = context;
    }

    @Override
    public Dialogue getDialogue() {
        return this.dialogue;
    }

    @Override
    public DialogueContext getDialogueContext() {
        return this.dialogueContext;
    }

    @Override
    public Instant getLastClear() {
        return this.lastClear;
    }

    @Override
    public void updateLastClear(Instant instant) {
        this.lastClear = instant;
    }

    @Override
    public PositionCache getPositionCache() {
        return this.positionCache;
    }

    @Override
    public CurrentSession getCurrentSession() {
        return this.session;
    }

    @Override
    public void copy(ICharacter character, EntityPlayer player) {
        this.quests.copy(character.getQuests());
        this.states.copy(character.getStates());
        this.lastClear = character.getLastClear();
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("Quests", (NBTBase)this.quests.serializeNBT());
        tag.func_74782_a("States", (NBTBase)this.states.serializeNBT());
        tag.func_74778_a("LastClear", this.lastClear.toString());
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("Quests")) {
            this.quests.deserializeNBT(tag.func_74775_l("Quests"));
        }
        if (tag.func_74764_b("States")) {
            this.states.deserializeNBT(tag.func_74775_l("States"));
        }
        if (tag.func_74764_b("LastClear")) {
            try {
                this.lastClear = Instant.parse(tag.func_74779_i("LastClear"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public UIContext getUIContext() {
        return this.uiContext;
    }

    @Override
    public void setUIContext(UIContext context) {
        this.uiContext = context;
    }

    @Override
    public String getSkin() {
        return this.skin;
    }

    @Override
    public void setSkin(String skin) {
        if (this.skin == null) {
            this.skin = skin;
        }
    }
}

