/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.panels;

import mchorse.mappet.api.crafting.CraftingRecipe;
import mchorse.mappet.api.crafting.CraftingTable;
import mchorse.mappet.api.utils.ContentType;
import mchorse.mappet.client.gui.GuiMappetDashboard;
import mchorse.mappet.client.gui.crafting.GuiCraftingRecipeEditor;
import mchorse.mappet.client.gui.crafting.GuiCraftingRecipeList;
import mchorse.mappet.client.gui.panels.GuiMappetRunPanel;
import mchorse.mclib.client.gui.framework.elements.GuiScrollElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.context.GuiSimpleContextMenu;
import mchorse.mclib.client.gui.framework.elements.input.GuiTextElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;

public class GuiCraftingTablePanel
extends GuiMappetRunPanel<CraftingTable> {
    public static final IKey ACTION = IKey.lang((String)"mappet.gui.crafting.action");
    public static final IKey TITLE = IKey.lang((String)"mappet.gui.crafting.title");
    public static final IKey EMPTY_TABLE = IKey.lang((String)"mappet.gui.crafting.info.empty");
    public static final IKey EMPTY_RECIPE = IKey.lang((String)"mappet.gui.crafting.info.empty_recipe");
    public GuiTextElement title;
    public GuiTextElement action;
    public GuiCraftingRecipeEditor recipe;
    public GuiCraftingRecipeList recipes;

    public GuiCraftingTablePanel(Minecraft mc, GuiMappetDashboard dashboard) {
        super(mc, dashboard);
        this.title = new GuiTextElement(mc, 1000, text -> {
            ((CraftingTable)this.data).title = text;
        });
        this.action = new GuiTextElement(mc, 1000, text -> {
            ((CraftingTable)this.data).action = text;
        });
        this.recipes = new GuiCraftingRecipeList(mc, list -> this.pickRecipe((CraftingRecipe)list.get(0), false));
        this.recipes.sorting().context(() -> {
            GuiSimpleContextMenu menu = new GuiSimpleContextMenu(this.mc).action(Icons.ADD, IKey.lang((String)"mappet.gui.crafting.context.add"), this::addRecipe);
            if (!this.recipes.isDeselected()) {
                menu.action(Icons.REMOVE, IKey.lang((String)"mappet.gui.crafting.context.remove"), this::removeRecipe, 0xFF0033);
            }
            return menu;
        });
        GuiScrollElement scrollEditor = this.createScrollEditor();
        this.recipe = new GuiCraftingRecipeEditor(mc);
        int y = 52;
        this.title.flex().relative(this.editor).x(10).y(22).wTo((IResizer)this.action.area, -5);
        this.action.flex().relative(this.editor).x(0.65f).y(22).wTo((IResizer)this.editor.area, 1.0f, -10);
        this.recipes.flex().relative(this.editor).y(y).w(120).h(1.0f, -y);
        scrollEditor.flex().x(120).y(y).w(1.0f, -120).h(1.0f, -y).column(0).padding(0);
        this.editor.add(new IGuiElement[]{this.action, this.title, this.recipes, scrollEditor});
        scrollEditor.add((IGuiElement)this.recipe);
        this.fill(null);
    }

    private void pickRecipe(CraftingRecipe recipe, boolean select) {
        this.recipe.setVisible(recipe != null);
        if (recipe != null) {
            this.recipe.set(recipe);
            this.editor.resize();
            if (select) {
                this.recipes.setCurrentScroll(recipe);
            }
        }
    }

    private void addRecipe() {
        CraftingRecipe recipe = new CraftingRecipe();
        ((CraftingTable)this.data).recipes.add(recipe);
        this.pickRecipe(recipe, true);
        this.editor.resize();
        this.recipes.update();
    }

    private void removeRecipe() {
        int index = this.recipes.getIndex();
        ((CraftingTable)this.data).recipes.remove(this.recipes.getCurrentFirst());
        if (index > 0) {
            --index;
        }
        this.pickRecipe(((CraftingTable)this.data).recipes.isEmpty() ? null : ((CraftingTable)this.data).recipes.get(index), true);
        this.recipes.update();
    }

    @Override
    protected void run(EntityPlayerSP player) {
        this.save();
        this.save = false;
        player.func_71165_d("/mp crafting open " + player.func_110124_au().toString() + " " + ((CraftingTable)this.data).getId());
    }

    @Override
    public ContentType getType() {
        return ContentType.CRAFTING_TABLE;
    }

    @Override
    public String getTitle() {
        return "mappet.gui.panels.crafting";
    }

    @Override
    public void fill(CraftingTable data, boolean allowed) {
        super.fill(data, allowed);
        this.title.setVisible(data != null);
        this.action.setVisible(data != null);
        this.editor.setVisible(data != null);
        this.recipes.setVisible(data != null);
        if (data != null) {
            this.title.setText(((CraftingTable)this.data).title);
            this.action.setText(((CraftingTable)this.data).action);
            this.recipes.setList(((CraftingTable)this.data).recipes);
            this.pickRecipe(((CraftingTable)this.data).recipes.isEmpty() ? null : ((CraftingTable)this.data).recipes.get(0), true);
            this.resize();
        }
    }

    @Override
    public void draw(GuiContext context) {
        int x;
        int w;
        if (this.title.isVisible()) {
            this.font.func_175063_a(TITLE.get(), (float)this.title.area.x, (float)(this.title.area.y - 12), 0xFFFFFF);
            this.font.func_175063_a(ACTION.get(), (float)this.action.area.x, (float)(this.action.area.y - 12), 0xFFFFFF);
        }
        if (!this.editor.isVisible()) {
            w = (this.editor.area.ex() - this.area.x) / 2;
            x = (this.area.x + this.editor.area.ex()) / 2 - w / 2;
            GuiDraw.drawMultiText((FontRenderer)this.font, (String)EMPTY_TABLE.get(), (int)x, (int)this.area.my(), (int)0xFFFFFF, (int)w, (int)12, (float)0.5f, (float)0.5f);
        }
        if (this.editor.isVisible() && !this.recipe.isVisible()) {
            w = this.editor.area.w / 2;
            x = this.editor.area.mx(w);
            GuiDraw.drawMultiText((FontRenderer)this.font, (String)EMPTY_RECIPE.get(), (int)x, (int)this.editor.area.my(), (int)0xFFFFFF, (int)w, (int)12, (float)0.5f, (float)0.5f);
        }
        super.draw(context);
    }
}

