/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.scripts;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.function.Consumer;
import mchorse.mappet.client.gui.scripts.utils.documentation.DocClass;
import mchorse.mappet.client.gui.scripts.utils.documentation.DocDelegate;
import mchorse.mappet.client.gui.scripts.utils.documentation.DocEntry;
import mchorse.mappet.client.gui.scripts.utils.documentation.DocList;
import mchorse.mappet.client.gui.scripts.utils.documentation.DocMethod;
import mchorse.mappet.client.gui.scripts.utils.documentation.Docs;
import mchorse.mappet.client.gui.utils.overlays.GuiOverlayPanel;
import mchorse.mclib.client.gui.framework.elements.GuiScrollElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiListElement;
import mchorse.mclib.client.gui.utils.keys.IKey;
import net.minecraft.client.Minecraft;
import net.minecraft.launchwrapper.Launch;

public class GuiDocumentationOverlayPanel
extends GuiOverlayPanel {
    private static Docs docs;
    private static DocEntry top;
    private static DocEntry entry;
    public GuiDocEntryList list;
    public GuiScrollElement documentation;

    public static List<DocClass> search(String text) {
        ArrayList<DocClass> list = new ArrayList<DocClass>();
        for (DocClass docClass : GuiDocumentationOverlayPanel.getDocs().classes) {
            if (docClass.getMethod(text) == null) continue;
            list.add(docClass);
        }
        return list;
    }

    public static Docs getDocs() {
        GuiDocumentationOverlayPanel.parseDocs();
        return docs;
    }

    private static void parseDocs() {
        boolean dev = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
        if (dev || docs == null) {
            InputStream stream = GuiDocumentationOverlayPanel.class.getResourceAsStream("/assets/mappet/docs.json");
            Gson gson = new GsonBuilder().create();
            Scanner scanner = new Scanner(stream, "UTF-8");
            docs = (Docs)gson.fromJson(scanner.useDelimiter("\\A").next(), Docs.class);
            entry = null;
            docs.copyMethods("UILabelBaseComponent", "UIButtonComponent", "UILabelComponent", "UITextComponent", "UITextareaComponent", "UITextboxComponent", "UIToggleComponent");
            docs.remove("UIParentComponent");
            docs.remove("UILabelBaseComponent");
            DocList topPackage = new DocList();
            DocList scripting = new DocList();
            DocList ui = new DocList();
            topPackage.doc = GuiDocumentationOverlayPanel.docs.getPackage((String)"mchorse.mappet.api.scripts.user.mappet").doc;
            scripting.name = "Scripting API";
            scripting.doc = GuiDocumentationOverlayPanel.docs.getPackage((String)"mchorse.mappet.api.scripts.user").doc;
            scripting.parent = topPackage;
            ui.name = "UI API";
            ui.doc = GuiDocumentationOverlayPanel.docs.getPackage((String)"mchorse.mappet.api.ui.components").doc;
            ui.parent = topPackage;
            for (DocClass docClass : GuiDocumentationOverlayPanel.docs.classes) {
                docClass.setup();
                if (docClass.name.contains("ui.components") || docClass.name.endsWith(".Graphic")) {
                    ui.entries.add(docClass);
                    docClass.parent = ui;
                    continue;
                }
                if (docClass.name.endsWith("Graphic")) continue;
                scripting.entries.add(docClass);
                docClass.parent = scripting;
            }
            topPackage.entries.add(scripting);
            topPackage.entries.add(ui);
            top = topPackage;
        }
    }

    public GuiDocumentationOverlayPanel(Minecraft mc) {
        this(mc, (DocEntry)null);
    }

    public GuiDocumentationOverlayPanel(Minecraft mc, DocEntry entry) {
        super(mc, IKey.lang((String)"mappet.gui.scripts.documentation.title"));
        this.list = new GuiDocEntryList(mc, l -> this.pick((DocEntry)l.get(0)));
        this.documentation = new GuiScrollElement(mc);
        this.list.flex().relative(this.content).w(120).h(1.0f);
        this.documentation.flex().relative(this.content).x(120).w(1.0f, -120).h(1.0f).column(4).vertical().stretch().scroll().padding(10);
        this.content.add(new IGuiElement[]{this.list, this.documentation});
        this.setupDocs(entry);
    }

    private void pick(DocEntry entryIn) {
        boolean wasSame;
        boolean isMethod = entryIn instanceof DocMethod;
        entryIn = entryIn.getEntry();
        List<DocEntry> entries = entryIn.getEntries();
        boolean bl = wasSame = this.list.getList().size() >= 2 && ((DocEntry)this.list.getList().get((int)1)).parent == entryIn.parent;
        if (entry == entryIn || !wasSame) {
            this.list.clear();
            if (entryIn.parent != null) {
                this.list.add(new DocDelegate(entryIn.parent));
            }
            this.list.add(entries);
            this.list.sort();
            if (isMethod) {
                this.list.setCurrentScroll(entryIn);
            }
        }
        this.fill(entryIn);
    }

    private void fill(DocEntry entryIn) {
        if (!(entryIn instanceof DocMethod)) {
            entry = entryIn;
        }
        this.documentation.scroll.scrollTo(0);
        this.documentation.removeAll();
        entryIn.fillIn(this.mc, this.documentation);
        this.resize();
    }

    private void setupDocs(DocEntry in) {
        GuiDocumentationOverlayPanel.parseDocs();
        if (in != null) {
            entry = in;
        } else if (entry == null) {
            entry = top;
        }
        this.pick(entry);
    }

    public static class GuiDocEntryList
    extends GuiListElement<DocEntry> {
        public GuiDocEntryList(Minecraft mc, Consumer<List<DocEntry>> callback) {
            super(mc, callback);
            this.scroll.scrollItemSize = 16;
            this.scroll.scrollSpeed *= 2;
        }

        protected boolean sortElements() {
            this.list.sort((a, b) -> a.getName().compareToIgnoreCase(b.getName()));
            return true;
        }

        protected String elementToString(DocEntry element) {
            return element.getName();
        }
    }
}

