/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.scripts.utils;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mchorse.mappet.client.gui.scripts.utils.HighlightedTextLine;
import mchorse.mappet.client.gui.scripts.utils.SyntaxStyle;
import mchorse.mappet.client.gui.scripts.utils.TextSegment;
import net.minecraft.client.gui.FontRenderer;

public class SyntaxHighlighter {
    private static final Set<String> OPERATORS = ImmutableSet.of((Object)"+", (Object)"-", (Object)"=", (Object)"/", (Object)"*", (Object)"<", (Object[])new String[]{">", "~", "&", "|", "!"});
    private static final Set<String> PRIMARY_KEYWORDS = ImmutableSet.of((Object)"break", (Object)"continue", (Object)"switch", (Object)"case", (Object)"default", (Object)"try", (Object[])new String[]{"catch", "delete", "do", "while", "else", "finally", "if", "else", "for", "each", "in", "instanceof", "new", "throw", "typeof", "with", "yield", "return"});
    private static final Set<String> SECONDARY_KEYWORDS = ImmutableSet.of((Object)"const", (Object)"function", (Object)"var", (Object)"let", (Object)"prototype", (Object)"Math", (Object[])new String[]{"JSON", "mappet"});
    private static final Set<String> SPECIAL = ImmutableSet.of((Object)"this", (Object)"arguments");
    private static final Set<String> TYPE_KEYSWORDS = ImmutableSet.of((Object)"true", (Object)"false", (Object)"null", (Object)"undefined");
    private static final Pattern FUNCTION_NAME = Pattern.compile("[\\w_][\\d\\w_]*", 2);
    private SyntaxStyle style;
    private String buffer;
    private char string;
    private int last;

    public SyntaxHighlighter() {
        this.style = new SyntaxStyle();
    }

    public SyntaxHighlighter(SyntaxStyle style) {
        this.style = style;
    }

    public SyntaxStyle getStyle() {
        return this.style;
    }

    public void setStyle(SyntaxStyle style) {
        this.style = style == null ? this.style : style;
    }

    public List<TextSegment> parse(FontRenderer font, List<HighlightedTextLine> textLines, String line, int lineIndex) {
        List<TextSegment> prevLine;
        ArrayList<TextSegment> list = new ArrayList<TextSegment>();
        List<TextSegment> list2 = prevLine = lineIndex > 0 ? textLines.get((int)(lineIndex - 1)).segments : null;
        if (prevLine != null && !prevLine.isEmpty()) {
            TextSegment last = prevLine.get(prevLine.size() - 1);
            if (last.color == this.style.comments && !last.text.startsWith("//") && !last.text.trim().endsWith("*/")) {
                list.add(new TextSegment(line, this.style.comments, 0));
                return list;
            }
        }
        this.buffer = "";
        this.string = '\u0000';
        this.last = 0;
        int c = line.length();
        block0: for (int i = 0; i < c; ++i) {
            boolean isString;
            char next;
            char character = line.charAt(i);
            char c2 = next = i < c - 1 ? line.charAt(i + 1) : (char)'\u0000';
            if (character == '\'' || character == '\"') {
                if (this.string == '\u0000') {
                    list.add(new TextSegment(this.buffer, this.style.other, font.func_78256_a(this.buffer)));
                    this.buffer = "";
                    this.string = character;
                } else if (this.string == character) {
                    char prev;
                    char c3 = prev = i > 0 ? line.charAt(i - 1) : (char)'\u0000';
                    if (prev != '\\') {
                        this.string = '\u0000';
                        this.buffer = this.buffer + character;
                        list.add(new TextSegment(this.buffer, this.style.strings, font.func_78256_a(this.buffer)));
                        this.buffer = "";
                        continue;
                    }
                }
            }
            boolean bl = isString = this.string != '\u0000';
            if (!isString && character == '/' && i < c - 1 && line.charAt(i + 1) == '*') {
                int lastI = i;
                i += 2;
                while (i < c) {
                    character = line.charAt(i);
                    if (character == '*' && i < c - 1 && line.charAt(i + 1) == '/') {
                        String comment = line.substring(lastI, i + 2);
                        list.add(new TextSegment(this.buffer, this.style.other, font.func_78256_a(this.buffer)));
                        list.add(new TextSegment(comment, this.style.comments, font.func_78256_a(comment)));
                        ++i;
                        this.buffer = "";
                        continue block0;
                    }
                    ++i;
                }
                String comment = line.substring(lastI);
                list.add(new TextSegment(this.buffer, this.style.other, font.func_78256_a(this.buffer)));
                list.add(new TextSegment(comment, this.style.comments, 0));
                return list;
            }
            if (!isString && character == '/' && i < c - 1 && line.charAt(i + 1) == '/') {
                String comment = line.substring(i);
                list.add(new TextSegment(this.buffer, this.style.other, font.func_78256_a(this.buffer)));
                list.add(new TextSegment(comment, this.style.comments, 0));
                return list;
            }
            if (!isString && OPERATORS.contains(String.valueOf(character))) {
                boolean isNumericalMinus;
                boolean bl2 = isNumericalMinus = character == '-' && Character.isDigit(next);
                if (!isNumericalMinus) {
                    String sign = String.valueOf(character);
                    list.add(new TextSegment(this.buffer, this.style.other, font.func_78256_a(this.buffer)));
                    list.add(new TextSegment(sign, this.style.primary, font.func_78256_a(sign)));
                    this.buffer = "";
                    this.last = i;
                    continue;
                }
            }
            this.buffer = this.buffer + character;
            if (!isString && (next != '\u0000' && !this.isLegalName(next) || i == c - 1)) {
                String keyword;
                if (this.last < i) {
                    boolean predicateForNumbers;
                    char last = line.charAt(this.last);
                    boolean bl3 = predicateForNumbers = (last == '-' || last == '.') && Character.isDigit(line.charAt(this.last + 1));
                    if (!this.isLegalName(last) && !predicateForNumbers) {
                        ++this.last;
                    }
                }
                if (PRIMARY_KEYWORDS.contains(keyword = line.substring(this.last, i + 1))) {
                    this.pushKeyword(list, keyword, this.style.primary, i, font);
                } else if (SPECIAL.contains(keyword)) {
                    this.pushKeyword(list, keyword, this.style.special, i, font);
                } else if (SECONDARY_KEYWORDS.contains(keyword) || this.isFunctionCall(list, keyword, next)) {
                    this.pushKeyword(list, keyword, this.style.secondary, i, font);
                } else if (this.isNumberOrConstant(keyword)) {
                    this.pushKeyword(list, keyword, this.style.numbers, i, font);
                } else if (this.isIdentifier(list)) {
                    this.pushKeyword(list, keyword, this.style.identifier, i, font);
                }
            }
            if (this.isLegalName(character)) continue;
            this.last = i;
        }
        if (!this.buffer.trim().isEmpty()) {
            list.add(new TextSegment(this.buffer, this.style.other, 0));
        }
        return list;
    }

    private boolean isLegalName(char character) {
        return Character.isLetterOrDigit(character) || character == '_';
    }

    private void pushKeyword(List<TextSegment> list, String keyword, int color, int i, FontRenderer font) {
        if (this.buffer.length() > keyword.length()) {
            String other = this.buffer.substring(0, this.buffer.length() - keyword.length());
            list.add(new TextSegment(other, this.style.other, font.func_78256_a(other)));
        }
        list.add(new TextSegment(keyword, color, font.func_78256_a(keyword)));
        this.buffer = "";
        this.last = i + 1;
    }

    private boolean isFunctionCall(List<TextSegment> list, String keyword, char next) {
        if (!list.isEmpty()) {
            TextSegment previous = list.get(list.size() - 1);
            boolean bufferIsKeyword = this.buffer.trim().equals(keyword);
            if (previous.color == this.style.strings) {
                return false;
            }
            if (bufferIsKeyword && previous.text.equals("function")) {
                return false;
            }
            if (bufferIsKeyword && previous.color != this.style.other) {
                return false;
            }
            if (previous.text.trim().equals(keyword.trim())) {
                return false;
            }
        }
        Matcher matcher = FUNCTION_NAME.matcher(keyword);
        boolean matches = matcher.matches();
        return next == '(' && matches;
    }

    private boolean isNumberOrConstant(String keyword) {
        if (TYPE_KEYSWORDS.contains(keyword)) {
            return true;
        }
        try {
            Double.parseDouble(keyword);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            int length = keyword.trim().length();
            if (keyword.startsWith("0x") && length >= 3 && length <= 10) {
                try {
                    Long.parseLong(keyword.substring(2), 16);
                    return true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    private boolean isIdentifier(List<TextSegment> list) {
        if (!list.isEmpty()) {
            TextSegment previous = list.get(list.size() - 1);
            if (previous.text.trim().equals("function") && previous.color == this.getStyle().secondary) {
                return true;
            }
        }
        return false;
    }
}

