/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.states;

import java.util.Comparator;
import mchorse.mappet.api.states.States;
import mchorse.mappet.client.gui.states.GuiState;
import mchorse.mclib.client.gui.framework.elements.GuiScrollElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;

public class GuiStatesEditor
extends GuiScrollElement {
    private States states;

    public GuiStatesEditor(Minecraft mc) {
        super(mc);
        this.flex().column(5).vertical().stretch().scroll().padding(10);
    }

    public States get() {
        return this.states;
    }

    public GuiStatesEditor set(States states) {
        this.states = states;
        this.removeAll();
        if (states != null) {
            for (String key : states.values.keySet()) {
                this.add((IGuiElement)new GuiState(this.mc, key, states));
            }
        }
        this.sortElements();
        this.resize();
        return this;
    }

    private void sortElements() {
        this.getChildren().sort(Comparator.comparing(a -> ((GuiState)((Object)a)).getKey()));
    }

    public void addNew() {
        if (this.states == null) {
            return;
        }
        int index = this.states.values.size() + 1;
        String key = "state_" + index;
        while (this.states.values.containsKey(key)) {
            key = "state_" + ++index;
        }
        this.states.values.put(key, 0);
        this.add((IGuiElement)new GuiState(this.mc, key, this.states));
        this.sortElements();
        this.getParentContainer().resize();
    }

    public void draw(GuiContext context) {
        super.draw(context);
        if (this.states != null && this.states.values.isEmpty()) {
            int w = this.area.w / 2;
            int x = this.area.mx(w);
            GuiDraw.drawMultiText((FontRenderer)this.font, (String)I18n.func_135052_a((String)"mappet.gui.states.empty", (Object[])new Object[0]), (int)x, (int)this.area.my(), (int)0xFFFFFF, (int)w, (int)12, (float)0.5f, (float)0.5f);
        }
    }
}

