/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.client.gui.triggers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import mchorse.mappet.CommonProxy;
import mchorse.mappet.api.triggers.Trigger;
import mchorse.mappet.api.triggers.blocks.AbstractTriggerBlock;
import mchorse.mappet.api.triggers.blocks.CommandTriggerBlock;
import mchorse.mappet.api.triggers.blocks.DialogueTriggerBlock;
import mchorse.mappet.api.triggers.blocks.EventTriggerBlock;
import mchorse.mappet.api.triggers.blocks.ItemTriggerBlock;
import mchorse.mappet.api.triggers.blocks.MorphTriggerBlock;
import mchorse.mappet.api.triggers.blocks.ScriptTriggerBlock;
import mchorse.mappet.api.triggers.blocks.SoundTriggerBlock;
import mchorse.mappet.api.triggers.blocks.StateTriggerBlock;
import mchorse.mappet.client.gui.triggers.panels.GuiAbstractTriggerBlockPanel;
import mchorse.mappet.client.gui.triggers.panels.GuiCommandTriggerBlockPanel;
import mchorse.mappet.client.gui.triggers.panels.GuiDialogueTriggerBlockPanel;
import mchorse.mappet.client.gui.triggers.panels.GuiEventTriggerBlockPanel;
import mchorse.mappet.client.gui.triggers.panels.GuiItemTriggerBlockPanel;
import mchorse.mappet.client.gui.triggers.panels.GuiMorphTriggerBlockPanel;
import mchorse.mappet.client.gui.triggers.panels.GuiScriptTriggerBlockPanel;
import mchorse.mappet.client.gui.triggers.panels.GuiSoundTriggerBlockPanel;
import mchorse.mappet.client.gui.triggers.panels.GuiStateTriggerBlockPanel;
import mchorse.mappet.client.gui.utils.GuiMappetUtils;
import mchorse.mappet.client.gui.utils.overlays.GuiEditorOverlayPanel;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.context.GuiContextMenu;
import mchorse.mclib.client.gui.framework.elements.context.GuiSimpleContextMenu;
import mchorse.mclib.client.gui.framework.elements.list.GuiListElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;

public class GuiTriggerOverlayPanel
extends GuiEditorOverlayPanel<AbstractTriggerBlock> {
    public static final Map<Class<? extends AbstractTriggerBlock>, Class<? extends GuiAbstractTriggerBlockPanel<? extends AbstractTriggerBlock>>> PANELS = new HashMap<Class<? extends AbstractTriggerBlock>, Class<? extends GuiAbstractTriggerBlockPanel<? extends AbstractTriggerBlock>>>();
    private Trigger trigger;
    private Runnable onClose;

    public GuiTriggerOverlayPanel(Minecraft mc, Trigger trigger) {
        this(mc, trigger, null);
    }

    public GuiTriggerOverlayPanel(Minecraft mc, Trigger trigger, Runnable onClose) {
        super(mc, IKey.lang((String)"mappet.gui.triggers.title"));
        this.trigger = trigger;
        this.onClose = onClose;
        this.list.sorting().setList(trigger.blocks);
        this.list.context(() -> {
            GuiSimpleContextMenu menu = new GuiSimpleContextMenu(this.mc).shadow();
            menu.action(Icons.ADD, IKey.lang((String)"mappet.gui.triggers.context.add"), () -> {
                GuiSimpleContextMenu adds = new GuiSimpleContextMenu(this.mc).shadow();
                for (String key : CommonProxy.getTriggerBlocks().getKeys()) {
                    IKey label = IKey.format((String)"mappet.gui.triggers.context.add_trigger", (Object[])new Object[]{IKey.lang((String)("mappet.gui.trigger_types." + key))});
                    int color = CommonProxy.getTriggerBlocks().getColor(key);
                    adds.action(Icons.ADD, label, () -> this.addBlock(key), color);
                }
                GuiBase.getCurrent().replaceContextMenu((GuiContextMenu)adds);
            });
            if (!this.list.isDeselected()) {
                menu.action(Icons.COPY, IKey.lang((String)"mappet.gui.triggers.context.copy"), this::copyTrigger);
            }
            try {
                NBTTagCompound tag = JsonToNBT.func_180713_a((String)GuiScreen.func_146277_j());
                if (tag.func_74764_b("_TriggerType")) {
                    menu.action(Icons.PASTE, IKey.lang((String)"mappet.gui.triggers.context.paste"), () -> this.pasteTrigger(tag));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.list.isDeselected()) {
                menu.action(Icons.REMOVE, IKey.lang((String)"mappet.gui.triggers.context.remove"), this::removeItem, 0xFF0033);
            }
            return menu;
        });
        this.pickItem(this.trigger.blocks.isEmpty() ? null : this.trigger.blocks.get(0), true);
    }

    @Override
    protected GuiListElement<AbstractTriggerBlock> createList(Minecraft mc) {
        return new GuiAbstractBlockListElement(mc, l -> this.pickItem(l.get(0), false));
    }

    private void addBlock(String type) {
        AbstractTriggerBlock block = CommonProxy.getTriggerBlocks().create(type);
        this.trigger.blocks.add(block);
        this.pickItem(block, true);
        this.list.update();
    }

    private void copyTrigger() {
        AbstractTriggerBlock block = (AbstractTriggerBlock)this.list.getCurrentFirst();
        NBTTagCompound tag = block.serializeNBT();
        tag.func_74778_a("_TriggerType", CommonProxy.getTriggerBlocks().getType(block));
        GuiScreen.func_146275_d((String)tag.toString());
    }

    private void pasteTrigger(NBTTagCompound tag) {
        AbstractTriggerBlock block = CommonProxy.getTriggerBlocks().create(tag.func_74779_i("_TriggerType"));
        block.deserializeNBT(tag);
        this.trigger.blocks.add(block);
        this.list.update();
        this.pickItem(block, true);
    }

    @Override
    protected void fillData(AbstractTriggerBlock block) {
        this.editor.removeAll();
        try {
            this.editor.add((IGuiElement)((GuiAbstractTriggerBlockPanel)((Object)PANELS.get(block.getClass()).getConstructors()[0].newInstance(new Object[]{this.mc, this, block}))));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onClose() {
        super.onClose();
        if (this.onClose != null) {
            this.onClose.run();
        }
    }

    @Override
    public void draw(GuiContext context) {
        super.draw(context);
        if (this.trigger.blocks.isEmpty()) {
            GuiMappetUtils.drawRightClickHere(context, this.list.area);
        }
    }

    static {
        PANELS.put(CommandTriggerBlock.class, GuiCommandTriggerBlockPanel.class);
        PANELS.put(SoundTriggerBlock.class, GuiSoundTriggerBlockPanel.class);
        PANELS.put(EventTriggerBlock.class, GuiEventTriggerBlockPanel.class);
        PANELS.put(DialogueTriggerBlock.class, GuiDialogueTriggerBlockPanel.class);
        PANELS.put(ScriptTriggerBlock.class, GuiScriptTriggerBlockPanel.class);
        PANELS.put(ItemTriggerBlock.class, GuiItemTriggerBlockPanel.class);
        PANELS.put(StateTriggerBlock.class, GuiStateTriggerBlockPanel.class);
        PANELS.put(MorphTriggerBlock.class, GuiMorphTriggerBlockPanel.class);
    }

    public static class GuiAbstractBlockListElement
    extends GuiListElement<AbstractTriggerBlock> {
        public GuiAbstractBlockListElement(Minecraft mc, Consumer<List<AbstractTriggerBlock>> callback) {
            super(mc, callback);
        }

        protected void drawElementPart(AbstractTriggerBlock element, int i, int x, int y, boolean hover, boolean selected) {
            int color = CommonProxy.getTriggerBlocks().getColor(element);
            Gui.func_73734_a((int)x, (int)y, (int)(x + 4), (int)(y + this.scroll.scrollItemSize), (int)(-16777216 + color));
            GuiDraw.drawHorizontalGradientRect((int)(x + 4), (int)y, (int)(x + 24), (int)(y + this.scroll.scrollItemSize), (int)(0x44000000 + color), (int)color);
            super.drawElementPart((Object)element, i, x + 4, y, hover, selected);
        }

        protected String elementToString(AbstractTriggerBlock element) {
            return element.stringify();
        }
    }
}

