/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.commands.data;

import java.io.File;
import java.nio.charset.Charset;
import mchorse.mappet.commands.MappetCommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.DimensionManager;
import org.apache.commons.io.FileUtils;

public class CommandDataRencode
extends MappetCommandBase {
    public String func_71517_b() {
        return "rencode";
    }

    public String func_71518_a(ICommandSender sender) {
        return "mappet.commands.mp.data.rencode";
    }

    public String getSyntax() {
        return "{l}{6}/{r}mp {8}data rencode{r} {7}<from> <to>{r}";
    }

    public int getRequiredArgs() {
        return 2;
    }

    public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        File file = new File(DimensionManager.getCurrentSaveRootDirectory(), "mappet");
        Charset from = this.getCharset(args[0]);
        Charset to = this.getCharset(args[1]);
        if (from == null) {
            this.getL10n().error(sender, "data.empty_charset", new Object[]{args[0]});
            return;
        }
        if (to == null) {
            this.getL10n().error(sender, "data.empty_charset", new Object[]{args[1]});
            return;
        }
        if (file.isDirectory()) {
            this.recode(file, from, to);
            this.getL10n().info(sender, "data.rencoded", new Object[]{from.name(), to.name()});
        }
    }

    private void recode(File target, Charset from, Charset to) {
        File[] files = target.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isFile()) {
                this.recodeFile(file, from, to);
                continue;
            }
            if (!file.isDirectory()) continue;
            this.recode(file, from, to);
        }
    }

    private void recodeFile(File file, Charset from, Charset to) {
        try {
            FileUtils.writeStringToFile((File)file, (String)FileUtils.readFileToString((File)file, (Charset)from), (Charset)to);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Charset getCharset(String arg) {
        try {
            return Charset.forName(arg);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

