/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.entities;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import mchorse.mappet.Mappet;
import mchorse.mappet.api.factions.Faction;
import mchorse.mappet.api.factions.FactionAttitude;
import mchorse.mappet.api.npcs.Npc;
import mchorse.mappet.api.npcs.NpcDrop;
import mchorse.mappet.api.npcs.NpcState;
import mchorse.mappet.api.states.States;
import mchorse.mappet.api.utils.DataContext;
import mchorse.mappet.capabilities.character.Character;
import mchorse.mappet.capabilities.character.ICharacter;
import mchorse.mappet.entities.ai.EntityAIAttackNpcMelee;
import mchorse.mappet.entities.ai.EntityAIFollowTarget;
import mchorse.mappet.entities.ai.EntityAIHurtByTargetNpc;
import mchorse.mappet.entities.ai.EntityAIPatrol;
import mchorse.mappet.entities.ai.EntityAIReturnToPost;
import mchorse.mappet.entities.utils.NpcDamageSource;
import mchorse.mappet.network.Dispatcher;
import mchorse.mappet.network.common.npc.PacketNpcMorph;
import mchorse.mclib.utils.Interpolations;
import mchorse.mclib.utils.MathUtils;
import mchorse.metamorph.api.Morph;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.models.IMorphProvider;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityNpc
extends EntityCreature
implements IEntityAdditionalSpawnData,
IMorphProvider {
    public static final int RENDER_DISTANCE = 160;
    private Morph morph = new Morph();
    private NpcState state = new NpcState();
    private int lastDamageTime;
    private boolean unkillableFailsafe = true;
    private Faction faction;
    private EntityAIHurtByTargetNpc targetAI;
    public float smoothYawHead;
    public float prevSmoothYawHead;
    public float smoothBodyYawHead;
    public float prevSmoothBodyYawHead;

    public EntityNpc(World worldIn) {
        super(worldIn);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3125);
    }

    public void func_70108_f(Entity entityIn) {
        if (!this.state.immovable) {
            super.func_70108_f(entityIn);
        }
    }

    protected void func_82167_n(Entity entityIn) {
        if (!this.state.immovable) {
            super.func_82167_n(entityIn);
        }
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.field_75782_a.clear();
        this.field_70715_bh.field_75782_a.clear();
        double speed = 1.0;
        if (this.state != null) {
            speed = this.state.speed;
            if (this.state.canSwim) {
                this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
            }
            if (!this.state.follow.isEmpty()) {
                this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIFollowTarget(this, speed, 2.0f, 10.0f));
            } else if (this.state.hasPost && this.state.postPosition != null) {
                this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIReturnToPost(this, this.state.postPosition, speed, this.state.postRadius));
            } else if (!this.state.patrol.isEmpty()) {
                this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIPatrol(this, speed));
            }
            if (this.state.lookAround) {
                this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
            }
            if (this.state.lookAtPlayer) {
                this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
            }
            if (this.state.wander) {
                this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, speed / 2.0));
            }
        }
        this.targetAI = new EntityAIHurtByTargetNpc(this, false, new Class[0]);
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)this.targetAI);
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 10, true, false, this::targetCheck));
        if (this.state != null) {
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackNpcMelee(this, speed, false, this.state.damageDelay));
        }
    }

    private boolean targetCheck(EntityLivingBase entity) {
        if (this.isEntityOutOfPostDistance((Entity)entity)) {
            return false;
        }
        Faction faction = this.getFaction();
        if (entity instanceof EntityNpc) {
            EntityNpc npc = (EntityNpc)entity;
            if (faction != null) {
                return faction.get(npc.getState().faction) == FactionAttitude.AGGRESSIVE;
            }
        }
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            if (player.func_175149_v() || player.func_184812_l_()) {
                return false;
            }
            FactionAttitude attitude = this.getPlayerAttitude(faction, (Entity)entity);
            if (attitude != null) {
                return attitude == FactionAttitude.AGGRESSIVE;
            }
        }
        return faction != null && faction.othersAttitude == FactionAttitude.AGGRESSIVE;
    }

    private FactionAttitude getPlayerAttitude(Faction faction, Entity entity) {
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            ICharacter character = Character.get((EntityPlayer)player);
            if (faction != null && character != null) {
                return faction.get(character.getStates());
            }
        }
        return null;
    }

    public void initialize() {
        this.state.triggerInitialize.trigger((EntityLivingBase)this);
    }

    public States getStates() {
        return this.state.states;
    }

    public Faction getFaction() {
        if (this.faction == null) {
            String faction = this.state.faction;
            this.faction = faction.isEmpty() ? null : (Faction)Mappet.factions.load(faction);
        }
        return this.faction;
    }

    public void setNpc(Npc npc, NpcState state) {
        this.setState(state, false);
        if (this.state.id.isEmpty()) {
            this.state.id = npc.getId();
        }
    }

    public String getId() {
        return this.state.id;
    }

    public NpcState getState() {
        return this.state;
    }

    public void setState(NpcState state, boolean notify) {
        this.state = new NpcState();
        this.state.deserializeNBT(state.serializeNBT());
        this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111265_b).func_111128_a((double)this.state.pathDistance);
        this.field_70699_by = this.func_175447_b(this.field_70170_p);
        double max = this.func_110138_aP();
        double health = this.func_110143_aJ();
        this.setMaxHealth(state.maxHealth);
        this.func_70606_j((float)MathHelper.func_151237_a((double)((double)state.maxHealth * (health / max)), (double)1.0, (double)state.maxHealth));
        this.field_70178_ae = !this.state.canGetBurned;
        this.field_70728_aV = this.state.xp;
        this.morph.set(state.morph);
        if (notify) {
            this.sendMorph();
        }
        this.faction = null;
        this.func_184651_r();
    }

    public void sendMorph() {
        Dispatcher.sendToTracked((Entity)this, new PacketNpcMorph(this));
    }

    public AbstractMorph getMorph() {
        return this.morph.get();
    }

    public EntityLivingBase getFollowTarget() {
        if (this.state.follow.isEmpty()) {
            return null;
        }
        if (this.state.follow.equals("@r")) {
            List players = this.field_70170_p.field_73010_i;
            int index = (int)MathUtils.clamp((double)(Math.random() * (double)players.size() - 1.0), (double)0.0, (double)(players.size() - 1));
            return players.isEmpty() ? null : (EntityLivingBase)players.get(index);
        }
        try {
            EntityPlayer player = this.field_70170_p.func_72924_a(this.state.follow);
            return player == null ? this.field_70170_p.func_152378_a(UUID.fromString(this.state.follow)) : player;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setMorph(AbstractMorph morph) {
        this.morph.set(morph);
    }

    public void setMaxHealth(double value) {
        this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a).func_111128_a(value);
    }

    public void func_70071_h_() {
        this.healthFailsafe();
        this.updateAttackTarget();
        super.func_70071_h_();
        this.func_82168_bl();
        if (!this.morph.isEmpty()) {
            this.morph.get().update((EntityLivingBase)this);
        }
        if (this.state.regenDelay > 0 && !this.field_70170_p.field_72995_K) {
            if (this.lastDamageTime >= this.state.regenDelay && this.field_70173_aa % this.state.regenFrequency == 0 && this.func_110143_aJ() > 0.0f && this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_70691_i(1.0f);
            }
            ++this.lastDamageTime;
        }
        if (this.field_70170_p.field_72995_K) {
            this.prevSmoothYawHead = this.smoothYawHead;
            this.smoothYawHead = Interpolations.lerpYaw((float)this.smoothYawHead, (float)this.field_70759_as, (float)0.5f);
            this.prevSmoothBodyYawHead = this.smoothBodyYawHead;
            this.smoothBodyYawHead = Interpolations.lerpYaw((float)this.smoothBodyYawHead, (float)this.field_70761_aq, (float)0.5f);
        } else {
            this.state.triggerTick.trigger((EntityLivingBase)this);
        }
    }

    private boolean isEntityOutOfPostDistance(Entity entity) {
        if (this.state == null || this.state.postPosition == null || !this.state.hasPost) {
            return true;
        }
        BlockPos post = this.state.postPosition;
        BlockPos position = entity.func_180425_c();
        double distance = post.func_177951_i((Vec3i)position);
        return distance > (double)(this.state.fallback * this.state.fallback);
    }

    private void updateAttackTarget() {
        if (this.state != null && this.func_70638_az() != null && this.state.postPosition != null && this.state.hasPost && this.isEntityOutOfPostDistance((Entity)this.func_70638_az())) {
            this.targetAI.reset = true;
            this.func_70624_b(null);
        }
        if (this.faction == null || this.field_70173_aa % 10 != 0) {
            return;
        }
        EntityLivingBase entity = this.func_70638_az();
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            Faction faction = this.getFaction();
            FactionAttitude attitude = this.getPlayerAttitude(faction, (Entity)player);
            if (attitude == FactionAttitude.FRIENDLY || player.func_184812_l_()) {
                this.func_70624_b(null);
            }
        }
    }

    protected void func_70609_aI() {
        if (this.state.killable || !this.unkillableFailsafe) {
            super.func_70609_aI();
        }
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        for (NpcDrop drop : this.state.drops) {
            if (!(this.field_70146_Z.nextFloat() < drop.chance)) continue;
            this.func_70099_a(drop.stack.func_77946_l(), 0.0f);
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        NpcDamageSource source = Mappet.npcsPeacefulDamage.get() ? new NpcDamageSource((Entity)this) : DamageSource.func_76358_a((EntityLivingBase)this);
        entityIn.func_70097_a((DamageSource)source, this.state.damage);
        return super.func_70652_k(entityIn);
    }

    protected void func_70665_d(DamageSource damage, float damageAmount) {
        super.func_70665_d(damage, damageAmount);
        if (!this.func_180431_b(damage)) {
            this.lastDamageTime = 0;
        }
        this.healthFailsafe();
        this.state.triggerDamaged.trigger((EntityLivingBase)this);
    }

    public boolean func_180431_b(DamageSource source) {
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        Entity entity = source.func_76346_g();
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            Faction faction = this.getFaction();
            FactionAttitude attitude = this.getPlayerAttitude(faction, (Entity)player);
            if (attitude == FactionAttitude.FRIENDLY && !player.func_184812_l_()) {
                return true;
            }
        }
        if (this.state.invincible) {
            return !source.func_180136_u() && source != DamageSource.field_76380_i;
        }
        if (!this.state.canFallDamage && source == DamageSource.field_76379_h) {
            return true;
        }
        return super.func_180431_b(source);
    }

    public void func_174812_G() {
        this.unkillableFailsafe = false;
        super.func_174812_G();
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        this.state.triggerDied.trigger((EntityLivingBase)this, cause.func_76346_g());
    }

    protected boolean func_70692_ba() {
        return this.state.unique;
    }

    public void healthFailsafe() {
        if (!this.state.killable && this.func_110143_aJ() <= 0.0f && this.unkillableFailsafe) {
            this.func_70606_j(0.001f);
        }
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K && !player.func_184586_b(hand).func_111282_a(player, (EntityLivingBase)this, hand)) {
            this.state.triggerInteract.trigger(new DataContext((Entity)this, (Entity)player));
        }
        return true;
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74782_a("State", (NBTBase)this.state.serializeNBT());
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        NpcState state = new NpcState();
        state.deserializeNBT(tag.func_74775_l("State"));
        if (tag.func_74764_b("States")) {
            state.states.deserializeNBT(tag.func_74775_l("States"));
        }
        this.setState(state, false);
        if (tag.func_74764_b("NpcId")) {
            state.id = tag.func_74779_i("NpcId");
        }
    }

    public void writeSpawnData(ByteBuf buf) {
        MorphUtils.morphToBuf((ByteBuf)buf, (AbstractMorph)this.morph.get());
    }

    public void readSpawnData(ByteBuf buf) {
        this.morph.setDirect(MorphUtils.morphFromBuf((ByteBuf)buf));
        this.field_70758_at = this.field_70759_as;
        this.smoothYawHead = this.field_70759_as;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b();
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 *= 160.0) * d0;
    }
}

