/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.entities.ai;

import mchorse.mappet.entities.EntityNpc;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityAIFollowTarget
extends EntityAIBase {
    private static final double TELEPORT_DISTANCE = 144.0;
    private final EntityNpc target;
    private EntityLivingBase follow;
    private final double speed;
    private int timer;
    private float max;
    private float min;
    private float prevWaterFactor;

    public EntityAIFollowTarget(EntityNpc target, double speed, float min, float max) {
        this.target = target;
        this.speed = speed;
        this.min = min;
        this.max = max;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        EntityLivingBase target = this.target.getFollowTarget();
        if (target == null) {
            return false;
        }
        if (target instanceof EntityPlayer && ((EntityPlayer)target).func_175149_v()) {
            return false;
        }
        if (this.target.func_70068_e((Entity)target) < (double)(this.min * this.min)) {
            return false;
        }
        this.follow = target;
        return true;
    }

    public boolean func_75253_b() {
        return !this.target.func_70661_as().func_75500_f() && this.target.func_70068_e((Entity)this.follow) > (double)(this.min * this.min);
    }

    public void func_75249_e() {
        this.timer = 0;
        this.prevWaterFactor = this.target.func_184643_a(PathNodeType.WATER);
        this.target.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.follow = null;
        this.target.func_70661_as().func_75499_g();
        this.target.func_184644_a(PathNodeType.WATER, this.prevWaterFactor);
    }

    public void func_75246_d() {
        this.target.func_70671_ap().func_75651_a((Entity)this.follow, 10.0f, (float)this.target.func_70646_bf());
        if (this.timer > 0) {
            --this.timer;
            return;
        }
        this.timer = 10;
        if (!this.target.func_70661_as().func_75497_a((Entity)this.follow, this.speed) && !this.target.func_110167_bD() && !this.target.func_184218_aH() || this.target.func_70068_e((Entity)this.follow) >= 144.0) {
            int x = MathHelper.func_76128_c((double)this.follow.field_70165_t) - 2;
            int z = MathHelper.func_76128_c((double)this.follow.field_70161_v) - 2;
            int y = MathHelper.func_76128_c((double)this.follow.func_174813_aQ().field_72338_b);
            for (int bx = 0; bx <= 4; ++bx) {
                for (int bz = 0; bz <= 4; ++bz) {
                    if (bx >= 1 && bz >= 1 && bx <= 3 && bz <= 3 || !this.canTeleport(x, z, y, bx, bz)) continue;
                    this.target.func_70012_b((float)(x + bx) + 0.5f, y, (float)(z + bz) + 0.5f, this.target.field_70177_z, this.target.field_70125_A);
                    this.target.func_70661_as().func_75499_g();
                    return;
                }
            }
        }
    }

    private boolean canTeleport(int x, int z, int y, int offsetX, int offsetY) {
        World world = this.target.field_70170_p;
        BlockPos pos = new BlockPos(x + offsetX, y - 1, z + offsetY);
        IBlockState state = world.func_180495_p(pos);
        return state.func_193401_d((IBlockAccess)world, pos, EnumFacing.DOWN) == BlockFaceShape.SOLID && state.func_189884_a((Entity)this.target) && world.func_175623_d(pos.func_177984_a()) && world.func_175623_d(pos.func_177981_b(2));
    }
}

