/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.network.server.content;

import java.util.ArrayList;
import mchorse.mappet.api.utils.AbstractData;
import mchorse.mappet.api.utils.manager.IManager;
import mchorse.mappet.capabilities.character.Character;
import mchorse.mappet.network.Dispatcher;
import mchorse.mappet.network.common.content.PacketContentData;
import mchorse.mappet.network.common.content.PacketContentNames;
import mchorse.mappet.utils.CurrentSession;
import mchorse.mclib.network.ServerMessageHandler;
import mchorse.mclib.utils.OpHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class ServerHandlerContentData
extends ServerMessageHandler<PacketContentData> {
    public void run(EntityPlayerMP player, PacketContentData message) {
        boolean isEditing = !Character.get((EntityPlayer)player).getCurrentSession().isEditing(message.type, message.name);
        boolean exists = message.type.getManager().exists(message.name);
        if (!OpHelper.isPlayerOp((EntityPlayerMP)player) || isEditing && exists) {
            return;
        }
        IManager<? extends AbstractData> manager = message.type.getManager();
        if (message.rename != null) {
            manager.rename(message.name, message.rename);
            if (message.data != null) {
                manager.save(message.rename, message.data);
            }
        } else if (message.data == null) {
            manager.delete(message.name);
        } else {
            manager.save(message.name, message.data);
        }
        if (!exists && manager.exists(message.name)) {
            CurrentSession session = Character.get((EntityPlayer)player).getCurrentSession();
            session.set(message.type, message.name);
            session.setActive(message.type, message.name);
        }
        ArrayList<String> names = new ArrayList<String>(message.type.getManager().getKeys());
        for (EntityPlayerMP otherPlayer : player.func_184102_h().func_184103_al().func_181057_v()) {
            if (otherPlayer == player) continue;
            CurrentSession session = Character.get((EntityPlayer)otherPlayer).getCurrentSession();
            Dispatcher.sendTo(new PacketContentNames(message.type, names), otherPlayer);
            if (!session.isActive(message.type, message.name)) continue;
            Dispatcher.sendTo(message.disallow(), otherPlayer);
        }
    }
}

