/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.utils;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import mchorse.mappet.api.states.States;
import mchorse.mappet.capabilities.character.Character;
import mchorse.mappet.capabilities.character.ICharacter;
import mchorse.mappet.entities.EntityNpc;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.ForgeHooks;

public class EntityUtils {
    public static final Set<String> ENTITY_PROPERTIES = ImmutableSet.of((Object)"xp", (Object)"xp_level", (Object)"hp", (Object)"hunger", (Object)"armor", (Object)"ticks", (Object[])new String[]{"light", "light_sky", "sneaking", "sprinting", "on_ground", "yaw", "pitch"});

    public static States getStates(Entity entity) {
        if (entity instanceof EntityPlayer) {
            ICharacter character = Character.get((EntityPlayer)entity);
            if (character != null) {
                return character.getStates();
            }
        } else if (entity instanceof EntityNpc) {
            return ((EntityNpc)entity).getStates();
        }
        return null;
    }

    public static double getProperty(Entity entity, String property) {
        EntityPlayer player = entity instanceof EntityPlayer ? (EntityPlayer)entity : null;
        EntityLivingBase living = entity instanceof EntityLivingBase ? (EntityLivingBase)entity : null;
        switch (property) {
            case "xp": {
                return player == null ? 0.0 : (double)player.field_71067_cb;
            }
            case "xp_level": {
                return player == null ? 0.0 : (double)player.field_71068_ca;
            }
            case "hp": {
                return living == null ? 0.0 : (double)living.func_110143_aJ();
            }
            case "hunger": {
                return player == null ? 0.0 : (double)player.func_71024_bL().func_75116_a();
            }
            case "armor": {
                return player == null ? 0.0 : (double)ForgeHooks.getTotalArmorValue((EntityPlayer)player);
            }
            case "ticks": {
                return entity.field_70173_aa;
            }
            case "light": {
                return (float)EntityUtils.getCombinedLight(entity) % 65536.0f / 15.0f;
            }
            case "light_sky": {
                return (float)EntityUtils.getCombinedLight(entity) / 65536.0f / 15.0f;
            }
            case "sneaking": {
                return entity.func_70093_af() ? 1.0 : 0.0;
            }
            case "sprinting": {
                return entity.func_70051_ag() ? 1.0 : 0.0;
            }
            case "on_ground": {
                return entity.field_70122_E ? 1.0 : 0.0;
            }
            case "yaw": {
                return MathHelper.func_76142_g((float)entity.field_70177_z);
            }
            case "pitch": {
                return entity.field_70125_A;
            }
        }
        return 0.0;
    }

    public static int getCombinedLight(Entity entity) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(MathHelper.func_76128_c((double)entity.field_70165_t), 0, MathHelper.func_76128_c((double)entity.field_70161_v));
        if (entity.field_70170_p.func_175667_e((BlockPos)pos)) {
            pos.func_185336_p(MathHelper.func_76128_c((double)(entity.field_70163_u + (double)entity.func_70047_e())));
            return entity.field_70170_p.func_175626_b((BlockPos)pos, 0);
        }
        return 0;
    }
}

