/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.utils;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class InventoryUtils {
    public static boolean areStacksSimilar(ItemStack a, ItemStack b) {
        return InventoryUtils.areStacksSimilar(a, b, false);
    }

    public static boolean areStacksSimilar(ItemStack a, ItemStack b, boolean ignoreNBT) {
        if (a.func_190926_b() && b.func_190926_b()) {
            return true;
        }
        if (ignoreNBT) {
            return a.func_77973_b() == b.func_77973_b();
        }
        return ItemStack.func_185132_d((ItemStack)a, (ItemStack)b) && ItemStack.func_77970_a((ItemStack)a, (ItemStack)b);
    }

    public static int countItems(EntityPlayer player, ItemStack target) {
        return InventoryUtils.countItems(player, target, true, false);
    }

    public static int countItems(EntityPlayer player, ItemStack target, boolean stopUponTargetCount, boolean ignoreNBT) {
        int count = 0;
        int c = player.field_71071_by.func_70302_i_();
        for (int i = 0; i < c; ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (!InventoryUtils.areStacksSimilar(target, stack, ignoreNBT) || !stopUponTargetCount || (count += stack.func_190916_E()) < target.func_190916_E()) continue;
            return count;
        }
        return count;
    }

    public static int countItems(NonNullList<ItemStack> inventory, ItemStack target, boolean stopUponTargetCount) {
        int count = 0;
        int c = inventory.size();
        for (int i = 0; i < c; ++i) {
            ItemStack stack = (ItemStack)inventory.get(i);
            if (!InventoryUtils.areStacksSimilar(target, stack) || !stopUponTargetCount || (count += stack.func_190916_E()) < target.func_190916_E()) continue;
            return count;
        }
        return count;
    }
}

