/*
 * Decompiled with CFR 0.152.
 */
package mchorse.mappet.utils;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mchorse.mappet.api.states.States;
import mchorse.mappet.entities.EntityNpc;
import mchorse.mappet.utils.EntityUtils;
import mchorse.mclib.math.IValue;
import mchorse.mclib.math.MathBuilder;
import mchorse.mclib.math.Variable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.IEntitySelectorFactory;

public class MappetNpcSelector
implements IEntitySelectorFactory {
    public static final String ARGUMENT_MAPPET_NPC_ID = "mpid";
    public static final String ARGUMENT_MAPPET_STATES = "mpe";
    public static final SelectorMathBuilder BUILDER = new SelectorMathBuilder();

    @Nonnull
    public List<Predicate<Entity>> createPredicates(Map<String, String> arguments, String mainSelector, ICommandSender sender, Vec3d position) {
        ArrayList<Predicate<Entity>> list = new ArrayList<Predicate<Entity>>();
        if (arguments.containsKey(ARGUMENT_MAPPET_NPC_ID)) {
            this.addNpcIdPredicate(list, arguments.get(ARGUMENT_MAPPET_NPC_ID));
        }
        if (arguments.containsKey(ARGUMENT_MAPPET_STATES)) {
            this.addStatesPredicate(list, arguments.get(ARGUMENT_MAPPET_STATES));
        }
        return list;
    }

    private void addNpcIdPredicate(List<Predicate<Entity>> list, String id) {
        boolean negative = id.startsWith("!");
        if (negative) {
            id = id.substring(1);
        }
        String finalId = id;
        list.add((Predicate<Entity>)((Predicate)e -> {
            if (e instanceof EntityNpc) {
                String npcId = ((EntityNpc)((Object)e)).getId();
                return negative != npcId.equals(finalId);
            }
            return false;
        }));
    }

    private void addStatesPredicate(List<Predicate<Entity>> list, String expression) {
        BUILDER.reset();
        try {
            IValue value = BUILDER.parse(expression);
            list.add((Predicate<Entity>)((Predicate)e -> {
                States states = EntityUtils.getStates(e);
                if (states == null) {
                    return false;
                }
                for (Variable variable : MappetNpcSelector.BUILDER.variables.values()) {
                    Object v = states.values.get(variable.getName());
                    if (v != null) {
                        if (v instanceof String) {
                            variable.set((String)v);
                            continue;
                        }
                        if (!(v instanceof Number)) continue;
                        variable.set(((Number)v).doubleValue());
                        continue;
                    }
                    variable.set(0.0);
                }
                return value.booleanValue();
            }));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class SelectorMathBuilder
    extends MathBuilder {
        public void reset() {
            this.variables.clear();
        }

        protected Variable getVariable(String name) {
            Variable variable = super.getVariable(name);
            if (variable == null) {
                variable = new Variable(name, 0.0);
                this.variables.put(name, variable);
            }
            return variable;
        }
    }
}

