/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.aperture;

import java.util.List;
import java.util.function.Consumer;
import mchorse.aperture.camera.CameraAPI;
import mchorse.aperture.client.gui.GuiCameraEditor;
import mchorse.aperture.events.CameraEditorEvent;
import mchorse.aperture.network.common.PacketCameraProfileList;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.ClientProxy;
import mchorse.blockbuster.aperture.gui.GuiDirectorConfigOptions;
import mchorse.blockbuster.aperture.gui.GuiPlayback;
import mchorse.blockbuster.aperture.network.client.ClientHandlerCameraProfileList;
import mchorse.blockbuster.aperture.network.client.ClientHandlerSceneLength;
import mchorse.blockbuster.aperture.network.common.PacketAudioShift;
import mchorse.blockbuster.aperture.network.common.PacketRequestLength;
import mchorse.blockbuster.aperture.network.common.PacketRequestProfiles;
import mchorse.blockbuster.aperture.network.common.PacketSceneLength;
import mchorse.blockbuster.aperture.network.server.ServerHandlerAudioShift;
import mchorse.blockbuster.aperture.network.server.ServerHandlerRequestLength;
import mchorse.blockbuster.aperture.network.server.ServerHandlerRequestProfiles;
import mchorse.blockbuster.audio.AudioRenderer;
import mchorse.blockbuster.client.gui.dashboard.GuiBlockbusterPanels;
import mchorse.blockbuster.client.gui.dashboard.panels.recording_editor.GuiRecordingEditorPanel;
import mchorse.blockbuster.client.gui.dashboard.panels.recording_editor.actions.GuiActionPanel;
import mchorse.blockbuster.common.item.ItemPlayback;
import mchorse.blockbuster.network.Dispatcher;
import mchorse.blockbuster.network.common.scene.PacketSceneRequestCast;
import mchorse.blockbuster.network.common.scene.sync.PacketSceneGoto;
import mchorse.blockbuster.network.common.scene.sync.PacketScenePlay;
import mchorse.blockbuster.recording.scene.SceneLocation;
import mchorse.blockbuster.utils.mclib.BBIcons;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDrawable;
import mchorse.mclib.client.gui.mclib.GuiDashboard;
import mchorse.mclib.client.gui.utils.Area;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.ScrollArea;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.mclib.utils.Direction;
import mchorse.mclib.utils.resources.RLUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CameraHandler {
    public static int tick = 0;
    public static boolean reload = true;
    public static boolean actions = true;
    @SideOnly(value=Side.CLIENT)
    public static GuiElement cameraEditorElements;
    @SideOnly(value=Side.CLIENT)
    public static GuiElement editorElement;
    public static SceneLocation location;

    public static boolean isApertureLoaded() {
        return Loader.isModLoaded((String)"aperture");
    }

    public static void register() {
        if (CameraHandler.isApertureLoaded()) {
            CameraHandler.registerHandlers();
        }
    }

    @Optional.Method(modid="aperture")
    private static void registerHandlers() {
        mchorse.aperture.ClientProxy.EVENT_BUS.register((Object)new CameraHandler());
        MinecraftForge.EVENT_BUS.register((Object)new CameraGUIHandler());
    }

    public static void registerMessages() {
        if (CameraHandler.isApertureLoaded()) {
            CameraHandler.registerApertureMessages();
        }
    }

    @Optional.Method(modid="aperture")
    private static void registerApertureMessages() {
        Dispatcher.DISPATCHER.register(PacketRequestProfiles.class, ServerHandlerRequestProfiles.class, Side.SERVER);
        Dispatcher.DISPATCHER.register(PacketCameraProfileList.class, ClientHandlerCameraProfileList.class, Side.CLIENT);
        Dispatcher.DISPATCHER.register(PacketRequestLength.class, ServerHandlerRequestLength.class, Side.SERVER);
        Dispatcher.DISPATCHER.register(PacketSceneLength.class, ClientHandlerSceneLength.class, Side.CLIENT);
        Dispatcher.DISPATCHER.register(PacketAudioShift.class, ServerHandlerAudioShift.class, Side.SERVER);
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="aperture")
    public static void openCameraEditor() {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        GuiCameraEditor editor = mchorse.aperture.ClientProxy.getCameraEditor();
        editor.updateCameraEditor((EntityPlayer)player);
        player.func_70016_h(0.0, 0.0, 0.0);
        mc.func_147108_a((GuiScreen)editor);
    }

    @Optional.Method(modid="aperture")
    public static void handlePlaybackItem(EntityPlayer player, NBTTagCompound tag) {
        if (player instanceof EntityPlayerMP) {
            if (tag.func_74764_b("CameraPlay")) {
                CameraAPI.playCurrentProfile((EntityPlayerMP)((EntityPlayerMP)player));
            } else if (tag.func_74764_b("CameraProfile")) {
                CameraAPI.playCameraProfile((EntityPlayerMP)((EntityPlayerMP)player), (ResourceLocation)RLUtils.create((String)tag.func_74779_i("CameraProfile")));
            }
        }
    }

    public static int getModeFromNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("CameraPlay")) {
            return 1;
        }
        if (tag.func_74764_b("CameraProfile")) {
            return 2;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="aperture")
    public static void attach(SceneLocation location, List<String> scenes) {
        GuiPlayback playback = new GuiPlayback();
        playback.setLocation(location, scenes);
        Minecraft.func_71410_x().func_147108_a((GuiScreen)playback);
    }

    public static boolean isCameraEditorOpen() {
        if (CameraHandler.isApertureLoaded()) {
            return CameraHandler.isCurrentScreenCameraEditor();
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="aperture")
    private static boolean isCurrentScreenCameraEditor() {
        return Minecraft.func_71410_x().field_71462_r instanceof GuiCameraEditor;
    }

    @SideOnly(value=Side.CLIENT)
    public static float getRoll() {
        if (CameraHandler.isApertureLoaded()) {
            return CameraHandler.getApertureRoll();
        }
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public static float getRoll(float partialTicks) {
        if (CameraHandler.isApertureLoaded()) {
            return CameraHandler.getApertureRoll(partialTicks);
        }
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="aperture")
    private static float getApertureRoll() {
        return mchorse.aperture.ClientProxy.control.roll;
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="aperture")
    private static float getApertureRoll(float partialTicks) {
        return mchorse.aperture.ClientProxy.control.getRoll(partialTicks);
    }

    @SideOnly(value=Side.CLIENT)
    public static void setRoll(float prevRoll, float roll) {
        if (CameraHandler.isApertureLoaded()) {
            CameraHandler.setApertureRoll(prevRoll, roll);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="aperture")
    private static void setApertureRoll(float prevRoll, float roll) {
        mchorse.aperture.ClientProxy.control.setRoll(prevRoll, roll);
    }

    @SideOnly(value=Side.CLIENT)
    public static void resetRoll() {
        if (CameraHandler.isApertureLoaded()) {
            CameraHandler.resetApertureRoll();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="aperture")
    private static void resetApertureRoll() {
        mchorse.aperture.ClientProxy.control.resetRoll();
    }

    @SideOnly(value=Side.CLIENT)
    public static int getOffset() {
        if (CameraHandler.isApertureLoaded()) {
            return CameraHandler.getCameraOffset();
        }
        return -1;
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="aperture")
    private static int getCameraOffset() {
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof GuiCameraEditor) {
            return ((GuiCameraEditor)screen).timeline.value;
        }
        return -1;
    }

    public static void closeScreenOrCameraEditor() {
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (CameraHandler.isApertureLoaded() && CameraHandler.closeCameraEditor(screen)) {
            return;
        }
        Minecraft.func_71410_x().func_147108_a(null);
    }

    private static boolean closeCameraEditor(GuiScreen screen) {
        if (screen instanceof GuiCameraEditor) {
            ((GuiCameraEditor)screen).closeThisScreen();
        }
        return screen instanceof GuiCameraEditor;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="aperture")
    public void onCameraScrub(CameraEditorEvent.Scrubbed event) {
        GuiBlockbusterPanels dashboard;
        SceneLocation location = CameraHandler.get();
        if (location != null) {
            Dispatcher.sendToServer(new PacketSceneGoto(location, event.position, actions));
        }
        if ((dashboard = ClientProxy.panels) != null && dashboard.recordingEditorPanel.selector.isVisible()) {
            ScrollArea scroll = dashboard.recordingEditorPanel.selector.scroll;
            scroll.scrollIntoView(scroll.scrollItemSize * (event.position - dashboard.recordingEditorPanel.record.preDelay), 2);
            dashboard.recordingEditorPanel.selector.cursor = event.position;
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="aperture")
    public void onCameraPlause(CameraEditorEvent.Playback event) {
        SceneLocation location = CameraHandler.get();
        if (location != null) {
            Dispatcher.sendToServer(new PacketScenePlay(location, event.play ? (byte)1 : 2, event.position));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="aperture")
    public void onCameraRewind(CameraEditorEvent.Rewind event) {
        SceneLocation location = CameraHandler.get();
        if (location != null) {
            Dispatcher.sendToServer(new PacketScenePlay(location, 4, event.position));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="aperture")
    public void onCameraOptions(CameraEditorEvent.Options event) {
        event.options.add(new GuiDirectorConfigOptions(Minecraft.func_71410_x(), event.editor));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="aperture")
    public void onCameraEditorInit(CameraEditorEvent.Init event) {
        location = null;
        GuiDashboard.get();
        Minecraft mc = Minecraft.func_71410_x();
        final GuiCameraEditor editor = event.editor;
        final GuiBlockbusterPanels panels = ClientProxy.panels;
        final GuiRecordingEditorPanel record = panels.recordingEditorPanel;
        if (record == null) {
            return;
        }
        editorElement = new GuiElement(mc){

            public boolean mouseClicked(GuiContext context) {
                return super.mouseClicked(context) || record.editor.delegate != null && record.editor.area.isInside(context);
            }

            public boolean mouseScrolled(GuiContext context) {
                return super.mouseScrolled(context) || record.editor.delegate != null && record.editor.area.isInside(context);
            }

            public void draw(GuiContext context) {
                if (this.isVisible() && record.editor.delegate != null) {
                    Area area = ((GuiActionPanel)record.editor.delegate).area;
                    area.draw(0x66000000);
                }
                if (editor.getRunner().isRunning()) {
                    ScrollArea scroll = panels.recordingEditorPanel.selector.scroll;
                    scroll.scrollIntoView(scroll.scrollItemSize * (int)(editor.getRunner().ticks - (long)panels.recordingEditorPanel.record.preDelay), 2);
                    panels.recordingEditorPanel.selector.cursor = (int)editor.getRunner().ticks;
                }
                super.draw(context);
            }
        };
        editorElement.noCulling();
        Consumer<GuiIconElement> refresh = b -> {
            boolean show = editorElement.isVisible();
            editor.panel.flex().h(1.0f, show ? -150 : -70);
            editor.timeline.flex().y(1.0f, show ? -100 : -20);
            record.records.flex().h(1.0f, show ? -80 : 0);
            b.both(show ? Icons.DOWNLOAD : Icons.UPLOAD);
            editor.root.resize();
        };
        GuiIconElement open = new GuiIconElement(mc, BBIcons.EDITOR, b -> panels.recordingEditorPanel.records.toggleVisible());
        GuiIconElement toggle = new GuiIconElement(mc, Icons.UPLOAD, b -> {
            if (!record.selector.isVisible()) {
                return;
            }
            editorElement.setVisible(!editorElement.isVisible());
            refresh.accept((GuiIconElement)b);
        });
        GuiDrawable drawable = new GuiDrawable(context -> {
            int w = (int)((float)editor.root.area.w * Blockbuster.audioWaveformWidth.get());
            AudioRenderer.renderAll(editor.root.area.x + (editor.root.area.w - w) / 2, editor.timeline.area.y - 15, w, Blockbuster.audioWaveformHeight.get(), context.screen.field_146294_l, context.screen.field_146295_m);
            record.selector.cursor = editor.timeline.value;
        });
        IKey category = IKey.lang((String)"blockbuster.gui.aperture.keys.category");
        IKey toggleEditor = IKey.lang((String)"blockbuster.gui.aperture.keys.toggle_editor");
        IKey detachScene = IKey.lang((String)"blockbuster.gui.aperture.keys.detach_scene");
        IKey reloadScene = IKey.lang((String)"blockbuster.gui.aperture.keys.reload_scene");
        GuiDirectorConfigOptions directorOptions = (GuiDirectorConfigOptions)((Object)editor.config.getChildren(GuiDirectorConfigOptions.class).get(0));
        open.tooltip(IKey.lang((String)"blockbuster.gui.dashboard.player_recording"), Direction.TOP);
        open.keys().register(IKey.lang((String)"blockbuster.gui.aperture.keys.toggle_list"), 38, () -> open.clickItself(editor.context)).held(new int[]{29}).category(category);
        toggle.tooltip(toggleEditor, Direction.TOP);
        toggle.keys().register(toggleEditor, 18, () -> toggle.clickItself(editor.context)).held(new int[]{29}).category(category);
        toggle.keys().register(detachScene, 32, () -> directorOptions.detachScene.clickItself(editor.context)).held(new int[]{42}).category(category).active(() -> !editor.flight.isFlightEnabled() && directorOptions.detachScene.isEnabled());
        toggle.keys().register(reloadScene, 19, () -> directorOptions.reloadScene.clickItself(editor.context)).held(new int[]{42}).category(category).active(() -> !editor.flight.isFlightEnabled());
        editorElement.setVisible(false);
        toggle.flex().relative((GuiElement)editor.timeline).set(0.0f, 0.0f, 20.0f, 20.0f).x(1.0f);
        open.flex().relative((GuiElement)editor.timeline).set(-20.0f, 0.0f, 20.0f, 20.0f);
        editor.timeline.flex().x(30).w(1.0f, -60);
        editor.top.remove((GuiElement)editor.timeline);
        cameraEditorElements = new GuiElement(mc).noCulling();
        cameraEditorElements.add(new IGuiElement[]{drawable, editor.timeline, toggle, open, editorElement});
        editor.top.add((IGuiElement)cameraEditorElements);
        refresh.accept(toggle);
    }

    @SideOnly(value=Side.CLIENT)
    public static SceneLocation get() {
        ItemStack right = Minecraft.func_71410_x().field_71439_g.func_184614_ca();
        if (right.func_77973_b() instanceof ItemPlayback && right.func_77978_p() != null && right.func_77978_p().func_74764_b("Scene")) {
            return new SceneLocation(right.func_77978_p().func_74779_i("Scene"));
        }
        return location;
    }

    public static boolean canSync() {
        return CameraHandler.get() != null;
    }

    public static class CameraGUIHandler {
        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        @Optional.Method(modid="aperture")
        public void onGuiOpen(GuiOpenEvent event) {
            if (Minecraft.func_71410_x().field_71439_g == null) {
                return;
            }
            GuiScreen current = Minecraft.func_71410_x().field_71462_r;
            GuiScreen toOpen = event.getGui();
            SceneLocation location = CameraHandler.get();
            boolean toOpenCamera = toOpen instanceof GuiCameraEditor;
            if (location != null) {
                int tick = mchorse.aperture.ClientProxy.getCameraEditor().timeline.value;
                if (!(current instanceof GuiCameraEditor) && toOpenCamera) {
                    CameraHandler.tick = tick;
                    if (reload) {
                        Dispatcher.sendToServer(new PacketScenePlay(location, 3, tick));
                    }
                    Dispatcher.sendToServer(new PacketRequestLength(location));
                    Dispatcher.sendToServer(new PacketSceneRequestCast(location));
                }
            }
            if (toOpenCamera) {
                GuiDashboard.get();
                GuiCameraEditor editor = mchorse.aperture.ClientProxy.getCameraEditor();
                GuiRecordingEditorPanel panel = ClientProxy.panels.recordingEditorPanel;
                panel.open();
                panel.appear();
                panel.selector.removeFromParent();
                panel.selector.flex().relative((IResizer)editor.viewport);
                panel.editor.removeFromParent();
                panel.editor.flex().relative((IResizer)editor.viewport);
                panel.records.removeFromParent();
                panel.records.flex().relative((IResizer)editor.viewport).h(1.0f, editorElement.isVisible() ? -80 : 0);
                panel.records.setVisible(false);
                cameraEditorElements.prepend((IGuiElement)panel.records);
                editorElement.add(new IGuiElement[]{panel.selector, panel.editor});
            } else if (current instanceof GuiCameraEditor) {
                ClientProxy.panels.recordingEditorPanel.save();
            }
        }
    }
}

