/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.api;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mchorse.blockbuster.api.ModelTransform;
import mchorse.blockbuster.api.formats.obj.ShapeKey;
import mchorse.mclib.utils.NBTUtils;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ModelPose {
    public float[] size = new float[]{1.0f, 1.0f, 1.0f};
    public Map<String, ModelTransform> limbs = new HashMap<String, ModelTransform>();
    public final List<ShapeKey> shapes = new ArrayList<ShapeKey>();

    public void copy(ModelPose pose) {
        int c = Math.min(pose.size.length, this.size.length);
        for (int i = 0; i < c; ++i) {
            this.size[i] = pose.size[i];
        }
        for (Map.Entry<String, ModelTransform> entry : this.limbs.entrySet()) {
            ModelTransform otherTransform = pose.limbs.get(entry.getKey());
            if (otherTransform == null) continue;
            entry.getValue().copy(otherTransform);
        }
    }

    public void fillInMissing(ModelPose pose) {
        for (Map.Entry<String, ModelTransform> entry : pose.limbs.entrySet()) {
            String key = entry.getKey();
            if (this.limbs.containsKey(key)) continue;
            this.limbs.put(key, entry.getValue().clone());
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof ModelPose) {
            ModelPose pose = (ModelPose)obj;
            return ModelTransform.equalFloatArray(this.size, pose.size) && this.limbs.equals(pose.limbs) && this.shapes.equals(pose.shapes);
        }
        return super.equals(obj);
    }

    public ModelPose copy() {
        ModelPose b = new ModelPose();
        b.size = new float[]{this.size[0], this.size[1], this.size[2]};
        for (Map.Entry<String, ModelTransform> entry : this.limbs.entrySet()) {
            b.limbs.put(entry.getKey(), entry.getValue().clone());
        }
        for (ShapeKey key : this.shapes) {
            b.shapes.add(key.copy());
        }
        return b;
    }

    public void fromNBT(NBTTagCompound tag) {
        NBTTagList list;
        if (tag.func_150297_b("Size", 9) && (list = tag.func_150295_c("Size", 5)).func_74745_c() >= 3) {
            NBTUtils.readFloatList((NBTTagList)list, (float[])this.size);
        }
        if (tag.func_150297_b("Poses", 10)) {
            this.limbs.clear();
            NBTTagCompound poses = tag.func_74775_l("Poses");
            for (String key : poses.func_150296_c()) {
                ModelTransform trans = new ModelTransform();
                trans.fromNBT(poses.func_74775_l(key));
                this.limbs.put(key, trans);
            }
        }
        if (tag.func_74764_b("Shapes")) {
            NBTTagList shapes = tag.func_150295_c("Shapes", 10);
            this.shapes.clear();
            for (int i = 0; i < shapes.func_74745_c(); ++i) {
                String key;
                key = shapes.func_150305_b(i);
                if (!key.func_74764_b("Name") || !key.func_74764_b("Value")) continue;
                ShapeKey shapeKey = new ShapeKey();
                shapeKey.fromNBT((NBTTagCompound)key);
                this.shapes.add(shapeKey);
            }
        }
    }

    public NBTTagCompound toNBT(NBTTagCompound tag) {
        NBTTagCompound poses = new NBTTagCompound();
        tag.func_74782_a("Size", (NBTBase)NBTUtils.writeFloatList((NBTTagList)new NBTTagList(), (float[])this.size));
        tag.func_74782_a("Poses", (NBTBase)poses);
        for (Map.Entry<String, ModelTransform> entry : this.limbs.entrySet()) {
            poses.func_74782_a(entry.getKey(), (NBTBase)entry.getValue().toNBT());
        }
        if (!this.shapes.isEmpty()) {
            NBTTagList shapes = new NBTTagList();
            for (ShapeKey shape : this.shapes) {
                if (shape.value == 0.0f) continue;
                shapes.func_74742_a(shape.toNBT());
            }
            tag.func_74782_a("Shapes", (NBTBase)shapes);
        }
        return tag;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("size", (Object)this.size).add("limbs", this.limbs).toString();
    }

    public void setSize(float w, float h, float d) {
        this.size[0] = w;
        this.size[1] = h;
        this.size[2] = d;
    }
}

