/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.api.formats.vox.data;

import java.nio.ByteBuffer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.opengl.GL11;

public class VoxTexture {
    private int texture = -1;
    private int[] palette;

    public VoxTexture(int[] palette) {
        this.palette = palette;
    }

    public int getTexture() {
        int count = this.palette.length;
        if (count > 0 && this.texture == -1) {
            ByteBuffer buffer = GLAllocation.func_74524_c((int)(count * 4));
            this.texture = GL11.glGenTextures();
            for (int color : this.palette) {
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color & 0xFF;
                int a = color >> 24 & 0xFF;
                buffer.put((byte)r);
                buffer.put((byte)g);
                buffer.put((byte)b);
                buffer.put((byte)a);
            }
            buffer.flip();
            GlStateManager.func_179144_i((int)this.texture);
            GlStateManager.func_187421_b((int)3553, (int)10241, (int)9728);
            GlStateManager.func_187421_b((int)3553, (int)10240, (int)9728);
            GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)count, (int)1, (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
        }
        return this.texture;
    }

    public void deleteTexture() {
        if (this.texture != -1) {
            GlStateManager.func_179150_h((int)this.texture);
            this.texture = -1;
        }
    }
}

