/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.api.json;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Map;
import mchorse.blockbuster.api.Model;
import mchorse.blockbuster.api.ModelLimb;
import mchorse.mclib.utils.resources.RLUtils;
import net.minecraft.util.ResourceLocation;

public class ModelAdapter
implements JsonDeserializer<Model>,
JsonSerializer<Model> {
    public static Gson plainGSON = new GsonBuilder().create();

    public Model deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Model model = (Model)plainGSON.fromJson(json, Model.class);
        JsonObject object = json.getAsJsonObject();
        model.shapes.clear();
        if (object.has("limbs")) {
            model.limbs = (Map)context.deserialize(object.get("limbs"), new TypeToken<Map<String, ModelLimb>>(){}.getType());
        }
        if (object.has("default")) {
            model.defaultTexture = RLUtils.create((JsonElement)object.get("default"));
        }
        if (model.extrudeMaxFactor <= 0) {
            model.extrudeMaxFactor = 1;
        }
        if (model.extrudeInwards <= 0) {
            model.extrudeInwards = 1;
        }
        return model;
    }

    public JsonElement serialize(Model src, Type typeOfSrc, JsonSerializationContext context) {
        JsonElement serial = plainGSON.toJsonTree((Object)src, typeOfSrc);
        JsonObject map = serial.getAsJsonObject();
        map.remove("model");
        map.remove("defaultTexture");
        map.remove("skins");
        map.remove("scale");
        map.remove("scaleGui");
        map.remove("limbs");
        map.remove("poses");
        map.remove("providesObj");
        map.remove("providesMtl");
        map.remove("legacyObj");
        map.remove("materials");
        map.remove("shapes");
        map.remove("extrudeMaxFactor");
        map.remove("extrudeInwards");
        if (src.presets.isEmpty()) {
            map.remove("presets");
        }
        if (!src.model.isEmpty()) {
            map.addProperty("model", src.model);
        }
        if (src.defaultTexture != null) {
            map.add("default", RLUtils.writeJson((ResourceLocation)src.defaultTexture));
        }
        if (!src.skins.isEmpty()) {
            map.addProperty("skins", src.skins);
        }
        if (src.scale[0] != 1.0f || src.scale[1] != 1.0f || src.scale[2] != 1.0f) {
            JsonArray array = new JsonArray();
            array.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(src.scale[0])));
            array.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(src.scale[1])));
            array.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(src.scale[2])));
            map.add("scale", (JsonElement)array);
        }
        if (src.scaleGui != 1.0f) {
            map.addProperty("scaleGui", (Number)Float.valueOf(src.scaleGui));
        }
        if (src.providesObj) {
            map.addProperty("providesObj", Boolean.valueOf(src.providesObj));
        }
        if (src.providesMtl) {
            map.addProperty("providesMtl", Boolean.valueOf(src.providesMtl));
        }
        if (!src.skins.isEmpty()) {
            map.addProperty("skins", src.skins);
        }
        if (src.extrudeMaxFactor > 1) {
            map.addProperty("extrudeMaxFactor", (Number)src.extrudeMaxFactor);
        }
        if (src.extrudeInwards > 1) {
            map.addProperty("extrudeInwards", (Number)src.extrudeInwards);
        }
        if (!src.legacyObj) {
            map.addProperty("legacyObj", Boolean.valueOf(src.legacyObj));
        }
        map.add("limbs", context.serialize(src.limbs));
        map.add("poses", context.serialize(src.poses));
        return map;
    }
}

