/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.audio;

import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.ClientProxy;
import mchorse.blockbuster.audio.AudioFile;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.utils.wav.Waveform;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

@SideOnly(value=Side.CLIENT)
public class AudioRenderer {
    public static void renderAll(int x, int y, int w, int h, int sw, int sh) {
        if (!Blockbuster.audioWaveformVisible.get()) {
            return;
        }
        y -= h;
        for (AudioFile file : ClientProxy.audio.files.values()) {
            if (file.isEmpty() || file.player.isStopped()) continue;
            AudioRenderer.renderWaveform(file, x, y, w, h, sw, sh);
            y -= h + 5;
        }
    }

    public static void renderWaveform(AudioFile file, int x, int y, int w, int h, int sw, int sh) {
        if (file == null || file.isEmpty()) {
            return;
        }
        float brightness = 0.45f;
        int half = w / 2;
        GuiDraw.drawVerticalGradientRect((int)(x + 2), (int)(y + 2), (int)(x + w - 2), (int)(y + h), (int)0, (int)-2013265920);
        Gui.func_73734_a((int)(x + 1), (int)y, (int)(x + 2), (int)(y + h), (int)-1426063361);
        Gui.func_73734_a((int)(x + w - 2), (int)y, (int)(x + w - 1), (int)(y + h), (int)-1426063361);
        Gui.func_73734_a((int)x, (int)(y + h - 1), (int)(x + w), (int)(y + h), (int)-1);
        GuiDraw.scissor((int)(x + 2), (int)(y + 2), (int)(w - 4), (int)(h - 4), (int)sw, (int)sh);
        Waveform wave = file.waveform;
        if (!wave.isCreated()) {
            wave.render();
        }
        float playback = file.player.getPlaybackPosition();
        int offset = (int)(playback * (float)wave.getPixelsPerSecond());
        int waveW = file.waveform.getWidth();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        int runningOffset = waveW - offset;
        if (runningOffset > 0) {
            file.waveform.draw(x + half, y, offset, 0, Math.min(runningOffset, half), h, h);
        }
        if (offset > 0) {
            int xx = offset > half ? x : x + half - offset;
            int oo = offset > half ? offset - half : 0;
            int ww = offset > half ? half : offset;
            GlStateManager.func_179124_c((float)0.45f, (float)0.45f, (float)0.45f);
            file.waveform.draw(xx, y, oo, 0, ww, h, h);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        }
        GuiDraw.unscissor((int)sw, (int)sh);
        Gui.func_73734_a((int)(x + half), (int)(y + 1), (int)(x + half + 1), (int)(y + h - 1), (int)-11012822);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        if (Blockbuster.audioWaveformFilename.get()) {
            GuiDraw.drawTextBackground((FontRenderer)fontRenderer, (String)file.name, (int)(x + 8), (int)(y + h / 2 - 4), (int)0xFFFFFF, (int)-1728053248);
        }
        if (Blockbuster.audioWaveformTime.get()) {
            int tick = (int)Math.floor(playback * 20.0f);
            int seconds = tick / 20;
            int milliseconds = (int)(tick % 20 == 0 ? 0.0 : (double)(tick % 20) * 5.0);
            String tickLabel = tick + "t (" + seconds + "." + StringUtils.leftPad((String)String.valueOf(milliseconds), (int)2, (String)"0") + "s)";
            GuiDraw.drawTextBackground((FontRenderer)fontRenderer, (String)tickLabel, (int)(x + w - 8 - fontRenderer.func_78256_a(tickLabel)), (int)(y + h / 2 - 4), (int)0xFFFFFF, (int)-1728053248);
        }
    }
}

