/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.ClientProxy;
import mchorse.blockbuster.aperture.CameraHandler;
import mchorse.blockbuster.audio.AudioRenderer;
import mchorse.blockbuster.client.gui.GuiRecordingOverlay;
import mchorse.blockbuster.client.model.parsing.ModelExtrudedLayer;
import mchorse.blockbuster.client.particles.emitter.BedrockEmitter;
import mchorse.blockbuster.client.render.tileentity.TileEntityGunItemStackRenderer;
import mchorse.blockbuster.client.render.tileentity.TileEntityModelItemStackRenderer;
import mchorse.blockbuster.client.textures.GifTexture;
import mchorse.blockbuster.common.OrientedBB;
import mchorse.blockbuster.common.entity.EntityActor;
import mchorse.blockbuster.recording.RecordPlayer;
import mchorse.blockbuster.recording.RecordRecorder;
import mchorse.blockbuster.recording.data.Frame;
import mchorse.blockbuster.recording.data.Record;
import mchorse.blockbuster.utils.EntityUtils;
import mchorse.mclib.utils.Color;
import mchorse.mclib.utils.ColorUtils;
import mchorse.mclib.utils.Interpolations;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderingHandler {
    private static TileEntityModelItemStackRenderer model = new TileEntityModelItemStackRenderer();
    private static TileEntityGunItemStackRenderer gun = new TileEntityGunItemStackRenderer();
    private static EntityLivingBase lastItemHolder;
    public static Set<Record> recordsToRender;
    public static Set<OrientedBB> obbsToRender;
    private boolean wasPaused;
    public static Map<ResourceLocation, GifTexture> gifs;
    private static final List<BedrockEmitter> emitters;
    private static final List<BedrockEmitter> emittersAdd;
    private static boolean emitterIsIterating;
    private static final List<EntityActor> lastRenderedEntities;
    private GuiRecordingOverlay overlay;

    public static void registerGif(ResourceLocation rl, GifTexture texture) {
        GifTexture old = gifs.remove(rl);
        if (old != null) {
            old.func_147631_c();
        }
        gifs.put(rl, texture);
    }

    public static void renderGreenSky() {
        int color = Blockbuster.chromaSkyColor.get();
        float skyR = (float)(color >> 16 & 0xFF) / 255.0f;
        float skyG = (float)(color >> 8 & 0xFF) / 255.0f;
        float skyB = (float)(color & 0xFF) / 255.0f;
        float skyA = (float)(color >> 24 & 0xFF) / 255.0f;
        GlStateManager.func_179082_a((float)skyR, (float)skyG, (float)skyB, (float)skyA);
        GlStateManager.func_179086_m((int)16384);
        GL11.glDisable((int)2912);
    }

    public static boolean isGreenSky() {
        return Blockbuster.chromaSky.get();
    }

    public static void renderLitParticles(float partialTicks) {
    }

    public static void renderParticles(float partialTicks) {
        if (!emitters.isEmpty()) {
            if (Blockbuster.snowstormDepthSorting.get()) {
                emitters.sort((a, b) -> {
                    double bd;
                    double ad = a.getDistanceSq();
                    if (ad < (bd = b.getDistanceSq())) {
                        return 1;
                    }
                    if (ad > bd) {
                        return -1;
                    }
                    return 0;
                });
            }
            emitterIsIterating = true;
            for (BedrockEmitter emitter : emitters) {
                emitter.render(partialTicks);
                emitter.running = emitter.sanityTicks < 2;
            }
            RenderingHandler.addEmitters();
            emitterIsIterating = false;
        }
    }

    public static void addEmitter(BedrockEmitter emitter, EntityLivingBase target) {
        if (!emitter.added) {
            if (emitterIsIterating) {
                emittersAdd.add(emitter);
            } else {
                emitters.add(emitter);
            }
            emitter.added = true;
            emitter.setTarget(target);
        }
    }

    private static void addEmitters() {
        if (!emittersAdd.isEmpty()) {
            emitters.addAll(emittersAdd);
            emittersAdd.clear();
        }
    }

    public static void updateEmitters() {
        ArrayList<BedrockEmitter> emittersRemove = new ArrayList<BedrockEmitter>();
        emitterIsIterating = true;
        for (BedrockEmitter emitter : emitters) {
            emitter.update();
            if (!emitter.isFinished()) continue;
            emittersRemove.add(emitter);
            emitter.added = false;
        }
        if (!emittersRemove.isEmpty()) {
            emitters.removeAll(emittersRemove);
        }
        RenderingHandler.addEmitters();
        emitterIsIterating = false;
    }

    public static void resetEmitters() {
        emitters.clear();
    }

    public static void addRenderActor(Entity entity) {
        if (entity instanceof EntityActor) {
            lastRenderedEntities.add((EntityActor)entity);
        }
    }

    public static void renderActors() {
        if (!Blockbuster.actorAlwaysRender.get() || MinecraftForgeClient.getRenderPass() != 0) {
            lastRenderedEntities.clear();
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        List actors = mc.field_71441_e.func_175644_a(EntityActor.class, EntitySelectors.field_94557_a);
        Entity camera = mc.func_175606_aa();
        actors.sort((a, b) -> {
            double dist2;
            double dist1 = camera.func_70068_e((Entity)a);
            return dist1 == (dist2 = camera.func_70068_e((Entity)b)) ? 0 : (dist2 - dist1 > 0.0 ? 1 : -1);
        });
        for (EntityActor actor : actors) {
            if (lastRenderedEntities.contains((Object)actor)) continue;
            mc.func_175598_ae().func_188388_a((Entity)actor, mc.func_184121_ak(), false);
        }
        lastRenderedEntities.clear();
    }

    public static void setLastItemHolder(EntityLivingBase entity) {
        if (lastItemHolder == null) {
            lastItemHolder = entity;
        }
    }

    public static void resetLastItemHolder(EntityLivingBase entity) {
        if (lastItemHolder == entity) {
            lastItemHolder = null;
        }
    }

    public static EntityLivingBase getLastItemHolder() {
        return lastItemHolder;
    }

    public RenderingHandler(GuiRecordingOverlay overlay) {
        this.overlay = overlay;
    }

    @SubscribeEvent
    public void onHUDRender(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            Minecraft.func_71410_x().field_71460_t.func_180436_i();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            Minecraft.func_71410_x().field_71460_t.func_175072_h();
        }
    }

    @SubscribeEvent
    public void onHUDRender(RenderGameOverlayEvent.Post event) {
        ScaledResolution resolution = event.getResolution();
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            int w = resolution.func_78326_a();
            int h = resolution.func_78328_b();
            this.overlay.draw(w, h);
            if (!CameraHandler.isCameraEditorOpen()) {
                int width = (int)((float)w * Blockbuster.audioWaveformWidth.get());
                AudioRenderer.renderAll((w - width) / 2, h / 2 + h / 4, width, Blockbuster.audioWaveformHeight.get(), w, h);
            }
        }
    }

    @SubscribeEvent
    public void onHUDRender(RenderGameOverlayEvent.Text event) {
        if (!Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            return;
        }
        ArrayList list = event.getLeft();
        list.add("");
        list.add(ClientProxy.manager.records.size() + " client records");
        RecordRecorder recorder = ClientProxy.manager.recorders.get(Minecraft.func_71410_x().field_71439_g);
        if (recorder != null) {
            list.add("Recording frame " + recorder.tick);
        }
    }

    @SubscribeEvent
    public void onRenderLast(RenderWorldLastEvent event) {
        ModelExtrudedLayer.tickCache();
        for (GifTexture texture : gifs.values()) {
            texture.func_110550_d();
        }
        Minecraft mc = Minecraft.func_71410_x();
        boolean isPaused = mc.func_147113_T();
        if (this.wasPaused != isPaused) {
            ClientProxy.audio.pause(isPaused);
            this.wasPaused = isPaused;
        }
        if (mc.field_71474_y.field_74330_P && !recordsToRender.isEmpty()) {
            this.renderPaths(event, recordsToRender);
        }
        recordsToRender.clear();
        if (mc.field_71474_y.field_74330_P && !obbsToRender.isEmpty()) {
            for (OrientedBB obb : obbsToRender) {
                obb.render(event);
            }
        }
        obbsToRender.clear();
    }

    private void renderPaths(RenderWorldLastEvent event, Set<Record> recordsToRender) {
        int shader = GL11.glGetInteger((int)35725);
        if (shader != 0) {
            OpenGlHelper.func_153161_d((int)0);
        }
        int delta = 2;
        Color color = ColorUtils.COLOR;
        Entity player = Minecraft.func_71410_x().func_175606_aa();
        Random random = new Random();
        double playerX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)event.getPartialTicks();
        double playerY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)event.getPartialTicks();
        double playerZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)event.getPartialTicks();
        GlStateManager.func_187441_d((float)2.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179090_x();
        for (Record record : recordsToRender) {
            int length = record.frames.size();
            if (length < 3) continue;
            random.setSeed(record.filename.hashCode());
            random.setSeed(random.nextLong());
            int hex = MathHelper.func_181758_c((float)random.nextFloat(), (float)1.0f, (float)1.0f);
            color.set(hex, false);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder builder = tessellator.func_178180_c();
            builder.func_178969_c(-playerX, -playerY, -playerZ);
            builder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
            for (int i = 2; i < length; i += 2) {
                Frame prev = record.frames.get(i - 2);
                Frame current = record.frames.get(i);
                builder.func_181662_b(prev.x, prev.y + 1.0, prev.z).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
                builder.func_181662_b(current.x, current.y + 1.0, current.z).func_181666_a(color.r, color.g, color.b, color.a).func_181675_d();
            }
            builder.func_178969_c(0.0, 0.0, 0.0);
            tessellator.func_78381_a();
        }
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_187441_d((float)1.0f);
        if (shader != 0) {
            OpenGlHelper.func_153161_d((int)shader);
        }
    }

    @SubscribeEvent
    public void onOrientCamera(EntityViewRenderEvent.CameraSetup event) {
        EntityPlayerSP thePlayer = Minecraft.func_71410_x().field_71439_g;
        RecordPlayer player = EntityUtils.getRecordPlayer((EntityLivingBase)thePlayer);
        if (player != null && player.record != null && !player.record.frames.isEmpty()) {
            Frame frame = player.record.getFrameSafe(player.tick);
            Frame prev = player.record.getFrameSafe(player.tick - 1);
            float partial = (float)event.getRenderPartialTicks();
            event.setYaw(Interpolations.lerp((float)prev.yawHead, (float)frame.yawHead, (float)partial) - 180.0f);
            event.setPitch(Interpolations.lerp((float)prev.pitch, (float)frame.pitch, (float)partial));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onRenderHand(RenderHandEvent event) {
        EntityPlayerSP thePlayer = Minecraft.func_71410_x().field_71439_g;
        RecordPlayer player = EntityUtils.getRecordPlayer((EntityLivingBase)thePlayer);
        if (player != null && player.record != null && !player.record.frames.isEmpty()) {
            Frame frame = player.record.getFrameSafe(player.tick);
            Frame prev = player.record.getFrameSafe(player.tick - 1);
            float partial = event.getPartialTicks();
            float yaw = Interpolations.lerp((float)prev.yaw, (float)frame.yaw, (float)partial);
            float pitch = Interpolations.lerp((float)prev.pitch, (float)frame.pitch, (float)partial);
            thePlayer.field_70177_z = yaw;
            thePlayer.field_70125_A = pitch;
            thePlayer.field_70126_B = yaw;
            thePlayer.field_70127_C = pitch;
        }
    }

    static {
        recordsToRender = new HashSet<Record>();
        obbsToRender = new HashSet<OrientedBB>();
        gifs = new HashMap<ResourceLocation, GifTexture>();
        emitters = new ArrayList<BedrockEmitter>();
        emittersAdd = new ArrayList<BedrockEmitter>();
        lastRenderedEntities = new ArrayList<EntityActor>();
    }
}

