/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client;

import java.io.File;
import java.io.FileInputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.ClientProxy;
import mchorse.blockbuster.CommonProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommandSender;
import org.apache.commons.io.FilenameUtils;

public class SkinHandler {
    public static void checkSkinsFolder() {
        if (!ClientProxy.skinsFolder.exists()) {
            return;
        }
        File[] files = ClientProxy.skinsFolder.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (!file.isFile()) continue;
            SkinHandler.tryReadingMovingSkinFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void tryReadingMovingSkinFile(File file) {
        block18: {
            try {
                FileInputStream stream = new FileInputStream(file);
                try (ImageInputStream in = ImageIO.createImageInputStream(stream);){
                    Iterator<ImageReader> readers = ImageIO.getImageReaders(in);
                    if (!readers.hasNext()) break block18;
                    ImageReader reader = readers.next();
                    try {
                        reader.setInput(in);
                        int w = reader.getWidth(0);
                        int h = reader.getHeight(0);
                        reader.dispose();
                        stream.close();
                        reader = null;
                        SkinHandler.tryMovingSkin(file, w, h);
                    }
                    finally {
                        if (reader != null) {
                            reader.dispose();
                            stream.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void tryMovingSkin(File file, int w, int h) {
        int hf;
        float aspect = (float)w / (float)h;
        if (aspect != 2.0f && aspect != 1.0f) {
            return;
        }
        int n = hf = aspect == 1.0f ? 64 : 32;
        if (w % 64 != 0 && h % hf != 0) {
            return;
        }
        SkinHandler.moveToDestination(hf == 64 ? "fred" : "steve", file);
    }

    private static void moveToDestination(String folder, File input) {
        boolean moved;
        String name = input.getName();
        File file = new File(CommonProxy.configFile, "models/" + folder + "/skins/" + name);
        for (int i = 1; file.exists() && i < 1000; ++i) {
            file = new File(CommonProxy.configFile, "models/" + folder + "/skins/" + FilenameUtils.getBaseName((String)name) + "_" + i + "." + FilenameUtils.getExtension((String)name));
        }
        if (!file.exists() && (moved = input.renameTo(file))) {
            Blockbuster.l10n.success((ICommandSender)Minecraft.func_71410_x().field_71439_g, "model.skin_moved", new Object[]{name, "blockbuster." + folder, file.getName()});
        }
    }
}

