/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client.gui;

import mchorse.blockbuster.client.gui.dashboard.panels.model_editor.utils.GuiPoseTransformations;
import mchorse.blockbuster.client.render.tileentity.TileEntityGunItemStackRenderer;
import mchorse.blockbuster.common.GunProps;
import mchorse.blockbuster.common.entity.EntityGunProjectile;
import mchorse.blockbuster.network.Dispatcher;
import mchorse.blockbuster.network.common.guns.PacketGunInfo;
import mchorse.blockbuster.utils.NBTUtils;
import mchorse.blockbuster.utils.mclib.BBIcons;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.GuiModelRenderer;
import mchorse.mclib.client.gui.framework.elements.GuiPanelBase;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiSlotElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTextElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDraw;
import mchorse.mclib.client.gui.utils.Area;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.mclib.utils.MathUtils;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.client.gui.creative.GuiCreativeMorphsMenu;
import mchorse.metamorph.client.gui.creative.GuiMorphRenderer;
import mchorse.metamorph.client.gui.creative.GuiNestedEdit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiGun
extends GuiBase {
    public GunProps props;
    public int index;
    public GuiPanelBase<GuiElement> panel;
    public GuiCreativeMorphsMenu morphs;
    public GuiElement gunOptions;
    public GuiNestedEdit pickDefault;
    public GuiNestedEdit pickFiring;
    public GuiTextElement fireCommand;
    public GuiTrackpadElement delay;
    public GuiTrackpadElement projectiles;
    public GuiTrackpadElement scatterX;
    public GuiTrackpadElement scatterY;
    public GuiToggleElement launch;
    public GuiToggleElement useTarget;
    public GuiSlotElement ammoStack;
    public GuiElement projectileOptions;
    public GuiNestedEdit pickProjectile;
    public GuiTextElement tickCommand;
    public GuiTrackpadElement ticking;
    public GuiTrackpadElement lifeSpan;
    public GuiToggleElement yaw;
    public GuiToggleElement pitch;
    public GuiToggleElement sequencer;
    public GuiToggleElement random;
    public GuiTrackpadElement hitboxX;
    public GuiTrackpadElement hitboxY;
    public GuiTrackpadElement speed;
    public GuiTrackpadElement friction;
    public GuiTrackpadElement gravity;
    public GuiTrackpadElement fadeIn;
    public GuiTrackpadElement fadeOut;
    public GuiElement impactOptions;
    public GuiNestedEdit pickImpact;
    public GuiTextElement impactCommand;
    public GuiTextElement impactEntityCommand;
    public GuiTrackpadElement impactDelay;
    public GuiToggleElement vanish;
    public GuiToggleElement bounce;
    public GuiToggleElement sticks;
    public GuiTrackpadElement hits;
    public GuiTrackpadElement damage;
    public GuiTrackpadElement knockbackHorizontal;
    public GuiTrackpadElement knockbackVertical;
    public GuiTrackpadElement bounceFactor;
    public GuiTextElement vanishCommand;
    public GuiTrackpadElement vanishDelay;
    public GuiTrackpadElement penetration;
    public GuiToggleElement ignoreBlocks;
    public GuiToggleElement ignoreEntities;
    public GuiElement transformOptions;
    public GuiPoseTransformations gun;
    public GuiPoseTransformations projectile;
    public GuiMorphRenderer arms;
    public GuiProjectileModelRenderer bullet;

    public GuiGun(ItemStack stack) {
        TileEntityGunItemStackRenderer.GunEntry entry = TileEntityGunItemStackRenderer.models.get(stack);
        this.props = entry == null ? NBTUtils.getGunProps(stack) : entry.props;
        Minecraft mc = Minecraft.func_71410_x();
        this.gunOptions = new GuiElement(mc);
        this.projectileOptions = new GuiElement(mc);
        this.transformOptions = new GuiElement(mc);
        this.impactOptions = new GuiElement(mc);
        this.panel = new GuiGunPanels(mc, this);
        this.panel.setPanel(this.gunOptions);
        this.panel.registerPanel(this.gunOptions, IKey.lang((String)"blockbuster.gui.gun.fire_props"), Icons.GEAR);
        this.panel.registerPanel(this.projectileOptions, IKey.lang((String)"blockbuster.gui.gun.projectile_props"), BBIcons.BULLET);
        this.panel.registerPanel(this.impactOptions, IKey.lang((String)"blockbuster.gui.gun.impact_props"), Icons.DOWNLOAD);
        this.panel.registerPanel(this.transformOptions, IKey.lang((String)"blockbuster.gui.gun.transforms"), Icons.POSE);
        this.morphs = new GuiCreativeMorphsMenu(mc, this::setMorph);
        Area area = this.gunOptions.area;
        this.pickDefault = new GuiNestedEdit(mc, editing -> this.openMorphs(1, (boolean)editing));
        this.pickFiring = new GuiNestedEdit(mc, false, editing -> this.openMorphs(2, (boolean)editing));
        this.fireCommand = new GuiTextElement(mc, 10000, value -> {
            this.props.fireCommand = value;
        });
        this.delay = new GuiTrackpadElement(mc, value -> {
            this.props.delay = value.intValue();
        });
        this.delay.limit(0.0, 2.147483647E9, true);
        this.projectiles = new GuiTrackpadElement(mc, value -> {
            this.props.projectiles = value.intValue();
        });
        this.projectiles.limit(0.0, 2.147483647E9, true);
        this.scatterX = new GuiTrackpadElement(mc, value -> {
            this.props.scatterX = value.floatValue();
        });
        this.scatterX.tooltip(IKey.lang((String)"blockbuster.gui.gun.scatter_x"));
        this.scatterY = new GuiTrackpadElement(mc, value -> {
            this.props.scatterY = value.floatValue();
        });
        this.scatterY.tooltip(IKey.lang((String)"blockbuster.gui.gun.scatter_y"));
        this.launch = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.gun.launch"), false, b -> {
            this.props.launch = b.isToggled();
        });
        this.useTarget = new GuiToggleElement(mc, IKey.lang((String)"metamorph.gui.body_parts.use_target"), false, b -> {
            this.props.useTarget = b.isToggled();
        });
        this.ammoStack = new GuiSlotElement(mc, 0, this::pickItem);
        this.ammoStack.tooltip(IKey.lang((String)"blockbuster.gui.gun.ammo_stack"));
        int firingOffset = 40;
        GuiElement scatterBar = new GuiElement(mc);
        scatterBar.flex().relative((IResizer)area).set(0.0f, 0.0f, 0.0f, 20.0f).x(0.5f).y(1.0f, -75).w(0.5f, -60).anchorX(0.5f).row(5);
        scatterBar.add(new IGuiElement[]{this.scatterX, this.scatterY});
        this.fireCommand.flex().relative((IResizer)area).set(10.0f, 0.0f, 0.0f, 20.0f).w(1.0f, -20).y(1.0f, -30);
        this.delay.flex().relative(scatterBar.resizer()).set(0.0f, 0.0f, 100.0f, 20.0f).x(-10).anchorX(1.0f);
        this.projectiles.flex().relative(scatterBar.resizer()).set(0.0f, 0.0f, 100.0f, 20.0f).x(1.0f, 10);
        this.pickDefault.flex().relative(this.delay.resizer()).w(1.0f).y(-5 - firingOffset);
        this.pickFiring.flex().relative(this.projectiles.resizer()).w(1.0f).y(-5 - firingOffset);
        this.ammoStack.flex().relative(this.pickFiring.resizer()).x(1.0f, 5).y(-2);
        GuiElement launchBar = new GuiElement(mc);
        launchBar.flex().relative(scatterBar.resizer()).y(-5 - firingOffset).w(1.0f).h(11).row(10);
        this.launch.flex().h(20);
        this.useTarget.flex().h(20);
        launchBar.add(new IGuiElement[]{this.launch, this.useTarget});
        this.gunOptions.add(new IGuiElement[]{scatterBar, launchBar, this.delay, this.projectiles, this.pickDefault, this.pickFiring, this.fireCommand, this.ammoStack});
        area = this.projectileOptions.area;
        this.pickProjectile = new GuiNestedEdit(mc, editing -> this.openMorphs(3, (boolean)editing));
        this.tickCommand = new GuiTextElement(mc, 10000, value -> {
            this.props.tickCommand = value;
        });
        this.ticking = new GuiTrackpadElement(mc, value -> {
            this.props.ticking = value.intValue();
        });
        this.ticking.tooltip(IKey.lang((String)"blockbuster.gui.gun.ticking"));
        this.ticking.limit(0.0, 2.147483647E9, true);
        this.lifeSpan = new GuiTrackpadElement(mc, value -> {
            this.props.lifeSpan = value.intValue();
        });
        this.lifeSpan.tooltip(IKey.lang((String)"blockbuster.gui.gun.life_span"));
        this.lifeSpan.limit(0.0, 2.147483647E9, true);
        this.yaw = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.gun.yaw"), false, b -> {
            this.props.yaw = b.isToggled();
        });
        this.pitch = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.gun.pitch"), false, b -> {
            this.props.pitch = b.isToggled();
        });
        this.sequencer = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.director.enabled"), false, b -> {
            this.props.sequencer = b.isToggled();
        });
        this.random = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.gun.random"), false, b -> {
            this.props.random = b.isToggled();
        });
        this.hitboxX = new GuiTrackpadElement(mc, value -> {
            this.props.hitboxX = value.floatValue();
        });
        this.hitboxX.tooltip(IKey.lang((String)"blockbuster.gui.gun.hitbox_x"));
        this.hitboxY = new GuiTrackpadElement(mc, value -> {
            this.props.hitboxY = value.floatValue();
        });
        this.hitboxY.tooltip(IKey.lang((String)"blockbuster.gui.gun.hitbox_y"));
        this.speed = new GuiTrackpadElement(mc, value -> {
            this.props.speed = value.floatValue();
        });
        this.speed.tooltip(IKey.lang((String)"blockbuster.gui.gun.speed"));
        this.friction = new GuiTrackpadElement(mc, value -> {
            this.props.friction = value.floatValue();
        });
        this.friction.tooltip(IKey.lang((String)"blockbuster.gui.gun.friction"));
        this.gravity = new GuiTrackpadElement(mc, value -> {
            this.props.gravity = value.floatValue();
        });
        this.gravity.tooltip(IKey.lang((String)"blockbuster.gui.gun.gravity"));
        this.fadeIn = new GuiTrackpadElement(mc, value -> {
            this.props.fadeIn = value.intValue();
        });
        this.fadeIn.tooltip(IKey.lang((String)"blockbuster.gui.gun.fade_in"));
        this.fadeIn.limit(0.0, 2.147483647E9, true);
        this.fadeOut = new GuiTrackpadElement(mc, value -> {
            this.props.fadeOut = value.intValue();
        });
        this.fadeOut.tooltip(IKey.lang((String)"blockbuster.gui.gun.fade_out"));
        this.fadeOut.limit(0.0, 2.147483647E9, true);
        this.pickProjectile.flex().relative((IResizer)area).w(100).x(0.75f, -50).y(1.0f, -60);
        this.tickCommand.flex().relative((IResizer)area).set(10.0f, 0.0f, 0.0f, 20.0f).w(1.0f, -20).y(1.0f, -30);
        GuiElement projectileFields = new GuiElement(mc);
        projectileFields.flex().relative((IResizer)area).w(1.0f).h(1.0f, -40).column(5).width(100).height(20).padding(10);
        projectileFields.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.gui.gun.category.motion")).background(), this.speed, this.friction, this.gravity});
        projectileFields.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.gui.gun.category.hitbox")).background().marginTop(12), this.hitboxX, this.hitboxY});
        projectileFields.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.gui.gun.category.timers")).background().marginTop(12), this.ticking, this.lifeSpan});
        projectileFields.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.gui.gun.category.rotation")).background().marginTop(12), this.yaw, this.pitch});
        projectileFields.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.gui.gun.category.transition")).background().marginTop(12), this.fadeIn, this.fadeOut});
        projectileFields.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.gui.gun.sequencer")).background().marginTop(12), this.sequencer, this.random});
        this.projectileOptions.add(new IGuiElement[]{this.pickProjectile, this.tickCommand, projectileFields});
        area = this.impactOptions.area;
        this.pickImpact = new GuiNestedEdit(mc, editing -> this.openMorphs(4, (boolean)editing));
        this.impactDelay = new GuiTrackpadElement(mc, value -> {
            this.props.impactDelay = value.intValue();
        });
        this.impactDelay.limit(0.0, 2.147483647E9, true);
        this.impactCommand = new GuiTextElement(mc, 10000, value -> {
            this.props.impactCommand = value;
        });
        this.impactEntityCommand = new GuiTextElement(mc, 10000, value -> {
            this.props.impactEntityCommand = value;
        });
        this.vanish = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.director.enabled"), false, b -> {
            this.props.vanish = b.isToggled();
        });
        this.bounce = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.director.enabled"), false, b -> {
            this.props.bounce = b.isToggled();
        });
        this.sticks = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.director.enabled"), false, b -> {
            this.props.sticks = b.isToggled();
        });
        this.hits = new GuiTrackpadElement(mc, value -> {
            this.props.hits = value.intValue();
        });
        this.hits.tooltip(IKey.lang((String)"blockbuster.gui.gun.hits"));
        this.hits.limit(0.0, 2.147483647E9, true);
        this.damage = new GuiTrackpadElement(mc, value -> {
            this.props.damage = value.floatValue();
        });
        this.knockbackHorizontal = new GuiTrackpadElement(mc, value -> {
            this.props.knockbackHorizontal = value.floatValue();
        });
        this.knockbackHorizontal.tooltip(IKey.lang((String)"blockbuster.gui.gun.knockback_horizontal"));
        this.knockbackVertical = new GuiTrackpadElement(mc, value -> {
            this.props.knockbackVertical = value.floatValue();
        });
        this.knockbackVertical.tooltip(IKey.lang((String)"blockbuster.gui.gun.knockback_vertical"));
        this.bounceFactor = new GuiTrackpadElement(mc, value -> {
            this.props.bounceFactor = value.floatValue();
        });
        this.bounceFactor.tooltip(IKey.lang((String)"blockbuster.gui.gun.bounce_factor"));
        this.vanishCommand = new GuiTextElement(mc, 10000, value -> {
            this.props.vanishCommand = value;
        });
        this.vanishDelay = new GuiTrackpadElement(mc, value -> {
            this.props.vanishDelay = value.intValue();
        });
        this.vanishDelay.limit(0.0).integer().tooltip(IKey.lang((String)"blockbuster.gui.gun.vanish_delay"));
        this.penetration = new GuiTrackpadElement(mc, value -> {
            this.props.penetration = value.floatValue();
        });
        this.penetration.block().tooltip(IKey.lang((String)"blockbuster.gui.gun.penetration"));
        this.ignoreBlocks = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.gun.ignore_blocks"), false, b -> {
            this.props.ignoreBlocks = b.isToggled();
        });
        this.ignoreBlocks.tooltip(IKey.lang((String)"blockbuster.gui.gun.ignore_blocks_tooltip"));
        this.ignoreEntities = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.gun.ignore_entities"), false, b -> {
            this.props.ignoreEntities = b.isToggled();
        });
        this.ignoreEntities.tooltip(IKey.lang((String)"blockbuster.gui.gun.ignore_entities_tooltip"));
        this.pickImpact.flex().relative((IResizer)area).w(100).x(0.75f, -40).y(1.0f, -140);
        this.vanishCommand.flex().relative((IResizer)area).set(10.0f, 0.0f, 0.0f, 20.0f).w(1.0f, -20).y(1.0f, -110);
        this.impactEntityCommand.flex().relative((GuiElement)this.vanishCommand).y(40).w(1.0f).h(20);
        this.impactCommand.flex().relative((GuiElement)this.impactEntityCommand).y(40).w(1.0f).h(20);
        GuiElement impactFields = new GuiElement(mc);
        impactFields.flex().relative((IResizer)area).w(1.0f).h(1.0f, -120).column(5).width(100).height(20).padding(10);
        impactFields.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.gui.gun.impact_delay")).background(), this.impactDelay});
        impactFields.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.gui.gun.damage")).background().marginTop(12), this.damage, this.knockbackHorizontal, this.knockbackVertical});
        impactFields.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.gui.gun.bounce")).background().marginTop(12), this.bounce, this.hits, this.bounceFactor});
        impactFields.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.gui.gun.vanish")).background().marginTop(12), this.vanish, this.vanishDelay});
        impactFields.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.gui.gun.sticks")).background().marginTop(12), this.sticks, this.penetration});
        impactFields.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.gui.gun.collision")).background().marginTop(12), this.ignoreBlocks, this.ignoreEntities});
        this.impactOptions.add(new IGuiElement[]{this.pickImpact, this.vanishCommand, this.impactEntityCommand, this.impactCommand, impactFields});
        area = this.transformOptions.area;
        this.gun = new GuiPoseTransformations(mc);
        this.projectile = new GuiPoseTransformations(mc);
        this.arms = new GuiMorphRenderer(mc);
        this.arms.setRotation(61.0f, -13.0f);
        this.arms.setPosition(0.1048045f, 1.081198f, 0.22774392f);
        this.arms.setScale(1.5f);
        try {
            this.arms.morph = MorphManager.INSTANCE.morphFromNBT(JsonToNBT.func_180713_a((String)"{Name:\"blockbuster.fred\"}"));
            this.arms.getEntity().func_184201_a(EntityEquipmentSlot.MAINHAND, stack);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.bullet = new GuiProjectileModelRenderer(mc);
        this.bullet.projectile.props = this.props;
        this.bullet.projectile.morph.setDirect(this.props.projectileMorph);
        this.bullet.setRotation(-64.0f, 16.0f);
        this.bullet.setPosition(-0.042806394f, 0.40452564f, -0.001203875f);
        this.bullet.setScale(2.5f);
        this.gun.flex().relative((IResizer)area).x(0.25f, -95).y(1.0f, -80).wh(190, 70);
        this.projectile.flex().relative((IResizer)area).x(0.75f, -95).y(1.0f, -80).wh(190, 70);
        this.arms.flex().relative((IResizer)area).wTo((IResizer)this.bullet.flex()).h(1.0f);
        this.bullet.flex().relative((IResizer)area).x(0.5f).wh(0.5f, 1.0f);
        this.transformOptions.add(new IGuiElement[]{this.arms, this.bullet, this.gun, this.projectile});
        this.morphs.flex().relative((IResizer)this.viewport).wh(1.0f, 1.0f);
        this.panel.flex().relative((IResizer)this.viewport).set(0.0f, 35.0f, 0.0f, 0.0f).w(1.0f, 0).h(1.0f, -35);
        this.pickDefault.setMorph(this.props.defaultMorph);
        this.pickFiring.setMorph(this.props.firingMorph);
        this.fireCommand.setText(this.props.fireCommand);
        this.delay.setValue((double)this.props.delay);
        this.projectiles.setValue((double)this.props.projectiles);
        this.scatterX.setValue((double)this.props.scatterX);
        this.scatterY.setValue((double)this.props.scatterY);
        this.launch.toggled(this.props.launch);
        this.useTarget.toggled(this.props.useTarget);
        this.ammoStack.setStack(this.props.ammoStack);
        this.pickProjectile.setMorph(this.props.projectileMorph);
        this.tickCommand.setText(this.props.tickCommand);
        this.ticking.setValue((double)this.props.ticking);
        this.lifeSpan.setValue((double)this.props.lifeSpan);
        this.yaw.toggled(this.props.yaw);
        this.pitch.toggled(this.props.pitch);
        this.sequencer.toggled(this.props.sequencer);
        this.random.toggled(this.props.random);
        this.hitboxX.setValue((double)this.props.hitboxX);
        this.hitboxY.setValue((double)this.props.hitboxY);
        this.speed.setValue((double)this.props.speed);
        this.friction.setValue((double)this.props.friction);
        this.gravity.setValue((double)this.props.gravity);
        this.fadeIn.setValue((double)this.props.fadeIn);
        this.fadeOut.setValue((double)this.props.fadeOut);
        this.pickImpact.setMorph(this.props.impactMorph);
        this.impactCommand.setText(this.props.impactCommand);
        this.impactEntityCommand.setText(this.props.impactEntityCommand);
        this.impactDelay.setValue((double)this.props.impactDelay);
        this.vanish.toggled(this.props.vanish);
        this.bounce.toggled(this.props.bounce);
        this.sticks.toggled(this.props.sticks);
        this.hits.setValue((double)this.props.hits);
        this.damage.setValue((double)this.props.damage);
        this.knockbackHorizontal.setValue((double)this.props.knockbackHorizontal);
        this.knockbackVertical.setValue((double)this.props.knockbackVertical);
        this.bounceFactor.setValue((double)this.props.bounceFactor);
        this.vanishCommand.setText(this.props.vanishCommand);
        this.vanishDelay.setValue((double)this.props.vanishDelay);
        this.penetration.setValue((double)this.props.penetration);
        this.ignoreBlocks.toggled(this.props.ignoreBlocks);
        this.ignoreEntities.toggled(this.props.ignoreEntities);
        this.gun.set(this.props.gunTransform);
        this.projectile.set(this.props.projectileTransform);
        this.root.add(this.panel);
        this.root.keys().register(IKey.lang((String)"blockbuster.gui.gun.keys.cycle"), 15, this::cycle);
    }

    private void pickItem(ItemStack stack) {
        this.props.ammoStack = stack;
    }

    protected void cycle() {
        int index = -1;
        for (int i = 0; i < this.panel.panels.size(); ++i) {
            if (this.panel.view.delegate != this.panel.panels.get(i)) continue;
            index = i;
            break;
        }
        index += GuiScreen.func_146272_n() ? 1 : -1;
        index = MathUtils.cycler((int)index, (int)0, (int)(this.panel.panels.size() - 1));
        ((GuiIconElement)this.panel.buttons.elements.get(index)).clickItself(GuiBase.getCurrent());
    }

    public boolean func_73868_f() {
        return false;
    }

    private void openMorphs(int i, boolean editing) {
        AbstractMorph morph = this.props.defaultMorph;
        if (i == 2) {
            morph = this.props.firingMorph;
        } else if (i == 3) {
            morph = this.props.projectileMorph;
        } else if (i == 4) {
            morph = this.props.impactMorph;
        }
        if (this.morphs.hasParent()) {
            if (i == this.index) {
                return;
            }
            this.morphs.finish();
            this.morphs.removeFromParent();
        }
        this.index = i;
        this.morphs.resize();
        this.morphs.setSelected(morph);
        if (editing) {
            this.morphs.enterEditMorph();
        }
        this.root.add((IGuiElement)this.morphs);
    }

    private void setMorph(AbstractMorph morph) {
        if (this.index == 1) {
            this.props.defaultMorph = morph;
            this.props.setCurrent(MorphUtils.copy((AbstractMorph)morph));
            this.pickDefault.setMorph(morph);
        } else if (this.index == 2) {
            this.props.firingMorph = morph;
            this.pickFiring.setMorph(morph);
        } else if (this.index == 3) {
            this.props.projectileMorph = morph;
            this.pickProjectile.setMorph(morph);
            this.bullet.projectile.morph.setDirect(this.props.projectileMorph);
        } else if (this.index == 4) {
            this.props.impactMorph = morph;
            this.pickImpact.setMorph(morph);
        }
    }

    protected void closeScreen() {
        super.closeScreen();
        Dispatcher.sendToServer(new PacketGunInfo(this.props.toNBT(), 0));
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GuiDraw.drawCustomBackground((int)0, (int)0, (int)this.field_146294_l, (int)this.field_146295_m);
        Gui.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)35, (int)-2013265920);
        this.func_73733_a(0, 35, this.field_146294_l, 45, -2013265920, 0);
        this.field_146289_q.func_175063_a(I18n.func_135052_a((String)"blockbuster.gui.gun.title", (Object[])new Object[0]), 10.0f, 15.0f, -1);
        EntityPlayerSP player = this.field_146297_k.field_71439_g;
        int w = this.viewport.w / 4;
        if (this.panel.view.delegate == this.gunOptions) {
            if (this.props.defaultMorph != null) {
                this.props.defaultMorph.renderOnScreen((EntityPlayer)player, this.pickDefault.area.mx(), this.pickDefault.area.y - 20, (float)w * 0.5f, 1.0f);
            }
            if (this.props.firingMorph != null) {
                this.props.firingMorph.renderOnScreen((EntityPlayer)player, this.pickFiring.area.mx(), this.pickFiring.area.y - 20, (float)w * 0.5f, 1.0f);
                GlStateManager.func_179086_m((int)256);
            }
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"blockbuster.gui.gun.default_morph", (Object[])new Object[0]), this.pickDefault.area.mx(), this.pickFiring.area.y - 12, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"blockbuster.gui.gun.fire_morph", (Object[])new Object[0]), this.pickFiring.area.mx(), this.pickFiring.area.y - 12, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"blockbuster.gui.gun.delay", (Object[])new Object[0]), this.delay.area.mx(), this.delay.area.y - 12, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"blockbuster.gui.gun.scatter", (Object[])new Object[0]), this.scatterX.area.ex() + 3, this.scatterX.area.y - 12, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"blockbuster.gui.gun.projectiles", (Object[])new Object[0]), this.projectiles.area.mx(), this.projectiles.area.y - 12, 0xFFFFFF);
            this.field_146289_q.func_175063_a(I18n.func_135052_a((String)"blockbuster.gui.gun.fire_command", (Object[])new Object[0]), (float)this.fireCommand.area.x, (float)(this.fireCommand.area.y - 12), 0xFFFFFF);
        } else if (this.panel.view.delegate == this.projectileOptions) {
            if (this.props.projectileMorph != null) {
                this.props.projectileMorph.renderOnScreen((EntityPlayer)player, this.pickProjectile.area.mx(), this.pickProjectile.area.y - 20, (float)w * 0.5f, 1.0f);
            }
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"blockbuster.gui.gun.projectile_morph", (Object[])new Object[0]), this.pickProjectile.area.mx(), this.pickProjectile.area.y - 12, 0xFFFFFF);
            this.field_146289_q.func_175063_a(I18n.func_135052_a((String)"blockbuster.gui.gun.tick_command", (Object[])new Object[0]), (float)this.tickCommand.area.x, (float)(this.tickCommand.area.y - 12), 0xFFFFFF);
        } else if (this.panel.view.delegate == this.impactOptions) {
            if (this.props.impactMorph != null) {
                this.props.impactMorph.renderOnScreen((EntityPlayer)player, this.pickImpact.area.mx(), this.pickImpact.area.y - 20, (float)w * 0.5f, 1.0f);
            }
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"blockbuster.gui.gun.impact_morph", (Object[])new Object[0]), this.pickImpact.area.mx(), this.pickImpact.area.y - 12, 0xFFFFFF);
            this.field_146289_q.func_175063_a(I18n.func_135052_a((String)"blockbuster.gui.gun.impact_command", (Object[])new Object[0]), (float)this.impactCommand.area.x, (float)(this.impactCommand.area.y - 12), 0xFFFFFF);
            this.field_146289_q.func_175063_a(I18n.func_135052_a((String)"blockbuster.gui.gun.impact_entity_command", (Object[])new Object[0]), (float)this.impactEntityCommand.area.x, (float)(this.impactEntityCommand.area.y - 12), 0xFFFFFF);
            this.field_146289_q.func_175063_a(I18n.func_135052_a((String)"blockbuster.gui.gun.vanish_command", (Object[])new Object[0]), (float)this.vanishCommand.area.x, (float)(this.vanishCommand.area.y - 12), 0xFFFFFF);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.panel.view.delegate == this.transformOptions) {
            String gun = I18n.func_135052_a((String)"blockbuster.gui.gun.gun_transforms", (Object[])new Object[0]);
            String trans = I18n.func_135052_a((String)"blockbuster.gui.gun.projectile_transforms", (Object[])new Object[0]);
            GuiDraw.drawTextBackground((FontRenderer)this.context.font, (String)gun, (int)this.gun.area.mx(this.context.font.func_78256_a(gun)), (int)(this.arms.area.y + 15), (int)0xFFFFFF, (int)-2013265920);
            GuiDraw.drawTextBackground((FontRenderer)this.context.font, (String)trans, (int)this.projectile.area.mx(this.context.font.func_78256_a(trans)), (int)(this.arms.area.y + 15), (int)0xFFFFFF, (int)-2013265920);
        }
    }

    public static class GuiGunPanels
    extends GuiPanelBase<GuiElement> {
        private GuiGun parentScreen;

        public GuiGunPanels(Minecraft mc, GuiGun parentScreen) {
            super(mc);
            this.parentScreen = parentScreen;
        }

        protected void drawBackground(GuiContext context, int x, int y, int w, int h) {
            Gui.func_73734_a((int)x, (int)y, (int)(x + w), (int)(y + h), (int)-16250872);
        }
    }

    public static class GuiProjectileModelRenderer
    extends GuiModelRenderer {
        public EntityGunProjectile projectile;

        public GuiProjectileModelRenderer(Minecraft mc) {
            super(mc);
            this.projectile = new EntityGunProjectile((World)mc.field_71441_e);
        }

        protected void drawUserModel(GuiContext context) {
            this.projectile.field_70173_aa = this.projectile.props.fadeIn;
            this.mc.func_175598_ae().func_188391_a((Entity)this.projectile, 0.0, 0.5, 0.0, 0.0f, context.partialTicks, false);
            GlStateManager.func_179090_x();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.5f, (float)0.0f);
            GL11.glLineWidth((float)5.0f);
            GL11.glBegin((int)1);
            GL11.glColor3d((double)0.0, (double)0.0, (double)0.0);
            GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
            GL11.glVertex3d((double)0.0, (double)0.0, (double)0.25);
            GL11.glEnd();
            GL11.glLineWidth((float)3.0f);
            GL11.glBegin((int)1);
            GL11.glColor3d((double)0.0, (double)1.0, (double)0.0);
            GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
            GL11.glVertex3d((double)0.0, (double)0.0, (double)0.25);
            GL11.glEnd();
            GL11.glLineWidth((float)1.0f);
            GL11.glPointSize((float)12.0f);
            GL11.glBegin((int)0);
            GL11.glColor3d((double)0.0, (double)0.0, (double)0.0);
            GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
            GL11.glEnd();
            GL11.glPointSize((float)10.0f);
            GL11.glBegin((int)0);
            GL11.glColor3d((double)1.0, (double)1.0, (double)1.0);
            GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
            GL11.glEnd();
            GL11.glPointSize((float)1.0f);
            GlStateManager.func_179121_F();
            GlStateManager.func_179126_j();
            GlStateManager.func_179145_e();
            GlStateManager.func_179098_w();
        }
    }
}

