/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client.gui.dashboard.panels.model_block;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.ClientProxy;
import mchorse.blockbuster.client.gui.dashboard.GuiBlockbusterPanel;
import mchorse.blockbuster.client.gui.dashboard.panels.model_block.GuiModelBlockList;
import mchorse.blockbuster.common.tileentity.TileEntityModel;
import mchorse.blockbuster.network.Dispatcher;
import mchorse.blockbuster.network.common.PacketModifyModelBlock;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiCirculateElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiSlotElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTransformations;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.mclib.GuiDashboard;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.mclib.utils.Direction;
import mchorse.mclib.utils.OpHelper;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.client.gui.creative.GuiNestedEdit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;

public class GuiModelBlockPanel
extends GuiBlockbusterPanel {
    public static final List<BlockPos> lastBlocks = new ArrayList<BlockPos>();
    private TileEntityModel model;
    private GuiTrackpadElement yaw;
    private GuiTrackpadElement pitch;
    private GuiTrackpadElement body;
    private GuiModelBlockTransformations trans;
    private GuiNestedEdit pickMorph;
    private GuiCirculateElement order;
    private GuiToggleElement shadow;
    private GuiToggleElement global;
    private GuiToggleElement enabled;
    private GuiModelBlockList list;
    private GuiElement subChildren;
    private GuiSlotElement[] slots = new GuiSlotElement[6];
    private Map<BlockPos, TileEntityModel> old = new HashMap<BlockPos, TileEntityModel>();

    public static void tryAddingBlock(BlockPos pos) {
        for (BlockPos stored : lastBlocks) {
            if (!pos.equals((Object)stored)) continue;
            return;
        }
        lastBlocks.add(pos);
    }

    public GuiModelBlockPanel(Minecraft mc, GuiDashboard dashboard) {
        super(mc, dashboard);
        this.subChildren = new GuiElement(mc).noCulling();
        this.subChildren.setVisible(false);
        this.add((IGuiElement)this.subChildren);
        this.trans = new GuiModelBlockTransformations(mc);
        this.trans.flex().relative((GuiElement)this).x(0.5f, 42).y(1.0f, -10).wh(250, 70).anchor(0.5f, 1.0f);
        this.subChildren.add((IGuiElement)this.trans);
        this.yaw = new GuiTrackpadElement(mc, value -> {
            this.model.rotateYawHead = value.floatValue();
        });
        this.subChildren.add((IGuiElement)this.yaw);
        this.yaw.tooltip(IKey.lang((String)"blockbuster.gui.model_block.yaw"));
        this.pitch = new GuiTrackpadElement(mc, value -> {
            this.model.rotatePitch = value.floatValue();
        });
        this.subChildren.add((IGuiElement)this.pitch);
        this.pitch.tooltip(IKey.lang((String)"blockbuster.gui.model_block.pitch"));
        this.body = new GuiTrackpadElement(mc, value -> {
            this.model.rotateBody = value.floatValue();
        });
        this.subChildren.add((IGuiElement)this.body);
        this.body.tooltip(IKey.lang((String)"blockbuster.gui.model_block.body"));
        this.yaw.flex().set(-85.0f, 0.0f, 80.0f, 20.0f).relative((GuiElement)this.trans);
        this.pitch.flex().set(0.0f, 25.0f, 80.0f, 20.0f).relative(this.yaw.resizer());
        this.body.flex().set(0.0f, 25.0f, 80.0f, 20.0f).relative(this.pitch.resizer());
        this.order = new GuiCirculateElement(mc, b -> {
            this.model.order = TileEntityModel.RotationOrder.values()[this.order.getValue()];
        });
        this.subChildren.add((IGuiElement)this.order);
        this.order.addLabel(IKey.str((String)"ZYX"));
        this.order.addLabel(IKey.str((String)"XYZ"));
        this.order.flex().relative((GuiElement)this.trans.rx).set(40.0f, -22.0f, 40.0f, 20.0f);
        GuiElement column = new GuiElement(mc);
        column.flex().relative((GuiElement)this).w(120).column(5).vertical().stretch().height(20).padding(10);
        this.pickMorph = new GuiNestedEdit(mc, editing -> ClientProxy.panels.addMorphs((GuiElement)this, (boolean)editing, this.model.morph.get()));
        GuiButtonElement look = new GuiButtonElement(mc, IKey.lang((String)"blockbuster.gui.model_block.look"), button -> {
            this.model.ry = 180.0f - this.mc.field_71439_g.field_70177_z;
            this.fillData();
        });
        this.shadow = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.model_block.shadow"), false, button -> {
            this.model.shadow = button.isToggled();
        });
        this.global = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.model_block.global"), false, button -> {
            this.model.global = button.isToggled();
        });
        this.global.tooltip(IKey.lang((String)"blockbuster.gui.model_block.global_tooltip"), Direction.BOTTOM);
        this.enabled = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.model_block.enabled"), false, button -> {
            this.model.enabled = button.isToggled();
        });
        this.enabled.tooltip(IKey.lang((String)"blockbuster.gui.model_block.enabled_tooltip"), Direction.BOTTOM);
        column.add(new IGuiElement[]{this.pickMorph, look, this.shadow, this.global, this.enabled});
        this.subChildren.add((IGuiElement)column);
        this.list = new GuiModelBlockList(mc, IKey.lang((String)"blockbuster.gui.model_block.title"), tile -> this.setModelBlock((TileEntityModel)((Object)((Object)tile.get(0)))));
        this.list.flex().relative((IResizer)this.flex()).set(0.0f, 0.0f, 120.0f, 0.0f).h(1.0f).x(1.0f, -120);
        this.add((IGuiElement)this.list);
        GuiIconElement toggle = new GuiIconElement(mc, Icons.BLOCK, b -> this.list.toggleVisible());
        toggle.flex().set(0.0f, 2.0f, 24.0f, 24.0f).relative((GuiElement)this).x(1.0f, -28);
        this.add((IGuiElement)toggle);
        for (int i = 0; i < this.slots.length; ++i) {
            int slot = i;
            this.slots[i] = new GuiSlotElement(mc, i, stack -> this.pickItem((ItemStack)stack, slot));
            this.slots[i].flex().relative((IResizer)this.area).anchor(0.5f, 0.5f);
            this.subChildren.add((IGuiElement)this.slots[i]);
        }
        this.slots[0].flex().x(0.375f).y(0.5f, -15);
        this.slots[1].flex().x(0.375f).y(0.5f, 15);
        this.slots[2].flex().x(0.625f).y(0.5f, 45);
        this.slots[3].flex().x(0.625f).y(0.5f, 15);
        this.slots[4].flex().x(0.625f).y(0.5f, -15);
        this.slots[5].flex().x(0.625f).y(0.5f, -45);
    }

    public boolean needsBackground() {
        return false;
    }

    private void pickItem(ItemStack stack, int slot) {
        this.model.slots[slot] = stack.func_77946_l();
        this.model.updateEntity();
    }

    private void setMorph(AbstractMorph morph) {
        if (this.model != null) {
            this.model.morph.setDirect(morph);
        }
        this.pickMorph.setMorph(morph);
    }

    @Override
    public void appear() {
        super.appear();
        ClientProxy.panels.picker(this::setMorph);
    }

    public void open() {
        if (!OpHelper.isPlayerOp()) {
            return;
        }
        this.updateList();
        if (this.model != null && this.mc.field_71441_e.func_175625_s(this.model.func_174877_v()) == null) {
            this.setModelBlock(null);
        }
    }

    public void close() {
        this.save(null);
    }

    public void save(TileEntityModel model) {
        this.save(model, false);
    }

    public void save(TileEntityModel model, boolean force) {
        if (!OpHelper.isPlayerOp()) {
            return;
        }
        if (!force) {
            if (this.model == null || this.model == model) {
                return;
            }
            if (model != null && this.model.func_174877_v().equals((Object)model.func_174877_v())) {
                return;
            }
        }
        if (ClientProxy.panels.morphs.hasParent()) {
            ClientProxy.panels.morphs.finish();
            ClientProxy.panels.morphs.removeFromParent();
        }
        Dispatcher.sendToServer(new PacketModifyModelBlock(this.model.func_174877_v(), this.model));
        if (Blockbuster.modelBlockRestore.get()) {
            this.old.put(this.model.func_174877_v(), this.model);
        }
    }

    public GuiModelBlockPanel openModelBlock(TileEntityModel model) {
        if (model != null && Blockbuster.modelBlockRestore.get() && this.old.containsKey(model.func_174877_v())) {
            TileEntityModel old = this.old.get(model.func_174877_v());
            model.copyData(old, false);
        }
        GuiModelBlockPanel.tryAddingBlock(model.func_174877_v());
        this.updateList();
        this.list.setVisible(false);
        return this.setModelBlock(model);
    }

    public GuiModelBlockPanel setModelBlock(TileEntityModel model) {
        this.save(model);
        this.list.setCurrent((Object)model);
        this.subChildren.setVisible(model != null);
        this.model = model;
        this.fillData();
        return this;
    }

    private void updateList() {
        this.list.clear();
        for (BlockPos pos : lastBlocks) {
            this.list.addBlock(pos);
        }
        this.list.setCurrent((Object)this.model);
    }

    private void fillData() {
        if (this.model != null) {
            this.yaw.setValue((double)this.model.rotateYawHead);
            this.pitch.setValue((double)this.model.rotatePitch);
            this.body.setValue((double)this.model.rotateBody);
            this.trans.set(this.model);
            this.pickMorph.setMorph(this.model.morph.get());
            this.order.setValue(this.model.order.ordinal());
            this.shadow.toggled(this.model.shadow);
            this.global.toggled(this.model.global);
            this.enabled.toggled(this.model.enabled);
            for (int i = 0; i < this.slots.length; ++i) {
                this.slots[i].setStack(this.model.slots[i]);
            }
        }
    }

    public void draw(GuiContext context) {
        AbstractMorph morph;
        if (this.model != null && (morph = this.model.morph.get()) != null) {
            int x = this.area.mx();
            int y = this.area.y + 30;
            int w = Math.max(this.font.func_78256_a(morph.name), this.font.func_78256_a(morph.getDisplayName()));
            Gui.func_73734_a((int)(x - w / 2 - 3), (int)(y - 20), (int)(x + w / 2 + 3), (int)y, (int)-2013265920);
            this.func_73732_a(this.font, morph.getDisplayName(), x, y - this.font.field_78288_b * 2, 0xFFFFFF);
            this.func_73732_a(this.font, morph.name, x, y - this.font.field_78288_b, 0xCCCCCC);
        }
        if (this.subChildren.isVisible()) {
            this.func_73731_b(this.font, I18n.func_135052_a((String)"blockbuster.gui.model_block.entity", (Object[])new Object[0]), this.yaw.area.x + 2, this.yaw.area.y - 12, 0xFFFFFF);
        } else if (this.model == null) {
            this.func_73732_a(this.font, I18n.func_135052_a((String)"blockbuster.gui.model_block.not_selected", (Object[])new Object[0]), this.area.mx(), this.area.my() - 6, 0xFFFFFF);
        }
        super.draw(context);
    }

    public static class GuiModelBlockTransformations
    extends GuiTransformations {
        public TileEntityModel model;

        public GuiModelBlockTransformations(Minecraft mc) {
            super(mc);
            this.sx.callback = value -> this.setS((double)value, this.sy.value, this.sz.value);
            this.one.callback = toggle -> {
                this.model.one = toggle.isToggled();
                this.sy.setVisible(!this.model.one);
                this.sz.setVisible(!this.model.one);
            };
        }

        public void set(TileEntityModel model) {
            this.model = model;
            if (model != null) {
                this.fillT(model.x, model.y, model.z);
                this.fillS(model.sx, model.sy, model.sz);
                this.fillR(model.rx, model.ry, model.rz);
                this.one.toggled(model.one);
                this.updateScaleFields();
            }
        }

        public void setT(double x, double y, double z) {
            this.model.x = (float)x;
            this.model.y = (float)y;
            this.model.z = (float)z;
        }

        public void setS(double x, double y, double z) {
            this.model.sx = (float)x;
            this.model.sy = (float)y;
            this.model.sz = (float)z;
        }

        public void setR(double x, double y, double z) {
            this.model.rx = (float)x;
            this.model.ry = (float)y;
            this.model.rz = (float)z;
        }
    }
}

