/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client.gui.dashboard.panels.model_editor.tabs;

import javax.vecmath.Vector3f;
import mchorse.blockbuster.api.Model;
import mchorse.blockbuster.api.ModelLimb;
import mchorse.blockbuster.client.gui.dashboard.panels.model_editor.GuiModelEditorPanel;
import mchorse.blockbuster.client.gui.dashboard.panels.model_editor.tabs.GuiAnchorModal;
import mchorse.blockbuster.client.gui.dashboard.panels.model_editor.tabs.GuiModelEditorTab;
import mchorse.blockbuster.client.gui.dashboard.panels.model_editor.utils.GuiTextureCanvas;
import mchorse.blockbuster.client.gui.dashboard.panels.model_editor.utils.GuiThreeElement;
import mchorse.blockbuster.client.model.ModelCustomRenderer;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.GuiScrollElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiCirculateElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiIconElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.context.GuiSimpleContextMenu;
import mchorse.mclib.client.gui.framework.elements.input.GuiColorElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiStringListElement;
import mchorse.mclib.client.gui.framework.elements.modals.GuiListModal;
import mchorse.mclib.client.gui.framework.elements.modals.GuiMessageModal;
import mchorse.mclib.client.gui.framework.elements.modals.GuiModal;
import mchorse.mclib.client.gui.framework.elements.modals.GuiPromptModal;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.mclib.utils.Color;
import mchorse.mclib.utils.Interpolations;
import net.minecraft.client.Minecraft;

public class GuiModelLimbs
extends GuiModelEditorTab {
    private GuiIconElement addLimb;
    private GuiIconElement dupeLimb;
    private GuiIconElement removeLimb;
    private GuiIconElement renameLimb;
    private GuiIconElement parentLimb;
    private GuiStringListElement limbs;
    private GuiScrollElement scroll;
    private GuiThreeElement size;
    private GuiTrackpadElement sizeOffset;
    private GuiTrackpadElement itemScale;
    private GuiButtonElement texture;
    private GuiThreeElement anchor;
    private GuiThreeElement origin;
    private GuiTextureCanvas textureEditor;
    private GuiColorElement color;
    private GuiToggleElement mirror;
    private GuiToggleElement lighting;
    private GuiToggleElement shading;
    private GuiToggleElement smooth;
    private GuiToggleElement is3D;
    private GuiCirculateElement holding;
    private GuiCirculateElement slot;
    private GuiToggleElement hold;
    private GuiToggleElement swiping;
    private GuiToggleElement lookX;
    private GuiToggleElement lookY;
    private GuiToggleElement swinging;
    private GuiToggleElement idle;
    private GuiToggleElement invert;
    private GuiToggleElement wheel;
    private GuiToggleElement wing;
    private GuiToggleElement roll;
    private GuiToggleElement cape;

    public GuiModelLimbs(Minecraft mc, GuiModelEditorPanel panel) {
        super(mc, panel);
        this.title = IKey.lang((String)"blockbuster.gui.me.limbs.title");
        this.limbs = new GuiStringListElement(mc, str -> this.setLimb((String)str.get(0)));
        this.limbs.background().flex().relative((GuiElement)this).y(20).w(1.0f).h(100);
        this.scroll = new GuiScrollElement(mc);
        this.scroll.scroll.scrollSpeed = 15;
        this.scroll.flex().relative((GuiElement)this.limbs).y(1.0f).w(1.0f).hTo((IResizer)this.area, 1.0f).column(5).vertical().stretch().scroll().height(20).padding(10);
        this.textureEditor = new GuiTextureCanvas(mc, this);
        this.textureEditor.flex().relative((GuiElement)this.limbs).y(1.0f).w(1.0f).hTo((IResizer)this.area, 1.0f);
        this.size = new GuiThreeElement(mc, values -> {
            this.panel.limb.size[0] = values[0].intValue();
            this.panel.limb.size[1] = values[1].intValue();
            this.panel.limb.size[2] = values[2].intValue();
            this.panel.rebuildModel();
        });
        this.size.setLimit(0, 8192, true);
        this.sizeOffset = new GuiTrackpadElement(mc, value -> {
            this.panel.limb.sizeOffset = value.floatValue();
            this.panel.rebuildModel();
        });
        this.itemScale = new GuiTrackpadElement(mc, value -> {
            this.panel.limb.itemScale = value.floatValue();
            this.panel.dirty();
        });
        this.texture = new GuiButtonElement(mc, IKey.comp((IKey[])new IKey[]{IKey.lang((String)"blockbuster.gui.edit"), IKey.str((String)"...")}), b -> {
            this.textureEditor.toggleVisible();
            this.textureEditor.setSize(this.panel.model.texture[0], this.panel.model.texture[1]);
        });
        this.anchor = new GuiThreeElement(mc, values -> {
            this.panel.limb.anchor[0] = values[0].floatValue();
            this.panel.limb.anchor[1] = values[1].floatValue();
            this.panel.limb.anchor[2] = values[2].floatValue();
            this.panel.rebuildModel();
        });
        this.origin = new GuiThreeElement(mc, values -> {
            this.panel.limb.origin[0] = values[0].floatValue();
            this.panel.limb.origin[1] = values[1].floatValue();
            this.panel.limb.origin[2] = values[2].floatValue();
            this.panel.rebuildModel();
        });
        this.origin.context(() -> {
            ModelCustomRenderer renderer = this.panel.renderModel.get(this.panel.limb.name);
            if (renderer != null && renderer.min != null && renderer.max != null) {
                return new GuiSimpleContextMenu(this.mc).action(Icons.FULLSCREEN, IKey.lang((String)"blockbuster.gui.me.limbs.context.anchor_setup"), () -> this.setupAnchorPoint(renderer, false)).action(Icons.DOWNLOAD, IKey.lang((String)"blockbuster.gui.me.limbs.context.anchor_setup"), () -> this.setupAnchorPoint(renderer, true));
            }
            return null;
        });
        this.slot = new GuiCirculateElement(mc, b -> {
            this.panel.limb.slot = ModelLimb.ArmorSlot.values()[this.slot.getValue()];
            this.panel.dirty();
        });
        this.slot.tooltip(IKey.lang((String)"blockbuster.gui.me.limbs.slot"));
        this.hold = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.me.limbs.holding"), false, b -> {
            this.panel.limb.hold = b.isToggled();
            this.panel.dirty();
        });
        for (ModelLimb.ArmorSlot slot : ModelLimb.ArmorSlot.values()) {
            this.slot.addLabel(IKey.lang((String)("blockbuster.gui.me.limbs.slots." + slot.name)));
        }
        this.color = new GuiColorElement(mc, eh -> {
            Color color = this.color.picker.color;
            this.panel.limb.color[0] = color.r;
            this.panel.limb.color[1] = color.g;
            this.panel.limb.color[2] = color.b;
            this.panel.limb.opacity = color.a;
            this.panel.dirty();
        });
        this.color.picker.editAlpha();
        this.mirror = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.me.limbs.mirror"), false, b -> {
            this.panel.limb.mirror = b.isToggled();
            this.panel.rebuildModel();
        });
        this.mirror.flex().h(20);
        this.lighting = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.me.limbs.lighting"), false, b -> {
            this.panel.limb.lighting = b.isToggled();
            this.panel.dirty();
        });
        this.shading = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.me.limbs.shading"), false, b -> {
            this.panel.limb.shading = b.isToggled();
            this.panel.dirty();
        });
        this.smooth = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.me.limbs.smooth"), false, b -> {
            this.panel.limb.smooth = b.isToggled();
            this.panel.dirty();
        });
        this.is3D = new GuiToggleElement(mc, IKey.str((String)"3D"), false, b -> {
            this.panel.limb.is3D = b.isToggled();
            this.panel.dirty();
        });
        this.holding = new GuiCirculateElement(mc, b -> {
            this.panel.limb.holding = ModelLimb.Holding.values()[this.holding.getValue()];
            this.panel.rebuildModel();
        });
        this.holding.tooltip(IKey.lang((String)"blockbuster.gui.me.limbs.hold"));
        this.holding.addLabel(IKey.lang((String)"blockbuster.gui.me.limbs.none"));
        this.holding.addLabel(IKey.lang((String)"blockbuster.gui.me.limbs.right"));
        this.holding.addLabel(IKey.lang((String)"blockbuster.gui.me.limbs.left"));
        this.swiping = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.me.limbs.swiping"), false, b -> {
            this.panel.limb.swiping = b.isToggled();
            this.panel.dirty();
        });
        this.lookX = new GuiToggleElement(mc, IKey.comp((IKey[])new IKey[]{IKey.lang((String)"blockbuster.gui.me.limbs.looking"), IKey.str((String)" X")}), false, b -> {
            this.panel.limb.lookX = b.isToggled();
            this.panel.dirty();
        });
        this.lookY = new GuiToggleElement(mc, IKey.comp((IKey[])new IKey[]{IKey.lang((String)"blockbuster.gui.me.limbs.looking"), IKey.str((String)" Y")}), false, b -> {
            this.panel.limb.lookY = b.isToggled();
            this.panel.dirty();
        });
        this.swinging = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.me.limbs.swinging"), false, b -> {
            this.panel.limb.swinging = b.isToggled();
            this.panel.dirty();
        });
        this.idle = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.me.limbs.idle"), false, b -> {
            this.panel.limb.idle = b.isToggled();
            this.panel.dirty();
        });
        this.invert = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.me.limbs.invert"), false, b -> {
            this.panel.limb.invert = b.isToggled();
            this.panel.dirty();
        });
        this.wheel = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.me.limbs.wheel"), false, b -> {
            this.panel.limb.wheel = b.isToggled();
            this.panel.dirty();
        });
        this.wing = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.me.limbs.wing"), false, b -> {
            this.panel.limb.wing = b.isToggled();
            this.panel.dirty();
        });
        this.roll = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.me.limbs.roll"), false, b -> {
            this.panel.limb.roll = b.isToggled();
            this.panel.dirty();
        });
        this.cape = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.me.limbs.cape"), false, b -> {
            this.panel.limb.cape = b.isToggled();
            this.panel.dirty();
        });
        this.scroll.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.gui.me.limbs.size")).background(), this.size});
        this.scroll.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.gui.me.limbs.size_offset")).background(), this.sizeOffset});
        this.scroll.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.gui.me.limbs.item_scale")).background(), this.itemScale});
        this.scroll.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.gui.me.limbs.texture")).background().marginTop(12), Elements.row((Minecraft)mc, (int)5, (int)0, (int)20, (GuiElement[])new GuiElement[]{this.texture, this.mirror})});
        this.scroll.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.gui.me.limbs.anchor")).background().marginTop(12), this.anchor});
        this.scroll.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.gui.me.limbs.origin")).background(), this.origin});
        GuiElement appearance = new GuiElement(mc);
        appearance.flex().grid(5).items(2).resizes(true);
        appearance.add(new IGuiElement[]{this.lighting, this.shading});
        appearance.add(new IGuiElement[]{this.smooth, this.is3D});
        GuiElement animation = new GuiElement(mc);
        animation.flex().grid(5).items(2).resizes(true);
        animation.add(new IGuiElement[]{this.lookX, this.lookY});
        animation.add(new IGuiElement[]{this.idle, this.swinging});
        animation.add(new IGuiElement[]{this.invert, this.swiping});
        animation.add(new IGuiElement[]{this.hold, this.wheel});
        animation.add(new IGuiElement[]{this.wing, this.roll});
        animation.add((IGuiElement)this.cape);
        this.scroll.add((IGuiElement)Elements.row((Minecraft)mc, (int)5, (GuiElement[])new GuiElement[]{this.slot, this.holding}));
        this.scroll.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.gui.me.limbs.appearance")).background().marginTop(12), appearance, this.color});
        this.scroll.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.gui.me.limbs.animation")).background().marginTop(12), animation});
        this.addLimb = new GuiIconElement(mc, Icons.ADD, b -> this.addLimb());
        this.dupeLimb = new GuiIconElement(mc, Icons.DUPE, b -> this.dupeLimb());
        this.removeLimb = new GuiIconElement(mc, Icons.REMOVE, b -> this.removeLimb());
        this.renameLimb = new GuiIconElement(mc, Icons.EDIT, b -> this.renameLimb());
        this.parentLimb = new GuiIconElement(mc, Icons.LIMB, b -> this.parentLimb());
        GuiElement sidebar = Elements.row((Minecraft)mc, (int)0, (int)0, (int)20, (GuiElement[])new GuiElement[]{this.addLimb, this.dupeLimb, this.parentLimb, this.renameLimb, this.removeLimb});
        sidebar.flex().relative((GuiElement)this).x(1.0f).h(20).anchorX(1.0f).row(0).resize();
        this.add(new IGuiElement[]{sidebar, this.limbs, this.scroll, this.textureEditor});
    }

    private void setupAnchorPoint(ModelCustomRenderer renderer, boolean move) {
        GuiAnchorModal modal;
        this.panel.modelRenderer.anchorPreview = modal = new GuiAnchorModal(this.mc, IKey.lang((String)"blockbuster.gui.me.limbs.anchor_modal"), anchor -> this.doSetupAnchorPoint(renderer, (Vector3f)anchor, move));
        GuiModal.addFullModal((GuiElement)this, () -> modal);
    }

    private void doSetupAnchorPoint(ModelCustomRenderer renderer, Vector3f anchor, boolean move) {
        renderer.limb.origin[0] = Interpolations.lerp((float)renderer.min.x, (float)renderer.max.x, (float)anchor.x);
        renderer.limb.origin[1] = Interpolations.lerp((float)renderer.min.y, (float)renderer.max.y, (float)anchor.y);
        renderer.limb.origin[2] = Interpolations.lerp((float)renderer.min.z, (float)renderer.max.z, (float)anchor.z);
        if (move) {
            float[] translate = this.panel.pose.limbs.get((Object)renderer.limb.name).translate;
            translate[0] = -renderer.limb.origin[0] * 16.0f;
            translate[1] = renderer.limb.origin[1] * 16.0f;
            translate[2] = -renderer.limb.origin[2] * 16.0f;
        }
        this.panel.modelRenderer.anchorPreview = null;
        this.panel.setLimb(renderer.limb.name);
        this.panel.rebuildModel();
    }

    private void addLimb() {
        GuiModal.addFullModal((GuiElement)this, () -> {
            GuiPromptModal modal = new GuiPromptModal(this.mc, IKey.lang((String)"blockbuster.gui.me.limbs.new_limb"), this::addLimb);
            return modal.setValue(this.panel.limb.name);
        });
    }

    private void addLimb(String text) {
        if (!this.panel.model.limbs.containsKey(text)) {
            this.panel.model.addLimb(text);
            this.panel.setLimb(text);
            this.limbs.add((Object)text);
            this.limbs.setCurrent((Object)text);
            this.panel.rebuildModel();
        }
    }

    private void dupeLimb() {
        ModelLimb limb = this.panel.limb.clone();
        while (this.panel.model.limbs.containsKey(limb.name)) {
            limb.name = limb.name + "_copy";
        }
        this.panel.model.addLimb(limb);
        this.panel.setLimb(limb.name);
        this.limbs.add((Object)limb.name);
        this.limbs.setCurrent((Object)limb.name);
        this.panel.rebuildModel();
    }

    private void removeLimb() {
        int size = this.panel.model.limbs.size();
        if (size == this.panel.model.getLimbCount(this.panel.limb)) {
            GuiModal.addFullModal((GuiElement)this, () -> new GuiMessageModal(this.mc, IKey.lang((String)"blockbuster.gui.me.limbs.last_limb")));
        } else {
            this.panel.model.removeLimb(this.panel.limb);
            String newLimb = this.panel.model.limbs.keySet().iterator().next();
            this.fillData(this.panel.model);
            this.setLimb(newLimb);
            this.panel.rebuildModel();
        }
    }

    private void renameLimb() {
        GuiModal.addFullModal((GuiElement)this, () -> new GuiPromptModal(this.mc, IKey.lang((String)"blockbuster.gui.me.limbs.rename_limb"), this::renameLimb).setValue(this.panel.limb.name));
    }

    private void renameLimb(String text) {
        if (this.panel.model.renameLimb(this.panel.limb, text)) {
            this.limbs.replace((Object)text);
            this.panel.rebuildModel();
        }
    }

    private void parentLimb() {
        GuiModal.addFullModal((GuiElement)this, () -> {
            GuiListModal modal = new GuiListModal(this.mc, IKey.lang((String)"blockbuster.gui.me.limbs.parent_limb"), this::parentLimb);
            return modal.addValues(this.panel.model.limbs.keySet()).setValue(this.panel.limb.parent);
        });
    }

    private void parentLimb(String text) {
        if (!this.panel.limb.name.equals(text)) {
            this.panel.limb.parent = text;
            this.panel.rebuildModel();
        }
    }

    private void setLimb(String str) {
        this.panel.setLimb(str);
        this.fillLimbData(this.panel.limb);
    }

    public void setCurrent(String str) {
        this.limbs.setCurrent((Object)str);
        this.fillLimbData(this.panel.limb);
    }

    public void fillData(Model model) {
        this.limbs.clear();
        this.limbs.add(model.limbs.keySet());
        this.limbs.sort();
        this.textureEditor.setVisible(false);
    }

    public void fillLimbData(ModelLimb limb) {
        this.textureEditor.x.setValue((double)this.panel.limb.texture[0]);
        this.textureEditor.y.setValue((double)this.panel.limb.texture[1]);
        this.size.setValues(limb.size[0], limb.size[1], limb.size[2]);
        this.sizeOffset.setValue((double)limb.sizeOffset);
        this.itemScale.setValue((double)limb.itemScale);
        this.anchor.setValues(limb.anchor[0], limb.anchor[1], limb.anchor[2]);
        this.origin.setValues(limb.origin[0], limb.origin[1], limb.origin[2]);
        this.color.picker.setColor(limb.color[0], limb.color[1], limb.color[2], limb.opacity);
        this.mirror.toggled(limb.mirror);
        this.lighting.toggled(limb.lighting);
        this.shading.toggled(limb.shading);
        this.smooth.toggled(limb.smooth);
        this.is3D.toggled(limb.is3D);
        this.holding.setValue(limb.holding.ordinal());
        this.slot.setValue(limb.slot.ordinal());
        this.hold.toggled(limb.hold);
        this.swiping.toggled(limb.swiping);
        this.lookX.toggled(limb.lookX);
        this.lookY.toggled(limb.lookY);
        this.swinging.toggled(limb.swinging);
        this.idle.toggled(limb.idle);
        this.invert.toggled(limb.invert);
        this.wheel.toggled(limb.wheel);
        this.wing.toggled(limb.wing);
        this.roll.toggled(limb.roll);
        this.cape.toggled(limb.cape);
    }
}

