/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client.gui.dashboard.panels.snowstorm.sections;

import mchorse.blockbuster.client.gui.dashboard.panels.snowstorm.GuiSectionManager;
import mchorse.blockbuster.client.gui.dashboard.panels.snowstorm.GuiSnowstorm;
import mchorse.blockbuster.client.gui.dashboard.panels.snowstorm.sections.GuiSnowstormModeSection;
import mchorse.blockbuster.client.particles.components.shape.BedrockComponentShapeBase;
import mchorse.blockbuster.client.particles.components.shape.BedrockComponentShapeBox;
import mchorse.blockbuster.client.particles.components.shape.BedrockComponentShapeDisc;
import mchorse.blockbuster.client.particles.components.shape.BedrockComponentShapeEntityAABB;
import mchorse.blockbuster.client.particles.components.shape.BedrockComponentShapePoint;
import mchorse.blockbuster.client.particles.components.shape.BedrockComponentShapeSphere;
import mchorse.blockbuster.client.particles.components.shape.ShapeDirection;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiCirculateElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTextElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiLabel;
import mchorse.mclib.client.gui.utils.Elements;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.math.molang.MolangParser;
import net.minecraft.client.Minecraft;

public class GuiSnowstormShapeSection
extends GuiSnowstormModeSection<BedrockComponentShapeBase> {
    public GuiTextElement offsetX;
    public GuiTextElement offsetY;
    public GuiTextElement offsetZ;
    public GuiDirectionSection direction;
    public GuiToggleElement surface;
    public GuiLabel radiusLabel;
    public GuiTextElement radius;
    public GuiLabel label;
    public GuiTextElement x;
    public GuiTextElement y;
    public GuiTextElement z;

    public GuiSnowstormShapeSection(Minecraft mc, GuiSnowstorm parent) {
        super(mc, parent);
        this.offsetX = new GuiTextElement(mc, 10000, str -> {
            ((BedrockComponentShapeBase)this.component).offset[0] = this.parse((String)str, this.offsetX, ((BedrockComponentShapeBase)this.component).offset[0]);
        });
        this.offsetX.tooltip(IKey.lang((String)"blockbuster.gui.model_block.x"));
        this.offsetY = new GuiTextElement(mc, 10000, str -> {
            ((BedrockComponentShapeBase)this.component).offset[1] = this.parse((String)str, this.offsetY, ((BedrockComponentShapeBase)this.component).offset[1]);
        });
        this.offsetY.tooltip(IKey.lang((String)"blockbuster.gui.model_block.y"));
        this.offsetZ = new GuiTextElement(mc, 10000, str -> {
            ((BedrockComponentShapeBase)this.component).offset[2] = this.parse((String)str, this.offsetZ, ((BedrockComponentShapeBase)this.component).offset[2]);
        });
        this.offsetZ.tooltip(IKey.lang((String)"blockbuster.gui.model_block.z"));
        this.direction = new GuiDirectionSection(mc, this);
        this.surface = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.snowstorm.shape.surface"), b -> {
            ((BedrockComponentShapeBase)this.component).surface = b.isToggled();
            this.parent.dirty();
        });
        this.surface.tooltip(IKey.lang((String)"blockbuster.gui.snowstorm.shape.surface_tooltip"));
        this.radiusLabel = Elements.label((IKey)IKey.lang((String)"blockbuster.gui.snowstorm.shape.radius"));
        this.radiusLabel.marginTop(12);
        this.radius = new GuiTextElement(mc, 10000, str -> {
            BedrockComponentShapeSphere sphere = (BedrockComponentShapeSphere)this.component;
            sphere.radius = this.parse((String)str, this.radius, sphere.radius);
        });
        this.label = Elements.label((IKey)IKey.lang((String)""));
        this.label.marginTop(12);
        this.x = new GuiTextElement(mc, 10000, str -> this.updateNormalDimension((String)str, this.x, 0));
        this.x.tooltip(IKey.lang((String)"blockbuster.gui.model_block.x"));
        this.y = new GuiTextElement(mc, 10000, str -> this.updateNormalDimension((String)str, this.y, 1));
        this.y.tooltip(IKey.lang((String)"blockbuster.gui.model_block.y"));
        this.z = new GuiTextElement(mc, 10000, str -> this.updateNormalDimension((String)str, this.z, 2));
        this.z.tooltip(IKey.lang((String)"blockbuster.gui.model_block.z"));
        this.modeLabel.label.set("blockbuster.gui.snowstorm.shape.shape");
        this.fields.add(new IGuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.gui.snowstorm.shape.offset")).marginTop(12), this.offsetX, this.offsetY, this.offsetZ, this.direction, this.surface});
    }

    @Override
    protected void collapseState() {
        GuiSectionManager.setDefaultState(((Object)((Object)this)).getClass().getSimpleName(), false);
        super.collapseState();
    }

    private void updateNormalDimension(String str, GuiTextElement element, int index) {
        if (this.component instanceof BedrockComponentShapeBox) {
            BedrockComponentShapeBox box = (BedrockComponentShapeBox)this.component;
            box.halfDimensions[index] = this.parse(str, element, box.halfDimensions[index]);
        } else if (this.component instanceof BedrockComponentShapeDisc) {
            BedrockComponentShapeDisc disc = (BedrockComponentShapeDisc)this.component;
            disc.normal[index] = this.parse(str, element, disc.normal[index]);
        }
    }

    @Override
    public String getTitle() {
        return "blockbuster.gui.snowstorm.shape.title";
    }

    @Override
    protected void fillModes(GuiCirculateElement button) {
        button.addLabel(IKey.lang((String)"blockbuster.gui.snowstorm.shape.point"));
        button.addLabel(IKey.lang((String)"blockbuster.gui.snowstorm.shape.box"));
        button.addLabel(IKey.lang((String)"blockbuster.gui.snowstorm.shape.sphere"));
        button.addLabel(IKey.lang((String)"blockbuster.gui.snowstorm.shape.disc"));
        button.addLabel(IKey.lang((String)"blockbuster.gui.snowstorm.shape.aabb"));
    }

    @Override
    protected void restoreInfo(BedrockComponentShapeBase component, BedrockComponentShapeBase old) {
        component.offset = old.offset;
        component.direction = old.direction;
        component.surface = old.surface;
        if (component instanceof BedrockComponentShapeSphere && old instanceof BedrockComponentShapeSphere) {
            ((BedrockComponentShapeSphere)component).radius = ((BedrockComponentShapeSphere)old).radius;
        }
    }

    @Override
    protected Class<BedrockComponentShapeBase> getBaseClass() {
        return BedrockComponentShapeBase.class;
    }

    @Override
    protected Class getDefaultClass() {
        return BedrockComponentShapePoint.class;
    }

    @Override
    protected Class getModeClass(int value) {
        if (value == 1) {
            return BedrockComponentShapeBox.class;
        }
        if (value == 2) {
            return BedrockComponentShapeSphere.class;
        }
        if (value == 3) {
            return BedrockComponentShapeDisc.class;
        }
        if (value == 4) {
            return BedrockComponentShapeEntityAABB.class;
        }
        return BedrockComponentShapePoint.class;
    }

    @Override
    protected void fillData() {
        super.fillData();
        this.set(this.offsetX, ((BedrockComponentShapeBase)this.component).offset[0]);
        this.set(this.offsetY, ((BedrockComponentShapeBase)this.component).offset[1]);
        this.set(this.offsetZ, ((BedrockComponentShapeBase)this.component).offset[2]);
        this.direction.fillData();
        this.surface.toggled(((BedrockComponentShapeBase)this.component).surface);
        if (this.component instanceof BedrockComponentShapeSphere) {
            this.set(this.radius, ((BedrockComponentShapeSphere)this.component).radius);
        }
        this.setNormalDimension(this.x, 0);
        this.setNormalDimension(this.y, 1);
        this.setNormalDimension(this.z, 2);
        this.radiusLabel.removeFromParent();
        this.radius.removeFromParent();
        this.label.removeFromParent();
        this.x.removeFromParent();
        this.y.removeFromParent();
        this.z.removeFromParent();
        this.surface.removeFromParent();
        if (this.component instanceof BedrockComponentShapeSphere) {
            this.fields.add(new IGuiElement[]{this.radiusLabel, this.radius});
        }
        if (this.component instanceof BedrockComponentShapeBox || this.component instanceof BedrockComponentShapeDisc) {
            this.label.label.set("blockbuster.gui.snowstorm.shape." + (this.component instanceof BedrockComponentShapeBox ? "box_size" : "normal"));
            this.fields.add((IGuiElement)this.label);
            this.fields.add((IGuiElement)this.x);
            this.fields.add((IGuiElement)this.y);
            this.fields.add((IGuiElement)this.z);
        }
        this.fields.add((IGuiElement)this.surface);
        this.resizeParent();
    }

    private void setNormalDimension(GuiTextElement text, int index) {
        if (this.component instanceof BedrockComponentShapeBox) {
            this.set(text, ((BedrockComponentShapeBox)this.component).halfDimensions[index]);
        } else if (this.component instanceof BedrockComponentShapeDisc) {
            this.set(text, ((BedrockComponentShapeDisc)this.component).normal[index]);
        }
    }

    public static class GuiDirectionSection
    extends GuiElement {
        public GuiSnowstormShapeSection parent;
        public GuiCirculateElement mode;
        public GuiTextElement x;
        public GuiTextElement y;
        public GuiTextElement z;

        public GuiDirectionSection(Minecraft mc, GuiSnowstormShapeSection parent) {
            super(mc);
            this.parent = parent;
            this.mode = new GuiCirculateElement(mc, b -> {
                int value = this.mode.getValue();
                ((BedrockComponentShapeBase)this.parent.component).direction = value == 0 ? ShapeDirection.OUTWARDS : (value == 1 ? ShapeDirection.INWARDS : new ShapeDirection.Vector(MolangParser.ZERO, MolangParser.ZERO, MolangParser.ZERO));
                this.parent.parent.dirty();
                this.fillData();
            });
            this.mode.addLabel(IKey.lang((String)"blockbuster.gui.snowstorm.shape.direction_outwards"));
            this.mode.addLabel(IKey.lang((String)"blockbuster.gui.snowstorm.shape.direction_inwards"));
            this.mode.addLabel(IKey.lang((String)"blockbuster.gui.snowstorm.shape.direction_vector"));
            this.x = new GuiTextElement(mc, 10000, str -> {
                this.getVector().x = this.parent.parse((String)str, this.x, this.getVector().x);
            });
            this.x.tooltip(IKey.lang((String)"blockbuster.gui.model_block.x"));
            this.y = new GuiTextElement(mc, 10000, str -> {
                this.getVector().y = this.parent.parse((String)str, this.y, this.getVector().y);
            });
            this.y.tooltip(IKey.lang((String)"blockbuster.gui.model_block.y"));
            this.z = new GuiTextElement(mc, 10000, str -> {
                this.getVector().z = this.parent.parse((String)str, this.z, this.getVector().z);
            });
            this.z.tooltip(IKey.lang((String)"blockbuster.gui.model_block.z"));
            this.flex().column(5).vertical().stretch().height(20);
            this.add((IGuiElement)Elements.row((Minecraft)mc, (int)5, (int)0, (int)20, (GuiElement[])new GuiElement[]{Elements.label((IKey)IKey.lang((String)"blockbuster.gui.snowstorm.shape.direction"), (int)20).anchor(0.0f, 0.5f), this.mode}));
        }

        private ShapeDirection.Vector getVector() {
            return (ShapeDirection.Vector)((BedrockComponentShapeBase)this.parent.component).direction;
        }

        public void fillData() {
            boolean isVector = ((BedrockComponentShapeBase)this.parent.component).direction instanceof ShapeDirection.Vector;
            int value = 0;
            if (((BedrockComponentShapeBase)this.parent.component).direction == ShapeDirection.INWARDS) {
                value = 1;
            } else if (isVector) {
                value = 2;
            }
            this.mode.setValue(value);
            this.x.removeFromParent();
            this.y.removeFromParent();
            this.z.removeFromParent();
            if (isVector) {
                ShapeDirection.Vector vector = (ShapeDirection.Vector)((BedrockComponentShapeBase)this.parent.component).direction;
                this.parent.set(this.x, vector.x);
                this.parent.set(this.y, vector.y);
                this.parent.set(this.z, vector.z);
                this.add(new IGuiElement[]{this.x, this.y, this.z});
            }
            this.parent.resizeParent();
        }
    }
}

