/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client.model.parsing;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import mchorse.blockbuster.api.Model;
import mchorse.blockbuster.api.ModelLimb;
import mchorse.blockbuster.api.ModelPose;
import mchorse.blockbuster.api.ModelTransform;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.PositionTextureVertex;
import net.minecraft.client.model.TexturedQuad;
import net.minecraft.util.math.Vec3d;

public class ModelExporterOBJ {
    private Model data;
    private ModelPose pose;

    public ModelExporterOBJ(Model data, ModelPose pose) {
        this.data = data;
        this.pose = pose;
    }

    public String export(String modelName) {
        String obj = "# OBJ generated by Blockbuster (version 2.3.3)\n\nmtllib " + modelName + ".mtl\nusemtl default\n";
        HashMap<ModelLimb, Mesh> meshes = new HashMap<ModelLimb, Mesh>();
        this.generateMeshes(meshes);
        return obj + this.generateBody(meshes);
    }

    private Field findField() {
        Field field = null;
        for (Field f : ModelBox.class.getDeclaredFields()) {
            if (!f.getType().equals(TexturedQuad[].class)) continue;
            field = f;
            field.setAccessible(true);
            return field;
        }
        return null;
    }

    private void generateMeshes(Map<ModelLimb, Mesh> meshes) {
        ModelBase base = new ModelBase(){};
        base.field_78090_t = this.data.texture[0];
        base.field_78089_u = this.data.texture[1];
        for (ModelLimb limb : this.data.limbs.values()) {
            ModelTransform transform = this.pose.limbs.get(limb.name);
            if (transform == null) {
                transform = ModelTransform.DEFAULT;
            }
            Matrix4f mat = new Matrix4f();
            mat.setIdentity();
            Matrix3f rotScale = new Matrix3f();
            rotScale.setIdentity();
            mat.setTranslation(new Vector3f(transform.translate));
            mat.m23 = -mat.m23;
            mat.m13 = -mat.m13;
            Matrix3f x = new Matrix3f();
            rotScale.m00 = transform.scale[0];
            rotScale.m11 = transform.scale[1];
            rotScale.m22 = transform.scale[2];
            Matrix3f rot = new Matrix3f();
            rot.setIdentity();
            x.setIdentity();
            x.rotZ((float)Math.toRadians(-transform.rotate[2]));
            rot.mul(x);
            x.setIdentity();
            x.rotY((float)Math.toRadians(-transform.rotate[1]));
            rot.mul(x);
            x.setIdentity();
            x.rotX((float)Math.toRadians(transform.rotate[0]));
            rot.mul(x);
            rotScale.mul(rot);
            mat.setRotationScale(rotScale);
            int w = limb.size[0];
            int h = limb.size[1];
            int d = limb.size[2];
            float ox = 1.0f - limb.anchor[0];
            float oy = limb.anchor[1];
            float oz = limb.anchor[2];
            ModelBox box = new ModelBox(new ModelRenderer(base), limb.texture[0], limb.texture[1], (float)(-w) * ox, (float)(-h) * oy, (float)(-d) * oz, w, h, d, limb.sizeOffset, limb.mirror);
            meshes.put(limb, new Mesh(box, mat, rot));
        }
    }

    private String generateBody(Map<ModelLimb, Mesh> meshes) {
        String output = "";
        Field field = this.findField();
        int v = 1;
        int u = 1;
        int n = 1;
        Matrix4f scale = new Matrix4f();
        scale.setIdentity();
        scale.rotZ((float)Math.PI);
        scale.setScale(0.0625f);
        for (Map.Entry<ModelLimb, Mesh> entry : meshes.entrySet()) {
            TexturedQuad[] quads = null;
            ModelLimb limb = entry.getKey();
            Mesh mesh = entry.getValue();
            try {
                quads = (TexturedQuad[])field.get(mesh.box);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (quads == null) continue;
            Matrix4f mat = new Matrix4f(mesh.mat);
            Matrix3f rot = new Matrix3f(mesh.rot);
            if (!limb.parent.isEmpty()) {
                ModelLimb parent = this.data.limbs.get(limb.parent);
                while (parent != null) {
                    Mesh parentMesh = meshes.get(parent);
                    Matrix4f mat2 = new Matrix4f(parentMesh.mat);
                    Matrix3f rot2 = new Matrix3f(parentMesh.rot);
                    mat2.mul(mat);
                    rot2.mul(rot);
                    mat = mat2;
                    rot = rot2;
                    parent = this.data.limbs.get(parent.parent);
                }
            }
            Matrix4f m = new Matrix4f(scale);
            m.mul(mat);
            mat = m;
            Matrix3f r = new Matrix3f();
            r.setIdentity();
            r.m11 = -1.0f;
            r.mul(rot);
            rot = r;
            output = output + "o " + limb.name.replaceAll("\\s", "_") + "\n";
            String vertices = "";
            String normals = "";
            String uvs = "";
            String faces = "";
            ArrayList<Vector4f> vecs = new ArrayList<Vector4f>();
            for (TexturedQuad quad : quads) {
                Vec3d v1 = quad.field_78239_a[1].field_78243_a.func_72444_a(quad.field_78239_a[0].field_78243_a);
                Vec3d v2 = quad.field_78239_a[1].field_78243_a.func_72444_a(quad.field_78239_a[2].field_78243_a);
                Vec3d v3 = v2.func_72431_c(v1).func_72432_b();
                Vector3f normal = new Vector3f((float)v3.field_72450_a, (float)v3.field_72448_b, (float)v3.field_72449_c);
                String face = "f ";
                rot.transform((Tuple3f)normal);
                normal.normalize();
                normals = normals + String.format("vn %.4f %.4f %.4f\n", Float.valueOf(normal.x), Float.valueOf(normal.y), Float.valueOf(normal.z));
                for (int i = 0; i < quad.field_78237_b; ++i) {
                    PositionTextureVertex vx = quad.field_78239_a[i];
                    Vector4f vec = new Vector4f((float)vx.field_78243_a.field_72450_a, (float)vx.field_78243_a.field_72448_b, (float)vx.field_78243_a.field_72449_c, 1.0f);
                    mat.transform((Tuple4f)vec);
                    int vi = vecs.indexOf(vec);
                    if (vi == -1) {
                        vertices = vertices + String.format("v %.4f %.4f %.4f\n", Float.valueOf(vec.x), Float.valueOf(vec.y), Float.valueOf(vec.z));
                        vi = vecs.size();
                        vecs.add(vec);
                    }
                    uvs = uvs + String.format("vt %f %f\n", Float.valueOf(vx.field_78241_b), Float.valueOf(1.0f - vx.field_78242_c));
                    face = face + (v + vi) + "/" + u + "/" + n + " ";
                    ++u;
                }
                faces = faces + face.trim() + "\n";
                ++n;
            }
            v += vecs.size();
            output = output + vertices + normals + uvs + faces;
        }
        return output;
    }

    public static class Mesh {
        public ModelBox box;
        public Matrix4f mat;
        public Matrix3f rot;

        public Mesh(ModelBox box, Matrix4f mat, Matrix3f rot) {
            this.box = box;
            this.mat = mat;
            this.rot = rot;
        }
    }
}

