/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.client.textures;

import at.dhyan.open_imaging.GifDecoder;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import mchorse.blockbuster.client.RenderingHandler;
import mchorse.blockbuster.client.textures.GifTexture;
import mchorse.blockbuster.client.textures.MipmapTexture;
import mchorse.mclib.utils.ReflectionUtils;
import mchorse.mclib.utils.resources.MultiResourceLocation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GifProcessThread
implements Runnable {
    public static final Map<ResourceLocation, GifProcessThread> THREADS = new HashMap<ResourceLocation, GifProcessThread>();
    public ResourceLocation texture;

    public GifProcessThread(ResourceLocation texture) {
        this.texture = texture;
    }

    @Override
    public void run() {
        if (this.texture instanceof MultiResourceLocation) {
            return;
        }
        try {
            Minecraft mc = Minecraft.func_71410_x();
            IResourceManager manager = mc.func_110442_L();
            InputStream stream = manager.func_110536_a(this.texture).func_110527_b();
            GifDecoder.GifImage image = GifDecoder.read(stream);
            GifTexture texture = new GifTexture(this.texture);
            texture.width = image.getWidth();
            texture.height = image.getHeight();
            int frames = image.getFrameCount();
            Map map = ReflectionUtils.getTextures((TextureManager)mc.field_71446_o);
            ITextureObject old = (ITextureObject)map.remove(this.texture);
            if (old != null && old instanceof AbstractTexture) {
                ((AbstractTexture)old).func_147631_c();
            }
            map.put(this.texture, texture);
            RenderingHandler.registerGif(this.texture, texture);
            for (int i = 0; i < frames; ++i) {
                BufferedImage buffer = image.getFrame(i);
                int delay = image.getDelay(i);
                texture.add(delay, MipmapTexture.bytesFromBuffer(buffer));
            }
            texture.calculateDuration();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void create(ResourceLocation location) {
        GifProcessThread thread = new GifProcessThread(location);
        THREADS.put(location, thread);
        thread.run();
        THREADS.remove(location);
    }
}

