/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.commands.model;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.CommonProxy;
import mchorse.blockbuster.client.model.parsing.ModelExporter;
import mchorse.blockbuster.commands.BBCommandBase;
import mchorse.metamorph.commands.CommandMorph;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.World;

public class SubCommandModelExport
extends BBCommandBase {
    public String func_71517_b() {
        return "export";
    }

    public String func_71518_a(ICommandSender sender) {
        return "blockbuster.commands.model.export";
    }

    public String getSyntax() {
        return "{l}{6}/{r}model {8}export{r} {7}<entity_name> [entity_tag]{r}";
    }

    public int getRequiredArgs() {
        return 1;
    }

    public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        Render render;
        String type = args[0];
        Entity entity = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(type), (World)sender.func_130014_f_());
        if (args.length > 1) {
            try {
                NBTTagCompound tag = new NBTTagCompound();
                entity.func_189511_e(tag);
                tag.func_179237_a(JsonToNBT.func_180713_a((String)CommandMorph.mergeArgs((String[])args, (int)1)));
                entity.func_70020_e(tag);
            }
            catch (Exception e) {
                throw new CommandException("metamorph.error.morph.nbt", new Object[]{e.getMessage()});
            }
        }
        if ((render = Minecraft.func_71410_x().func_175598_ae().func_78713_a(entity)) == null || !(render instanceof RenderLivingBase) || !(entity instanceof EntityLivingBase)) {
            Blockbuster.l10n.error(sender, "model.export.wrong_type", new Object[]{type});
            return;
        }
        ModelExporter exporter = new ModelExporter((EntityLivingBase)entity, (RenderLivingBase<EntityLivingBase>)((RenderLivingBase)render));
        String output = exporter.exportJSON(type);
        File exportFolder = new File(CommonProxy.configFile.getAbsolutePath() + "/export");
        exportFolder.mkdirs();
        try {
            File destination = new File(CommonProxy.configFile.getAbsolutePath() + "/export/" + type.replaceAll("[^\\w\\d_-]", "_") + ".json");
            PrintWriter writer = new PrintWriter(destination);
            writer.print(output);
            writer.close();
            TextComponentString file = new TextComponentString(destination.getName());
            file.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, destination.getAbsolutePath()));
            file.func_150256_b().func_150228_d(Boolean.valueOf(true));
            Blockbuster.l10n.success(sender, "model.export.saved", new Object[]{type, file});
        }
        catch (FileNotFoundException e) {
            Blockbuster.l10n.error(sender, "model.export.error_save", new Object[0]);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        return args.length == 1 ? SubCommandModelExport.func_175762_a((String[])args, (Collection)EntityList.func_180124_b()) : Collections.emptyList();
    }
}

