/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.commands.record;

import java.util.List;
import mchorse.aperture.camera.CameraAPI;
import mchorse.aperture.camera.CameraProfile;
import mchorse.aperture.camera.CameraUtils;
import mchorse.aperture.camera.data.Position;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.CommonProxy;
import mchorse.blockbuster.aperture.CameraHandler;
import mchorse.blockbuster.commands.record.SubCommandRecordBase;
import mchorse.blockbuster.recording.RecordUtils;
import mchorse.blockbuster.recording.data.Frame;
import mchorse.blockbuster.recording.data.Record;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.Optional;

public class SubCommandRecordCamera
extends SubCommandRecordBase {
    public String func_71517_b() {
        return "camera";
    }

    public String func_71518_a(ICommandSender sender) {
        return "blockbuster.commands.record.camera";
    }

    public String getSyntax() {
        return "{l}{6}/{r}record {8}camera{r} {7}<filename> <camera_profile> [x] [y] [z]{r}";
    }

    @Override
    public int getRequiredArgs() {
        return 2;
    }

    public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String filename = args[0];
        try {
            float x = args.length >= 3 ? (float)CommandBase.func_175765_c((String)args[2]) : 0.0f;
            float y = args.length >= 4 ? (float)CommandBase.func_175765_c((String)args[3]) : 0.0f;
            float z = args.length >= 5 ? (float)CommandBase.func_175765_c((String)args[4]) : 0.0f;
            Record record = this.generate(filename, args[1], x, y, z);
            CommonProxy.manager.records.put(filename, record);
            RecordUtils.saveRecord(record);
            Blockbuster.l10n.success(sender, "record.camera", new Object[]{filename, args[1]});
        }
        catch (Exception e) {
            e.printStackTrace();
            Blockbuster.l10n.error(sender, "record.couldnt_save", new Object[]{filename});
        }
    }

    private Record generate(String filename, String profile, float x, float y, float z) throws Exception {
        if (CameraHandler.isApertureLoaded()) {
            return this.generateProfile(filename, profile, x, y, z);
        }
        throw new IllegalStateException("/record camera can't be used, because Aperture mod isn't installed!");
    }

    @Optional.Method(modid="aperture")
    private Record generateProfile(String filename, String profile, float x, float y, float z) throws Exception {
        Record record = new Record(filename);
        CameraProfile camera = CameraUtils.readProfile((String)profile);
        Position prev = new Position();
        Position position = new Position();
        int c = (int)camera.getDuration();
        for (int i = 0; i <= c; ++i) {
            Frame frame = new Frame();
            if (i == c) {
                camera.applyProfile((long)(c - 1), 0.999f, position);
            } else {
                camera.applyProfile((long)i, 0.0f, position);
            }
            if (i == 0) {
                prev.copy(position);
            }
            frame.x = position.point.x + (double)x;
            frame.y = position.point.y + (double)y;
            frame.z = position.point.z + (double)z;
            frame.yaw = position.angle.yaw;
            frame.yawHead = position.angle.yaw;
            frame.bodyYaw = position.angle.yaw;
            frame.pitch = position.angle.pitch;
            frame.roll = position.angle.roll;
            frame.motionX = position.point.x - prev.point.x;
            frame.motionY = position.point.y - prev.point.y;
            frame.motionZ = position.point.z - prev.point.z;
            frame.hasBodyYaw = true;
            record.frames.add(frame);
            record.actions.add(null);
            prev.copy(position);
        }
        return record;
    }

    @Override
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 2 && CameraHandler.isApertureLoaded()) {
            return SubCommandRecordCamera.func_175762_a((String[])args, this.getCameraProfiles());
        }
        return super.func_184883_a(server, sender, args, pos);
    }

    @Optional.Method(modid="aperture")
    private List<String> getCameraProfiles() {
        return CameraAPI.getServerProfiles();
    }
}

