/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.commands.record;

import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.commands.CommandRecord;
import mchorse.blockbuster.commands.record.SubCommandRecordBase;
import mchorse.blockbuster.recording.RecordUtils;
import mchorse.blockbuster.recording.data.Frame;
import mchorse.blockbuster.recording.data.Record;
import mchorse.mclib.utils.Interpolations;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;

public class SubCommandRecordFade
extends SubCommandRecordBase {
    public String func_71517_b() {
        return "fade";
    }

    public String func_71518_a(ICommandSender sender) {
        return "blockbuster.commands.record.fade";
    }

    public String getSyntax() {
        return "{l}{6}/{r}record {8}fade{r} {7}<filename> <fade_out>{r}";
    }

    @Override
    public int getRequiredArgs() {
        return 2;
    }

    public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        Record record = CommandRecord.getRecord(args[0]);
        int length = record.getLength();
        int fadeOut = CommandBase.func_175764_a((String)args[1], (int)1, (int)length);
        if (length == 0) {
            Blockbuster.l10n.error(sender, "record.empty", new Object[]{record.filename});
            return;
        }
        Frame first = record.getFrame(0);
        Frame last = record.getFrame(length - fadeOut - 1);
        for (int i = 0; i < fadeOut; ++i) {
            Frame current = record.getFrame(length - fadeOut + i);
            float x = (float)i / (float)fadeOut;
            current.x = Interpolations.lerp((double)last.x, (double)first.x, (double)x);
            current.y = Interpolations.lerp((double)last.y, (double)first.y, (double)x);
            current.z = Interpolations.lerp((double)last.z, (double)first.z, (double)x);
            current.yaw = Interpolations.lerpYaw((float)last.yaw, (float)first.yaw, (float)x);
            current.yawHead = Interpolations.lerpYaw((float)last.yawHead, (float)first.yawHead, (float)x);
            current.mountYaw = Interpolations.lerp((float)last.mountYaw, (float)first.mountYaw, (float)x);
            current.pitch = Interpolations.lerp((float)last.pitch, (float)first.pitch, (float)x);
            current.mountPitch = Interpolations.lerp((float)last.mountPitch, (float)first.mountPitch, (float)x);
            if (!current.hasBodyYaw || !first.hasBodyYaw) continue;
            current.bodyYaw = Interpolations.lerpYaw((float)last.bodyYaw, (float)first.bodyYaw, (float)x);
        }
        try {
            RecordUtils.saveRecord(record);
            Blockbuster.l10n.success(sender, "record.faded", new Object[]{args[0], args[1]});
        }
        catch (Exception e) {
            e.printStackTrace();
            Blockbuster.l10n.error(sender, "record.couldnt_save", new Object[]{args[1]});
        }
    }
}

