/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.common.tileentity;

import io.netty.buffer.ByteBuf;
import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.common.entity.EntityActor;
import mchorse.blockbuster.network.Dispatcher;
import mchorse.blockbuster.network.common.PacketModifyModelBlock;
import mchorse.blockbuster.recording.scene.Scene;
import mchorse.metamorph.api.Morph;
import mchorse.metamorph.api.MorphManager;
import mchorse.metamorph.api.MorphUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityModel
extends TileEntity
implements ITickable {
    private static AbstractMorph DEFAULT_MORPH;
    public Morph morph = new Morph();
    public EntityLivingBase entity;
    public ItemStack[] slots = new ItemStack[]{ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a};
    public RotationOrder order = RotationOrder.ZYX;
    public float rotateYawHead;
    public float rotatePitch;
    public float rotateBody;
    public float x;
    public float y;
    public float z;
    public float rx;
    public float ry;
    public float rz;
    public boolean one = false;
    public float sx = 1.0f;
    public float sy = 1.0f;
    public float sz = 1.0f;
    public boolean shadow = true;
    public boolean global = false;
    public boolean enabled = true;
    private long lastModelUpdate;

    public static AbstractMorph getDefaultMorph() {
        if (DEFAULT_MORPH == null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("Name", "blockbuster.fred");
            DEFAULT_MORPH = MorphManager.INSTANCE.morphFromNBT(tag);
        }
        return DEFAULT_MORPH;
    }

    public TileEntityModel() {
        this.morph.setDirect(MorphUtils.copy((AbstractMorph)TileEntityModel.getDefaultMorph()));
        this.lastModelUpdate = Scene.lastUpdate;
    }

    public TileEntityModel(float yaw) {
        this();
        this.ry = yaw;
    }

    public void setMorph(AbstractMorph morph) {
        this.morph.set(morph);
        this.func_70296_d();
    }

    public void createEntity(World world) {
        if (world == null) {
            return;
        }
        this.entity = new EntityActor(world);
        this.entity.field_70122_E = true;
        this.updateEntity();
    }

    public void updateEntity() {
        if (this.entity == null) {
            return;
        }
        for (int i = 0; i < this.slots.length; ++i) {
            this.entity.func_184201_a(EntityEquipmentSlot.values()[i], this.slots[i]);
        }
    }

    public void func_73660_a() {
        if (this.entity == null) {
            this.createEntity(this.field_145850_b);
        }
        if (this.entity != null && this.enabled) {
            ++this.entity.field_70173_aa;
            this.entity.field_70165_t = (double)((float)this.field_174879_c.func_177958_n() + this.x) + 0.5;
            this.entity.field_70163_u = (float)this.field_174879_c.func_177956_o() + this.y;
            this.entity.field_70161_v = (double)((float)this.field_174879_c.func_177952_p() + this.z) + 0.5;
            if (!this.morph.isEmpty()) {
                this.morph.get().update(this.entity);
            }
        }
        if (this.lastModelUpdate < Scene.lastUpdate) {
            if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
                BlockPos pos = this.field_174879_c;
                PacketModifyModelBlock message = new PacketModifyModelBlock(pos, this);
                NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 64.0);
                Dispatcher.DISPATCHER.get().sendToAllAround((IMessage)message, point);
            }
            this.lastModelUpdate = Scene.lastUpdate;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        float range = Blockbuster.actorRenderingRange.get();
        return range * range;
    }

    public void copyData(TileEntityModel model, boolean merge) {
        this.order = model.order;
        this.rotateYawHead = model.rotateYawHead;
        this.rotatePitch = model.rotatePitch;
        this.rotateBody = model.rotateBody;
        this.x = model.x;
        this.y = model.y;
        this.z = model.z;
        this.rx = model.rx;
        this.ry = model.ry;
        this.rz = model.rz;
        this.one = model.one;
        this.sx = model.sx;
        this.sy = model.sy;
        this.sz = model.sz;
        this.shadow = model.shadow;
        this.global = model.global;
        this.enabled = model.enabled;
        if (merge) {
            this.morph.set(model.morph.get());
        } else {
            this.morph.setDirect(model.morph.get());
        }
        for (int i = 0; i < model.slots.length; ++i) {
            ItemStack stack = model.slots[i];
            this.slots[i] = stack.func_77946_l();
        }
        this.updateEntity();
        this.func_70296_d();
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (this.order != RotationOrder.ZYX) {
            compound.func_74774_a("Order", (byte)this.order.ordinal());
        }
        if (this.rotateYawHead != 0.0f) {
            compound.func_74776_a("Yaw", this.rotateYawHead);
        }
        if (this.rotatePitch != 0.0f) {
            compound.func_74776_a("Pitch", this.rotatePitch);
        }
        if (this.rotateBody != 0.0f) {
            compound.func_74776_a("Body", this.rotateBody);
        }
        if (this.x != 0.0f) {
            compound.func_74776_a("ShiftX", this.x);
        }
        if (this.y != 0.0f) {
            compound.func_74776_a("ShiftY", this.y);
        }
        if (this.z != 0.0f) {
            compound.func_74776_a("ShiftZ", this.z);
        }
        if (this.rx != 0.0f) {
            compound.func_74776_a("RotateX", this.rx);
        }
        if (this.ry != 0.0f) {
            compound.func_74776_a("RotateY", this.ry);
        }
        if (this.rz != 0.0f) {
            compound.func_74776_a("RotateZ", this.rz);
        }
        if (this.one) {
            compound.func_74757_a("Scale", this.one);
        }
        if (this.sx != 1.0f) {
            compound.func_74776_a("ScaleX", this.sx);
        }
        if (this.sy != 1.0f) {
            compound.func_74776_a("ScaleY", this.sy);
        }
        if (this.sz != 1.0f) {
            compound.func_74776_a("ScaleZ", this.sz);
        }
        if (!this.shadow) {
            compound.func_74757_a("Shadow", this.shadow);
        }
        if (this.global) {
            compound.func_74757_a("Global", this.global);
        }
        if (!this.enabled) {
            compound.func_74757_a("Enabled", this.enabled);
        }
        NBTTagList list = new NBTTagList();
        int empty = 0;
        for (int i = 0; i < this.slots.length; ++i) {
            NBTTagCompound tag = new NBTTagCompound();
            ItemStack stack = this.slots[i];
            if (!stack.func_190926_b()) {
                stack.func_77955_b(tag);
            } else {
                ++empty;
            }
            list.func_74742_a((NBTBase)tag);
        }
        if (empty != this.slots.length) {
            compound.func_74782_a("Items", (NBTBase)list);
        }
        if (!this.morph.isEmpty()) {
            compound.func_74782_a("Morph", (NBTBase)this.morph.toNBT());
        }
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("Order")) {
            this.order = RotationOrder.values()[compound.func_74771_c("Order")];
        }
        if (compound.func_74764_b("Yaw")) {
            this.rotateYawHead = compound.func_74760_g("Yaw");
        }
        if (compound.func_74764_b("Pitch")) {
            this.rotatePitch = compound.func_74760_g("Pitch");
        }
        if (compound.func_74764_b("Body")) {
            this.rotateBody = compound.func_74760_g("Body");
        }
        if (compound.func_74764_b("ShiftX")) {
            this.x = compound.func_74760_g("ShiftX");
        }
        if (compound.func_74764_b("ShiftY")) {
            this.y = compound.func_74760_g("ShiftY");
        }
        if (compound.func_74764_b("ShiftZ")) {
            this.z = compound.func_74760_g("ShiftZ");
        }
        if (compound.func_74764_b("RotateX")) {
            this.rx = compound.func_74760_g("RotateX");
        }
        if (compound.func_74764_b("RotateY")) {
            this.ry = compound.func_74760_g("RotateY");
        }
        if (compound.func_74764_b("RotateZ")) {
            this.rz = compound.func_74760_g("RotateZ");
        }
        if (compound.func_74764_b("Scale")) {
            this.one = compound.func_74767_n("Scale");
        }
        if (compound.func_74764_b("ScaleX")) {
            this.sx = compound.func_74760_g("ScaleX");
        }
        if (compound.func_74764_b("ScaleY")) {
            this.sy = compound.func_74760_g("ScaleY");
        }
        if (compound.func_74764_b("ScaleZ")) {
            this.sz = compound.func_74760_g("ScaleZ");
        }
        if (compound.func_74764_b("Shadow")) {
            this.shadow = compound.func_74767_n("Shadow");
        }
        if (compound.func_74764_b("Global")) {
            this.global = compound.func_74767_n("Global");
        }
        if (compound.func_74764_b("Enabled")) {
            this.enabled = compound.func_74767_n("Enabled");
        }
        if (compound.func_150297_b("Items", 9)) {
            NBTTagList items = compound.func_150295_c("Items", 10);
            int c = items.func_74745_c();
            for (int i = 0; i < c; ++i) {
                ItemStack stack;
                NBTTagCompound tag = items.func_150305_b(i);
                this.slots[i] = stack = new ItemStack(tag);
            }
        }
        if (compound.func_150297_b("Morph", 10)) {
            this.morph.setDirect(MorphManager.INSTANCE.morphFromNBT(compound.func_74775_l("Morph")));
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.order = RotationOrder.values()[buf.readByte()];
        this.rotateYawHead = buf.readFloat();
        this.rotatePitch = buf.readFloat();
        this.rotateBody = buf.readFloat();
        this.x = buf.readFloat();
        this.y = buf.readFloat();
        this.z = buf.readFloat();
        this.rx = buf.readFloat();
        this.ry = buf.readFloat();
        this.rz = buf.readFloat();
        this.one = buf.readBoolean();
        this.sx = buf.readFloat();
        this.sy = buf.readFloat();
        this.sz = buf.readFloat();
        this.shadow = buf.readBoolean();
        this.global = buf.readBoolean();
        this.enabled = buf.readBoolean();
        for (int i = 0; i < 6; ++i) {
            this.slots[i] = buf.readBoolean() ? ByteBufUtils.readItemStack((ByteBuf)buf) : null;
        }
        this.morph.setDirect(MorphUtils.morphFromBuf((ByteBuf)buf));
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.order.ordinal());
        buf.writeFloat(this.rotateYawHead);
        buf.writeFloat(this.rotatePitch);
        buf.writeFloat(this.rotateBody);
        buf.writeFloat(this.x);
        buf.writeFloat(this.y);
        buf.writeFloat(this.z);
        buf.writeFloat(this.rx);
        buf.writeFloat(this.ry);
        buf.writeFloat(this.rz);
        buf.writeBoolean(this.one);
        buf.writeFloat(this.sx);
        buf.writeFloat(this.sy);
        buf.writeFloat(this.sz);
        buf.writeBoolean(this.shadow);
        buf.writeBoolean(this.global);
        buf.writeBoolean(this.enabled);
        for (int i = 0; i < 6; ++i) {
            ItemStack stack = this.slots[i];
            buf.writeBoolean(stack != null);
            if (stack == null) continue;
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)stack);
        }
        MorphUtils.morphToBuf((ByteBuf)buf, (AbstractMorph)this.morph.get());
    }

    public static enum RotationOrder {
        ZYX,
        XYZ;

    }
}

