/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.recording;

import mchorse.blockbuster.CommonProxy;
import mchorse.blockbuster.common.entity.EntityActor;
import mchorse.blockbuster.network.Dispatcher;
import mchorse.blockbuster.network.common.PacketActorPause;
import mchorse.blockbuster.network.common.recording.PacketPlayback;
import mchorse.blockbuster.network.common.recording.PacketSyncTick;
import mchorse.blockbuster.recording.MPMHelper;
import mchorse.blockbuster.recording.data.Frame;
import mchorse.blockbuster.recording.data.Mode;
import mchorse.blockbuster.recording.data.Record;
import mchorse.blockbuster.recording.scene.Replay;
import mchorse.blockbuster.utils.EntityUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class RecordPlayer {
    public Record record;
    public Mode mode;
    public EntityLivingBase actor;
    public int tick = 0;
    public boolean kill = false;
    public boolean playing = true;
    public boolean sync = false;
    public Replay replay;
    public boolean realPlayer;

    public RecordPlayer(Record record, Mode mode, EntityLivingBase actor) {
        this.record = record;
        this.mode = mode;
        this.actor = actor;
    }

    public RecordPlayer realPlayer() {
        this.realPlayer = true;
        return this;
    }

    public boolean isFinished() {
        boolean isFinished;
        boolean bl = isFinished = this.record != null && this.tick - this.record.preDelay - this.record.postDelay >= this.record.getLength();
        if (isFinished && this.sync && this.playing) {
            this.pause();
            return false;
        }
        return isFinished;
    }

    public int getTick() {
        return Math.max(0, this.record == null ? this.tick : this.tick - this.record.preDelay);
    }

    public Frame getCurrentFrame() {
        return this.record.getFrame(this.getTick());
    }

    public void next() {
        this.next(this.actor);
    }

    public void next(EntityLivingBase actor) {
        if (this.record != null) {
            this.record.resetUnload();
        }
        if (!this.playing || this.isFinished()) {
            return;
        }
        if (this.record != null) {
            boolean both;
            boolean bl = both = this.mode == Mode.BOTH;
            if (this.mode == Mode.ACTIONS || both) {
                this.applyAction(this.tick, actor, false);
            }
            if (this.mode == Mode.FRAMES || both) {
                this.applyFrame(this.tick, actor, false);
            }
            this.record.resetUnload();
        }
        if (this.tick == 0) {
            actor.field_70761_aq = actor.field_70177_z;
        }
        ++this.tick;
    }

    public void pause() {
        this.playing = false;
        this.actor.field_70145_X = true;
        this.actor.func_184224_h(true);
        if (this.actor.func_70613_aW()) {
            this.record.applyPreviousMorph(this.actor, this.replay, this.tick, Record.MorphType.PAUSE);
            Dispatcher.sendToTracked((Entity)this.actor, new PacketActorPause(this.actor.func_145782_y(), true, this.tick));
        }
    }

    public void resume(int tick) {
        if (tick >= 0) {
            this.tick = tick;
        }
        this.playing = true;
        this.actor.field_70145_X = false;
        if (!this.actor.field_70170_p.field_72995_K && this.replay != null) {
            this.actor.func_184224_h(this.replay.invincible);
        }
        if (this.actor.func_70613_aW()) {
            this.record.applyPreviousMorph(this.actor, this.replay, tick, Record.MorphType.FORCE);
            Dispatcher.sendToTracked((Entity)this.actor, new PacketActorPause(this.actor.func_145782_y(), false, this.tick));
        }
    }

    public void goTo(int tick, boolean actions) {
        int preDelay = this.record.preDelay;
        int original = tick;
        if (tick > this.record.frames.size() + this.record.preDelay) {
            tick = this.record.frames.size() + this.record.preDelay - 1;
        }
        int min = Math.min(this.tick - this.record.preDelay, tick -= preDelay);
        int max = Math.max(this.tick - this.record.preDelay, tick);
        if (actions) {
            for (int i = min; i < max; ++i) {
                this.record.applyAction(i, this.actor);
            }
        }
        this.tick = original;
        this.record.resetUnload();
        this.record.applyFrame(tick, this.actor, true, this.realPlayer);
        if (actions) {
            this.record.applyAction(tick, this.actor);
            if (this.replay != null) {
                this.record.applyPreviousMorph(this.actor, this.replay, tick, Record.MorphType.PAUSE);
            }
        }
        if (this.actor.func_70613_aW()) {
            Dispatcher.sendToTracked((Entity)this.actor, new PacketSyncTick(this.actor.func_145782_y(), tick));
        }
    }

    public void startPlaying(String filename, boolean kill) {
        this.startPlaying(filename, 0, kill);
    }

    public void startPlaying(String filename, int tick, boolean kill) {
        this.tick = tick;
        this.kill = kill;
        this.sync = false;
        this.applyFrame(tick, this.actor, true);
        EntityUtils.setRecordPlayer(this.actor, this);
        if (this.actor.field_70170_p.func_73045_a(this.actor.func_145782_y()) != this.actor) {
            if (this.actor instanceof EntityActor) {
                this.actor.field_70170_p.func_72838_d((Entity)this.actor);
            } else if (this.actor instanceof EntityPlayer) {
                if (this.record.playerData != null) {
                    if (!this.realPlayer) {
                        this.actor.func_70037_a(this.record.playerData);
                    }
                    if (MPMHelper.isLoaded() && this.record.playerData.func_150297_b("MPMData", 10)) {
                        MPMHelper.setMPMData((EntityPlayer)this.actor, this.record.playerData.func_74775_l("MPMData"));
                    }
                }
                if (!this.realPlayer) {
                    this.actor.field_70170_p.func_73046_m().func_184103_al().func_72377_c((EntityPlayerMP)this.actor);
                }
            }
        }
        Dispatcher.sendToTracked((Entity)this.actor, new PacketPlayback(this.actor.func_145782_y(), true, this.realPlayer, filename));
        if (this.realPlayer && this.actor instanceof EntityPlayerMP) {
            Dispatcher.sendTo(new PacketPlayback(this.actor.func_145782_y(), true, this.realPlayer, filename), (EntityPlayerMP)this.actor);
        }
    }

    public void stopPlaying() {
        CommonProxy.manager.stop(this);
        this.actor.field_70145_X = false;
    }

    public void applyFrame(int tick, EntityLivingBase target, boolean force) {
        if ((tick -= this.record.preDelay) < 0) {
            tick = 0;
        } else if (tick >= this.record.frames.size()) {
            tick = this.record.frames.size() - 1;
        }
        this.record.applyFrame(tick, target, force, this.realPlayer);
    }

    public void applyAction(int tick, EntityLivingBase target, boolean safe) {
        this.record.applyAction(tick - this.record.preDelay, target, safe);
    }
}

