/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.recording.capturing;

import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.recording.RecordRecorder;
import mchorse.blockbuster.recording.actions.AttackAction;
import mchorse.blockbuster.recording.actions.EquipAction;
import mchorse.blockbuster.recording.actions.SwipeAction;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class PlayerTracker {
    public RecordRecorder recorder;
    private ItemStack[] items = new ItemStack[6];

    public PlayerTracker(RecordRecorder recorder) {
        this.recorder = recorder;
    }

    public void track(EntityPlayer player) {
        this.trackSwing(player);
        this.trackHeldItem(player);
        this.trackArmor(player);
    }

    private void trackArmor(EntityPlayer player) {
        for (int i = 1; i < 5; ++i) {
            this.trackItemToSlot((ItemStack)player.field_71071_by.field_70460_b.get(i - 1), i);
        }
    }

    private void trackHeldItem(EntityPlayer player) {
        ItemStack mainhand = player.func_184614_ca();
        ItemStack offhand = player.func_184592_cb();
        this.trackItemToSlot(mainhand, 0);
        this.trackItemToSlot(offhand, 5);
    }

    private boolean trackItemToSlot(ItemStack item, int slot) {
        if (!item.func_190926_b()) {
            if (item != this.items[slot]) {
                this.items[slot] = item;
                this.recorder.actions.add(new EquipAction((byte)slot, item));
                return true;
            }
        } else if (this.items[slot] != null) {
            this.items[slot] = null;
            this.recorder.actions.add(new EquipAction((byte)slot, null));
            return true;
        }
        return false;
    }

    private void trackSwing(EntityPlayer player) {
        if (player.field_82175_bq && player.field_70733_aJ == 0.0f && !player.func_70608_bn()) {
            this.recorder.actions.add(new SwipeAction());
            if (Blockbuster.recordAttackOnSwipe.get()) {
                this.recorder.actions.add(new AttackAction());
            }
        }
    }
}

