/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.recording.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import mchorse.blockbuster.aperture.CameraHandler;
import mchorse.blockbuster.common.entity.EntityActor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Frame {
    public static DataParameter<Byte> FLAGS;
    public double x;
    public double y;
    public double z;
    public float yaw;
    public float yawHead;
    public float pitch;
    public boolean hasBodyYaw;
    public float bodyYaw;
    public float mountYaw;
    public float mountPitch;
    public boolean isMounted;
    public double motionX;
    public double motionY;
    public double motionZ;
    public float fallDistance;
    public boolean isAirBorne;
    public boolean isSneaking;
    public boolean isSprinting;
    public boolean onGround;
    public boolean flyingElytra;
    public float roll;
    public int activeHands;

    public void fromPlayer(EntityPlayer player) {
        EntityPlayer mount = player.func_184218_aH() ? player.func_184187_bx() : player;
        this.x = mount.field_70165_t;
        this.y = player.func_184218_aH() && player.func_184187_bx().field_70163_u > player.field_70163_u ? player.field_70163_u : mount.field_70163_u;
        this.z = mount.field_70161_v;
        this.yaw = player.field_70177_z;
        this.yawHead = player.field_70759_as;
        this.pitch = player.field_70125_A;
        this.hasBodyYaw = true;
        this.bodyYaw = player.field_70761_aq;
        boolean bl = this.isMounted = mount != player;
        if (this.isMounted) {
            this.mountYaw = mount.field_70177_z;
            this.mountPitch = mount.field_70125_A;
        }
        this.motionX = mount.field_70159_w;
        this.motionY = mount.field_70181_x;
        this.motionZ = mount.field_70179_y;
        this.fallDistance = mount.field_70143_R;
        this.isSprinting = mount.func_70051_ag();
        this.isSneaking = player.func_70093_af();
        this.flyingElytra = player.func_184613_cA();
        this.isAirBorne = mount.field_70160_al;
        this.onGround = mount.field_70122_E;
        int n = player.func_184587_cr() ? (player.func_184600_cs() == EnumHand.OFF_HAND ? 2 : 1) : (this.activeHands = 0);
        if (player.field_70170_p.field_72995_K) {
            this.fromPlayerClient(player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void fromPlayerClient(EntityPlayer player) {
        EntityPlayerSP local = Minecraft.func_71410_x().field_71439_g;
        if (player == local) {
            this.roll = CameraHandler.getRoll();
        }
    }

    public void apply(EntityLivingBase actor, boolean force) {
        EntityLivingBase mount;
        boolean isRemote = actor.field_70170_p.field_72995_K;
        Object object = mount = actor.func_184218_aH() ? actor.func_184187_bx() : actor;
        if (mount instanceof EntityActor) {
            mount = actor;
        }
        if (actor instanceof EntityActor) {
            EntityActor theActor = (EntityActor)actor;
            theActor.isMounted = this.isMounted;
            theActor.roll = this.roll;
        }
        if (this.isMounted) {
            mount.field_70126_B = mount.field_70177_z;
            mount.field_70127_C = mount.field_70125_A;
        }
        actor.field_70126_B = actor.field_70177_z;
        actor.field_70127_C = actor.field_70125_A;
        actor.field_70758_at = actor.field_70759_as;
        if (!isRemote || force) {
            mount.func_70107_b(this.x, this.y, this.z);
        }
        if (isRemote || force) {
            if (this.isMounted) {
                mount.field_70177_z = this.mountYaw;
                mount.field_70125_A = this.mountPitch;
            }
            actor.field_70177_z = this.yaw;
            actor.field_70125_A = this.pitch;
            actor.field_70759_as = this.yawHead;
        }
        mount.field_70159_w = this.motionX;
        mount.field_70181_x = this.motionY;
        mount.field_70179_y = this.motionZ;
        mount.field_70143_R = this.fallDistance;
        if (!isRemote || force) {
            mount.func_70031_b(this.isSprinting);
            actor.func_70095_a(this.isSneaking);
            this.setFlag(actor, 7, this.flyingElytra);
        }
        mount.field_70160_al = this.isAirBorne;
        mount.field_70122_E = this.onGround;
        if (!isRemote) {
            if (this.activeHands > 0 && !actor.func_184587_cr()) {
                actor.func_184598_c(this.activeHands == 1 ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND);
            } else if (this.activeHands == 0 && actor.func_184587_cr()) {
                actor.func_184597_cx();
            }
        }
    }

    private void setFlag(EntityLivingBase actor, int i, boolean flag) {
        if (FLAGS == null) {
            Field field = null;
            for (Field f : Entity.class.getDeclaredFields()) {
                int mod = f.getModifiers();
                Type type = f.getGenericType();
                if (!Modifier.isProtected(mod) || !Modifier.isStatic(mod) || !Modifier.isFinal(mod) || f.getType() != DataParameter.class) continue;
                field = f;
                break;
            }
            if (field != null) {
                try {
                    field.setAccessible(true);
                    FLAGS = (DataParameter)field.get(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (FLAGS != null) {
            byte flags = (Byte)actor.func_184212_Q().func_187225_a(FLAGS);
            actor.func_184212_Q().func_187227_b(FLAGS, (Object)((byte)(flag ? flags | 1 << i : flags & ~(1 << i))));
        }
    }

    public Frame copy() {
        Frame frame = new Frame();
        frame.x = this.x;
        frame.y = this.y;
        frame.z = this.z;
        frame.yaw = this.yaw;
        frame.yawHead = this.yawHead;
        frame.pitch = this.pitch;
        frame.hasBodyYaw = this.hasBodyYaw;
        frame.bodyYaw = this.bodyYaw;
        frame.isMounted = this.isMounted;
        if (frame.isMounted) {
            frame.mountYaw = this.mountYaw;
            frame.mountPitch = this.mountPitch;
        }
        frame.motionX = this.motionX;
        frame.motionY = this.motionY;
        frame.motionZ = this.motionZ;
        frame.fallDistance = this.fallDistance;
        frame.isAirBorne = this.isAirBorne;
        frame.isSneaking = this.isSneaking;
        frame.isSprinting = this.isSprinting;
        frame.onGround = this.onGround;
        frame.flyingElytra = this.flyingElytra;
        frame.activeHands = this.activeHands;
        frame.roll = this.roll;
        return frame;
    }

    public void toBytes(DataOutput out) throws IOException {
        out.writeDouble(this.x);
        out.writeDouble(this.y);
        out.writeDouble(this.z);
        out.writeFloat(this.yaw);
        out.writeFloat(this.yawHead);
        out.writeFloat(this.pitch);
        out.writeBoolean(this.hasBodyYaw);
        if (this.hasBodyYaw) {
            out.writeFloat(this.bodyYaw);
        }
        out.writeBoolean(this.isMounted);
        if (this.isMounted) {
            out.writeFloat(this.mountYaw);
            out.writeFloat(this.mountPitch);
        }
        out.writeFloat((float)this.motionX);
        out.writeFloat((float)this.motionY);
        out.writeFloat((float)this.motionZ);
        out.writeFloat(this.fallDistance);
        out.writeBoolean(this.isAirBorne);
        out.writeBoolean(this.isSneaking);
        out.writeBoolean(this.isSprinting);
        out.writeBoolean(this.onGround);
        out.writeBoolean(this.flyingElytra);
        out.writeByte(this.activeHands);
        out.writeFloat(this.roll);
    }

    public void fromBytes(DataInput in) throws IOException {
        this.x = in.readDouble();
        this.y = in.readDouble();
        this.z = in.readDouble();
        this.yaw = in.readFloat();
        this.yawHead = in.readFloat();
        this.pitch = in.readFloat();
        if (in.readBoolean()) {
            this.hasBodyYaw = true;
            this.bodyYaw = in.readFloat();
        }
        this.isMounted = in.readBoolean();
        if (this.isMounted) {
            this.mountYaw = in.readFloat();
            this.mountPitch = in.readFloat();
        }
        this.motionX = in.readFloat();
        this.motionY = in.readFloat();
        this.motionZ = in.readFloat();
        this.fallDistance = in.readFloat();
        this.isAirBorne = in.readBoolean();
        this.isSneaking = in.readBoolean();
        this.isSprinting = in.readBoolean();
        this.onGround = in.readBoolean();
        this.flyingElytra = in.readBoolean();
        this.activeHands = in.readByte();
        this.roll = in.readFloat();
    }

    public void toNBT(NBTTagCompound tag) {
        tag.func_74780_a("X", this.x);
        tag.func_74780_a("Y", this.y);
        tag.func_74780_a("Z", this.z);
        tag.func_74776_a("MX", (float)this.motionX);
        tag.func_74776_a("MY", (float)this.motionX);
        tag.func_74776_a("MZ", (float)this.motionX);
        tag.func_74776_a("RX", this.yaw);
        tag.func_74776_a("RY", this.pitch);
        tag.func_74776_a("RZ", this.yawHead);
        if (this.hasBodyYaw) {
            tag.func_74776_a("RW", this.bodyYaw);
        }
        if (this.isMounted) {
            tag.func_74776_a("MRX", this.mountYaw);
            tag.func_74776_a("MRY", this.mountPitch);
        }
        tag.func_74776_a("Fall", this.fallDistance);
        tag.func_74757_a("Airborne", this.isAirBorne);
        tag.func_74757_a("Elytra", this.flyingElytra);
        tag.func_74757_a("Sneaking", this.isSneaking);
        tag.func_74757_a("Sprinting", this.isSprinting);
        tag.func_74757_a("Ground", this.onGround);
        if (this.activeHands > 0) {
            tag.func_74774_a("Hands", (byte)this.activeHands);
        }
        if (this.roll != 0.0f) {
            tag.func_74776_a("Roll", this.roll);
        }
    }

    public void fromNBT(NBTTagCompound tag) {
        this.x = tag.func_74769_h("X");
        this.y = tag.func_74769_h("Y");
        this.z = tag.func_74769_h("Z");
        this.motionX = tag.func_74760_g("MX");
        this.motionY = tag.func_74760_g("MY");
        this.motionZ = tag.func_74760_g("MZ");
        this.yaw = tag.func_74760_g("RX");
        this.pitch = tag.func_74760_g("RY");
        this.yawHead = tag.func_74760_g("RZ");
        if (tag.func_74764_b("RW")) {
            this.hasBodyYaw = true;
            this.bodyYaw = tag.func_74760_g("RW");
        }
        if (tag.func_74764_b("MRX") && tag.func_74764_b("MRY")) {
            this.isMounted = true;
            this.mountYaw = tag.func_74760_g("MRX");
            this.mountPitch = tag.func_74760_g("MRY");
        }
        this.fallDistance = tag.func_74760_g("Fall");
        this.isAirBorne = tag.func_74767_n("Airborne");
        this.flyingElytra = tag.func_74767_n("Elytra");
        this.isSneaking = tag.func_74767_n("Sneaking");
        this.isSprinting = tag.func_74767_n("Sprinting");
        this.onGround = tag.func_74767_n("Ground");
        if (tag.func_74764_b("Hands")) {
            this.activeHands = tag.func_74771_c("Hands");
        }
        if (tag.func_74764_b("Roll")) {
            this.roll = tag.func_74760_g("Roll");
        }
    }
}

