/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster.utils;

import java.util.UUID;
import mchorse.blockbuster.aperture.CameraHandler;
import mchorse.blockbuster.capabilities.recording.IRecording;
import mchorse.blockbuster.capabilities.recording.Recording;
import mchorse.blockbuster.common.entity.EntityActor;
import mchorse.blockbuster.recording.RecordPlayer;
import mchorse.mclib.utils.Interpolations;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class EntityUtils {
    public static void sendStatusMessage(EntityPlayerMP player, ITextComponent message) {
        player.func_146105_b(message, true);
    }

    public static String poseForEntity(EntityLivingBase entity) {
        if (entity.func_184218_aH()) {
            return "riding";
        }
        if (entity.func_184613_cA()) {
            return "flying";
        }
        if (entity.func_70093_af()) {
            return "sneaking";
        }
        return "standing";
    }

    public static RecordPlayer getRecordPlayer(EntityLivingBase entity) {
        if (entity instanceof EntityActor) {
            return ((EntityActor)entity).playback;
        }
        if (entity instanceof EntityPlayer) {
            IRecording record = Recording.get((EntityPlayer)entity);
            return record.getRecordPlayer();
        }
        return null;
    }

    public static void setRecordPlayer(EntityLivingBase entity, RecordPlayer playback) {
        if (entity instanceof EntityActor) {
            ((EntityActor)entity).playback = playback;
        } else if (entity instanceof EntityPlayer) {
            IRecording record = Recording.get((EntityPlayer)entity);
            record.setRecordPlayer(playback);
        }
    }

    public static Entity entityByUUID(World world, String id) {
        return EntityUtils.entityByUUID(world, UUID.fromString(id));
    }

    public static Entity entityByUUID(World world, UUID target) {
        for (Entity entity : world.field_72996_f) {
            if (!entity.func_110124_au().equals(target)) continue;
            return entity;
        }
        return null;
    }

    public static float getRoll(Entity entity, float partialTicks) {
        if (entity instanceof EntityActor) {
            EntityActor actor = (EntityActor)entity;
            return Interpolations.lerp((float)actor.prevRoll, (float)actor.roll, (float)partialTicks);
        }
        if (entity == Minecraft.func_71410_x().field_71439_g) {
            return CameraHandler.getRoll(partialTicks);
        }
        return 0.0f;
    }
}

