/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster_pack.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import mchorse.blockbuster.ClientProxy;
import mchorse.blockbuster.api.ModelPose;
import mchorse.blockbuster.api.formats.obj.OBJMaterial;
import mchorse.blockbuster.api.formats.obj.ShapeKey;
import mchorse.blockbuster.client.gui.dashboard.panels.model_editor.utils.GuiBBModelRenderer;
import mchorse.blockbuster.client.model.ModelCustom;
import mchorse.blockbuster_pack.client.gui.GuiCustomBodyPartEditor;
import mchorse.blockbuster_pack.client.gui.GuiPosePanel;
import mchorse.blockbuster_pack.client.gui.ILimbSelector;
import mchorse.blockbuster_pack.client.render.layers.LayerBodyPart;
import mchorse.blockbuster_pack.morphs.CustomMorph;
import mchorse.mclib.client.gui.framework.GuiBase;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.GuiModelRenderer;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTexturePicker;
import mchorse.mclib.client.gui.framework.elements.list.GuiListElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiStringListElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.framework.elements.utils.GuiDrawable;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.Label;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.mclib.utils.Direction;
import mchorse.mclib.utils.files.entries.AbstractEntry;
import mchorse.mclib.utils.files.entries.FileEntry;
import mchorse.mclib.utils.files.entries.FolderEntry;
import mchorse.mclib.utils.resources.RLUtils;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.client.gui.editor.GuiAbstractMorph;
import mchorse.metamorph.client.gui.editor.GuiMorphPanel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiCustomMorph
extends GuiAbstractMorph<CustomMorph> {
    public GuiPosePanel poseEditor;
    public GuiCustomBodyPartEditor bodyPart;
    public GuiMaterialsPanel materials;
    public GuiModelRendererBodyPart bbRenderer;

    public static void addSkins(AbstractMorph morph, List<Label<NBTTagCompound>> list, String name, FolderEntry entry) {
        if (entry == null) {
            return;
        }
        for (AbstractEntry childEntry : entry.getEntries()) {
            FolderEntry childFolder;
            if (childEntry instanceof FileEntry) {
                ResourceLocation location = ((FileEntry)childEntry).resource;
                String label = location.func_110623_a();
                int index = label.indexOf("/skins/");
                if (index != -1) {
                    label = label.substring(index + 7);
                }
                GuiCustomMorph.addPreset(morph, list, name, label, location);
                continue;
            }
            if (!(childEntry instanceof FolderEntry) || (childFolder = (FolderEntry)childEntry).isTop()) continue;
            GuiCustomMorph.addSkins(morph, list, name, childFolder);
        }
    }

    public static void addPreset(AbstractMorph morph, List<Label<NBTTagCompound>> list, String name, String label, ResourceLocation skin) {
        try {
            NBTTagCompound tag = morph.toNBT();
            tag.func_74778_a(name, skin.toString());
            list.add((Label<NBTTagCompound>)new Label(IKey.str((String)label), (Object)tag));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public GuiCustomMorph(Minecraft mc) {
        super(mc);
        this.prepend((IGuiElement)new GuiDrawable(n -> this.func_73733_a(0, this.area.ey() - 30, this.area.w, this.area.ey(), 0, -2013265920)));
        this.poseEditor = new GuiPosePanel(mc, this);
        this.bodyPart = new GuiCustomBodyPartEditor(mc, this);
        this.materials = new GuiMaterialsPanel(mc, this);
        this.defaultPanel = this.poseEditor;
        this.registerPanel(this.materials, IKey.lang((String)"blockbuster.gui.builder.materials"), Icons.MATERIAL);
        this.registerPanel((GuiMorphPanel)this.bodyPart, IKey.lang((String)"blockbuster.gui.builder.body_part"), Icons.LIMB);
        this.registerPanel(this.poseEditor, IKey.lang((String)"blockbuster.gui.builder.pose_editor"), Icons.POSE);
        this.keys().register(IKey.lang((String)"blockbuster.gui.builder.pick_skin"), 25, () -> {
            this.setPanel(this.materials);
            if (!this.materials.picker.hasParent()) {
                this.materials.skin.clickItself(GuiBase.getCurrent());
            }
        }).held(new int[]{42});
    }

    protected GuiModelRenderer createMorphRenderer(Minecraft mc) {
        this.bbRenderer = new GuiModelRendererBodyPart(Minecraft.func_71410_x());
        this.bbRenderer.looking = false;
        this.bbRenderer.origin = true;
        this.bbRenderer.picker(limb -> {
            if (this.view.delegate instanceof ILimbSelector) {
                ((ILimbSelector)this.view.delegate).setLimb((String)limb);
            }
        });
        return this.bbRenderer;
    }

    protected void setupRenderer(CustomMorph morph) {
        super.setupRenderer((AbstractMorph)morph);
        ModelPose pose = morph.getCurrentPose();
        if (pose != null) {
            this.bbRenderer.setScale(1.25f + pose.size[0]);
            this.bbRenderer.setPosition(0.0f, pose.size[1] / 2.0f, 0.0f);
        }
    }

    public void setPanel(GuiMorphPanel panel) {
        this.bbRenderer.limb = null;
        this.updateModelRenderer();
        super.setPanel(panel);
    }

    public boolean canEdit(AbstractMorph morph) {
        return morph instanceof CustomMorph && ((CustomMorph)morph).model != null;
    }

    public void startEdit(CustomMorph morph) {
        morph.parts.reinitBodyParts();
        this.bodyPart.setLimbs(morph.model.limbs.keySet());
        this.bbRenderer.morph = morph;
        this.bbRenderer.limb = null;
        super.startEdit((AbstractMorph)morph);
        this.updateModelRenderer();
    }

    public List<Label<NBTTagCompound>> getPresets(CustomMorph morph) {
        ArrayList<Label<NBTTagCompound>> list = new ArrayList<Label<NBTTagCompound>>();
        String key = morph.getKey();
        if (morph instanceof CustomMorph && morph.model != null && !morph.model.presets.isEmpty()) {
            for (Map.Entry<String, String> preset : morph.model.presets.entrySet()) {
                NBTTagCompound tag = null;
                try {
                    tag = JsonToNBT.func_180713_a((String)preset.getValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (tag == null) continue;
                NBTTagCompound morphTag = morph.toNBT();
                morphTag.func_179237_a(tag);
                list.add((Label<NBTTagCompound>)new Label(IKey.str((String)preset.getKey()), (Object)morphTag));
            }
        }
        GuiCustomMorph.addSkins(morph, list, "Skin", ClientProxy.tree.getByPath(key + "/skins", null));
        GuiCustomMorph.addSkins(morph, list, "Skin", ClientProxy.tree.getByPath(morph.model.skins + "/skins", null));
        return list;
    }

    public void updateModelRenderer() {
        CustomMorph custom = (CustomMorph)this.morph;
        this.bbRenderer.materials = custom.materials;
        this.bbRenderer.model = ModelCustom.MODELS.get(custom.getKey());
        this.bbRenderer.texture = custom.skin == null ? custom.model.defaultTexture : custom.skin;
        this.bbRenderer.setPose(custom.getCurrentPose());
    }

    public static class GuiShapeKeyListElement
    extends GuiListElement<ShapeKey> {
        public GuiShapeKeyListElement(Minecraft mc, Consumer<List<ShapeKey>> callback) {
            super(mc, callback);
            this.scroll.scrollItemSize = 16;
        }

        protected String elementToString(ShapeKey element) {
            return element.name;
        }
    }

    public static class GuiModelRendererBodyPart
    extends GuiBBModelRenderer {
        public CustomMorph morph;

        public GuiModelRendererBodyPart(Minecraft mc) {
            super(mc);
        }

        @Override
        protected float getScale() {
            return this.morph == null ? 1.0f : this.morph.scale;
        }

        @Override
        protected void renderModel(EntityLivingBase dummy, float headYaw, float headPitch, int timer, int yaw, int pitch, float partialTicks, float factor) {
            super.renderModel(dummy, headYaw, headPitch, timer, yaw, pitch, partialTicks, factor);
            LayerBodyPart.renderBodyParts(dummy, this.morph, this.model, 0.0f, 0.0f, partialTicks, (float)dummy.field_70173_aa + partialTicks, headYaw, headPitch, factor);
        }
    }

    public static class GuiMaterialsPanel
    extends GuiMorphPanel<CustomMorph, GuiCustomMorph> {
        public GuiButtonElement skin;
        public GuiButtonElement texture;
        public GuiStringListElement materials;
        public GuiTexturePicker picker;
        public GuiToggleElement keying;

        public GuiMaterialsPanel(Minecraft mc, GuiCustomMorph editor) {
            super(mc, (GuiAbstractMorph)editor);
            Consumer<ResourceLocation> skin = rl -> {
                ((CustomMorph)this.morph).skin = RLUtils.clone((ResourceLocation)rl);
                ((GuiCustomMorph)this.editor).updateModelRenderer();
            };
            Consumer<ResourceLocation> material = this::setCurrentMaterialRL;
            this.skin = new GuiButtonElement(mc, IKey.lang((String)"blockbuster.gui.builder.pick_skin"), b -> {
                this.picker.refresh();
                this.picker.fill(((CustomMorph)this.morph).skin);
                this.picker.callback = skin;
                this.add((IGuiElement)this.picker);
                this.picker.resize();
            });
            this.texture = new GuiButtonElement(mc, IKey.lang((String)"blockbuster.gui.builder.pick_texture"), b -> {
                ResourceLocation location = ((CustomMorph)this.morph).materials.get(this.materials.getCurrentFirst());
                this.picker.refresh();
                this.picker.fill(location);
                this.picker.callback = material;
                this.add((IGuiElement)this.picker);
                this.picker.resize();
            });
            this.materials = new GuiStringListElement(mc, str -> this.materials.setCurrent(str.get(0)));
            this.materials.background();
            this.keying = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.image.keying"), false, b -> {
                ((CustomMorph)this.morph).keying = b.isToggled();
            });
            this.keying.tooltip(IKey.lang((String)"blockbuster.gui.image.keying_tooltip"), Direction.TOP);
            this.picker = new GuiTexturePicker(mc, skin);
            this.skin.flex().relative((GuiElement)this).set(10.0f, 10.0f, 110.0f, 20.0f);
            this.texture.flex().relative((GuiElement)this.skin).set(0.0f, 25.0f, 110.0f, 20.0f);
            this.materials.flex().relative((GuiElement)this.texture).set(0.0f, 25.0f, 110.0f, 0.0f).hTo((IResizer)this.keying.flex(), -5);
            this.keying.flex().relative((GuiElement)this).x(10).w(110).y(1.0f, -24);
            this.picker.flex().relative((GuiElement)this).wh(1.0f, 1.0f);
            this.add(new IGuiElement[]{this.skin, this.texture, this.keying, this.materials});
        }

        private void setCurrentMaterialRL(ResourceLocation rl) {
            String key = (String)this.materials.getCurrentFirst();
            if (rl == null) {
                ((CustomMorph)this.morph).materials.remove(key);
            } else {
                ((CustomMorph)this.morph).materials.put(key, rl);
            }
            ((GuiCustomMorph)this.editor).updateModelRenderer();
        }

        public void fillData(CustomMorph morph) {
            super.fillData((AbstractMorph)morph);
            this.materials.clear();
            for (Map.Entry<String, OBJMaterial> entry : morph.model.materials.entrySet()) {
                if (!entry.getValue().useTexture) continue;
                this.materials.add((Object)entry.getKey());
            }
            this.materials.sort();
            this.picker.removeFromParent();
            boolean noMaterials = this.materials.getList().isEmpty();
            if (!noMaterials) {
                this.materials.setIndex(0);
            }
            this.materials.setVisible(!noMaterials);
            this.texture.setVisible(!noMaterials);
            this.keying.toggled(morph.keying);
        }

        public void finishEditing() {
            this.picker.close();
            super.finishEditing();
        }

        public void draw(GuiContext context) {
            if (this.materials.isVisible()) {
                this.font.func_175063_a(I18n.func_135052_a((String)"blockbuster.gui.builder.obj_materials", (Object[])new Object[0]), (float)this.materials.area.x, (float)(this.materials.area.y - 12), 0xFFFFFF);
            }
            super.draw(context);
        }
    }
}

