/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster_pack.client.gui;

import mchorse.blockbuster.Blockbuster;
import mchorse.blockbuster.api.ModelLimb;
import mchorse.blockbuster.api.ModelPose;
import mchorse.blockbuster.client.gui.dashboard.panels.model_editor.tabs.GuiModelPoses;
import mchorse.blockbuster.client.gui.dashboard.panels.model_editor.utils.GuiPoseTransformations;
import mchorse.blockbuster.client.gui.utils.GuiShapeKeysEditor;
import mchorse.blockbuster_pack.client.gui.GuiCustomMorph;
import mchorse.blockbuster_pack.client.gui.ILimbSelector;
import mchorse.blockbuster_pack.morphs.CustomMorph;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiButtonElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.context.GuiContextMenu;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiStringListElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.api.morphs.utils.Animation;
import mchorse.metamorph.client.gui.editor.GuiAbstractMorph;
import mchorse.metamorph.client.gui.editor.GuiAnimation;
import mchorse.metamorph.client.gui.editor.GuiMorphPanel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiPosePanel
extends GuiMorphPanel<CustomMorph, GuiCustomMorph>
implements ILimbSelector {
    public GuiButtonElement reset;
    public GuiButtonElement create;
    public GuiStringListElement list;
    public GuiToggleElement poseOnSneak;
    public GuiPoseTransformations transforms;
    public GuiAnimation animation;
    public GuiShapeKeysEditor shapeKeys;
    public GuiStringListElement models;
    public GuiButtonElement model;
    public GuiTrackpadElement scale;
    public GuiTrackpadElement scaleGui;

    public GuiPosePanel(Minecraft mc, GuiCustomMorph editor) {
        super(mc, (GuiAbstractMorph)editor);
        this.reset = new GuiButtonElement(mc, IKey.lang((String)"blockbuster.gui.morphs.reset"), b -> {
            if (((CustomMorph)this.morph).customPose == null) {
                ((CustomMorph)this.morph).currentPose = "";
                this.list.setIndex(-1);
            } else {
                ((CustomMorph)((GuiCustomMorph)this.editor).morph).customPose = null;
                ((GuiCustomMorph)this.editor).bbRenderer.limb = null;
                this.updateList();
                this.updateElements();
            }
            ((GuiCustomMorph)this.editor).updateModelRenderer();
        });
        this.reset.flex().relative((GuiElement)this).xy(10, 10).w(110);
        this.create = new GuiButtonElement(mc, IKey.lang((String)"blockbuster.gui.morphs.create"), b -> {
            if (((CustomMorph)this.morph).customPose == null) {
                ((CustomMorph)this.morph).customPose = ((CustomMorph)this.morph).getPose((EntityLivingBase)this.mc.field_71439_g, 0.0f).copy();
            }
            this.updateList();
            this.updateElements();
            ((GuiCustomMorph)this.editor).updateModelRenderer();
        });
        this.create.flex().relative((GuiElement)this.reset).y(25).w(110);
        this.poseOnSneak = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.builder.pose_sneak"), false, b -> {
            ((CustomMorph)this.morph).currentPoseOnSneak = this.poseOnSneak.isToggled();
            ((GuiCustomMorph)this.editor).updateModelRenderer();
        });
        this.poseOnSneak.flex().relative((GuiElement)this).x(10).y(1.0f, -24).w(110);
        this.list = new GuiStringListElement(mc, str -> {
            if (((CustomMorph)this.morph).customPose == null) {
                ((CustomMorph)this.morph).currentPose = (String)str.get(0);
                ((GuiCustomMorph)this.editor).updateModelRenderer();
            } else {
                this.setLimb((String)str.get(0));
            }
        });
        this.list.background();
        this.list.flex().xy(0, 40).w(110).hTo((IResizer)this.poseOnSneak.area, -5);
        this.list.context(this::limbContextMenu);
        this.transforms = new GuiPoseTransformations(mc);
        this.transforms.flex().relative((IResizer)this.area).set(0.0f, 0.0f, 190.0f, 70.0f).x(0.5f, -95).y(1.0f, -75);
        this.animation = new GuiAnimation(mc, true);
        this.animation.flex().relative((GuiElement)this).x(1.0f, -130).w(130);
        this.animation.interpolations.removeFromParent();
        this.model = new GuiButtonElement(mc, IKey.lang((String)"blockbuster.gui.builder.pick_model"), b -> this.models.toggleVisible());
        this.scale = new GuiTrackpadElement(mc, value -> {
            ((CustomMorph)this.morph).scale = value.floatValue();
        });
        this.scale.tooltip(IKey.lang((String)"blockbuster.gui.me.options.scale"));
        this.scaleGui = new GuiTrackpadElement(mc, value -> {
            ((CustomMorph)this.morph).scaleGui = value.floatValue();
        });
        this.scaleGui.tooltip(IKey.lang((String)"blockbuster.gui.me.options.scale_gui"));
        this.models = new GuiStringListElement(mc, string -> {
            ((CustomMorph)this.morph).changeModel((String)string.get(0));
            ((GuiCustomMorph)this.editor).updateModelRenderer();
            ((GuiCustomMorph)this.editor).poseEditor.fillData((CustomMorph)this.morph);
            ((GuiCustomMorph)this.editor).bodyPart.setLimbs(((CustomMorph)this.morph).model.limbs.keySet());
        });
        this.models.background();
        this.models.flex().relative((GuiElement)this.model).w(1.0f).h(96).anchorY(1.0f);
        GuiElement options = new GuiElement(mc);
        options.flex().relative((GuiElement)this).x(1.0f, -130).y(1.0f).w(130).anchorY(1.0f).column(5).vertical().stretch().height(20).padding(10);
        options.add(new IGuiElement[]{this.model, this.scale, this.scaleGui});
        this.shapeKeys = new GuiShapeKeysEditor(mc, () -> ((CustomMorph)this.morph).model);
        this.shapeKeys.flex().relative((GuiElement)this.poseOnSneak).y(-125).w(1.0f).h(120);
        this.add(new IGuiElement[]{this.reset, this.create, this.poseOnSneak, this.shapeKeys, this.list, this.animation, options, this.transforms, this.models, this.animation.interpolations});
    }

    private GuiContextMenu limbContextMenu() {
        if (((CustomMorph)this.morph).customPose == null) {
            return null;
        }
        return GuiModelPoses.createCopyPasteMenu(this::copyPose, this::pastePose);
    }

    private void copyPose() {
        GuiScreen.func_146275_d((String)((CustomMorph)this.morph).customPose.toNBT(new NBTTagCompound()).toString());
    }

    private void pastePose(ModelPose pose) {
        ModelPose currentPose = ((CustomMorph)this.morph).model.getPose(((CustomMorph)this.morph).currentPose);
        ((CustomMorph)this.morph).customPose.copy(pose);
        this.transforms.set(this.transforms.trans, currentPose == null ? null : currentPose.limbs.get(this.list.getCurrentFirst()));
        this.updateShapeKeys();
    }

    private void updateShapeKeys() {
        this.shapeKeys.setVisible(!((CustomMorph)this.morph).model.shapes.isEmpty() && ((CustomMorph)this.morph).customPose != null);
        if (this.shapeKeys.isVisible()) {
            this.shapeKeys.fillData(((CustomMorph)this.morph).getCurrentPose().shapes);
            this.list.flex().xy(0, 40).w(110).hTo((IResizer)this.shapeKeys.area, -10);
        } else {
            this.list.flex().xy(0, 40).w(110).hTo((IResizer)this.poseOnSneak.area, -5);
        }
        this.resize();
    }

    @Override
    public void setLimb(String limbName) {
        if (((CustomMorph)this.morph).customPose == null) {
            return;
        }
        ModelLimb limb = ((CustomMorph)this.morph).model.limbs.get(limbName);
        ModelPose pose = ((CustomMorph)this.morph).model.getPose(((CustomMorph)this.morph).currentPose);
        ((GuiCustomMorph)this.editor).bbRenderer.limb = limb;
        this.list.setCurrent((Object)limbName);
        this.transforms.set(((CustomMorph)this.morph).customPose.limbs.get(limbName), pose == null ? null : pose.limbs.get(limbName));
    }

    public void fillData(CustomMorph morph) {
        super.fillData((AbstractMorph)morph);
        this.updateList();
        this.updateElements();
        this.poseOnSneak.toggled(morph.currentPoseOnSneak);
        this.animation.fill((Animation)morph.animation);
        this.scale.setValue((double)morph.scale);
        this.scaleGui.setValue((double)morph.scaleGui);
        this.models.setVisible(false);
        this.models.clear();
        this.models.add(Blockbuster.proxy.models.models.keySet());
        this.models.sort();
        this.models.setCurrentScroll((Object)morph.getKey());
    }

    public void startEditing() {
        super.startEditing();
        this.updateList();
        this.updateElements();
    }

    private void updateElements() {
        this.create.setVisible(((CustomMorph)this.morph).customPose == null);
        this.transforms.setVisible(((CustomMorph)this.morph).customPose != null);
        this.list.flex().relative((GuiElement)(((CustomMorph)this.morph).customPose == null ? this.create : this.reset));
        this.list.resize();
        this.updateShapeKeys();
    }

    private void updateList() {
        String current;
        this.list.clear();
        if (((CustomMorph)this.morph).customPose == null) {
            current = ((CustomMorph)this.morph).currentPose;
            this.list.add(((CustomMorph)this.morph).model.poses.keySet());
            this.list.sort();
        } else {
            this.list.add(((CustomMorph)this.morph).model.limbs.keySet());
            this.list.sort();
            this.list.setIndex(0);
            current = (String)this.list.getCurrentFirst();
            if (!this.list.isDeselected()) {
                this.setLimb((String)this.list.getCurrentFirst());
            }
        }
        this.list.setCurrent((Object)current);
    }

    public void draw(GuiContext context) {
        if (((CustomMorph)this.morph).customPose == null) {
            this.font.func_175063_a(I18n.func_135052_a((String)"blockbuster.gui.builder.pose", (Object[])new Object[0]), (float)this.list.area.x, (float)(this.list.area.y - 12), 0xFFFFFF);
        } else {
            this.font.func_175063_a(I18n.func_135052_a((String)"blockbuster.gui.builder.limbs", (Object[])new Object[0]), (float)this.list.area.x, (float)(this.list.area.y - 12), 0xFFFFFF);
        }
        super.draw(context);
    }
}

