/*
 * Decompiled with CFR 0.152.
 */
package mchorse.blockbuster_pack.client.gui;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import mchorse.blockbuster.client.gui.dashboard.panels.model_editor.utils.GuiPoseTransformations;
import mchorse.blockbuster_pack.morphs.StructureMorph;
import mchorse.mclib.client.gui.framework.elements.GuiElement;
import mchorse.mclib.client.gui.framework.elements.IGuiElement;
import mchorse.mclib.client.gui.framework.elements.buttons.GuiToggleElement;
import mchorse.mclib.client.gui.framework.elements.input.GuiTrackpadElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiListElement;
import mchorse.mclib.client.gui.framework.elements.list.GuiSearchListElement;
import mchorse.mclib.client.gui.framework.elements.utils.GuiContext;
import mchorse.mclib.client.gui.utils.Icons;
import mchorse.mclib.client.gui.utils.keys.IKey;
import mchorse.mclib.client.gui.utils.resizers.IResizer;
import mchorse.metamorph.api.morphs.AbstractMorph;
import mchorse.metamorph.api.morphs.utils.Animation;
import mchorse.metamorph.client.gui.editor.GuiAbstractMorph;
import mchorse.metamorph.client.gui.editor.GuiAnimation;
import mchorse.metamorph.client.gui.editor.GuiMorphPanel;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;

public class GuiStructureMorph
extends GuiAbstractMorph<StructureMorph> {
    private static IKey ANCHOR_POINT = IKey.lang((String)"blockbuster.gui.structure_morph.anchor");
    public GuiStructureMorphPanel general;

    public GuiStructureMorph(Minecraft mc) {
        super(mc);
        this.general = new GuiStructureMorphPanel(mc, this);
        this.defaultPanel = this.general;
        this.registerPanel(this.general, IKey.lang((String)"blockbuster.morph.structure"), Icons.GEAR);
    }

    public boolean canEdit(AbstractMorph morph) {
        return morph instanceof StructureMorph;
    }

    public static class GuiBiomeList
    extends GuiListElement<ResourceLocation> {
        public GuiBiomeList(Minecraft mc, Consumer<List<ResourceLocation>> callback) {
            super(mc, callback);
            for (ResourceLocation location : Biome.field_185377_q.func_148742_b()) {
                this.add(location);
            }
        }

        protected boolean sortElements() {
            Collections.sort(this.list, Comparator.comparing(this::elementToString));
            return true;
        }

        protected String elementToString(ResourceLocation element) {
            return ((Biome)Biome.field_185377_q.func_82594_a((Object)element)).func_185359_l();
        }
    }

    public static class GuiSearchBiomeList
    extends GuiSearchListElement<ResourceLocation> {
        public GuiSearchBiomeList(Minecraft mc, Consumer<List<ResourceLocation>> callback) {
            super(mc, callback);
        }

        protected GuiListElement<ResourceLocation> createList(Minecraft mc, Consumer<List<ResourceLocation>> callback) {
            return new GuiBiomeList(mc, callback);
        }
    }

    public static class GuiStructureMorphPanel
    extends GuiMorphPanel<StructureMorph, GuiStructureMorph> {
        public GuiPoseTransformations pose;
        public GuiAnimation animation;
        public GuiToggleElement lighting;
        public GuiSearchBiomeList biomes;
        public GuiTrackpadElement anchorX;
        public GuiTrackpadElement anchorY;
        public GuiTrackpadElement anchorZ;

        public GuiStructureMorphPanel(Minecraft mc, GuiStructureMorph editor) {
            super(mc, (GuiAbstractMorph)editor);
            this.pose = new GuiPoseTransformations(mc);
            this.pose.flex().relative((IResizer)this.area).set(0.0f, 0.0f, 190.0f, 70.0f).x(0.5f, -95).y(1.0f, -75);
            this.animation = new GuiAnimation(mc, true);
            this.animation.flex().relative((GuiElement)this).x(1.0f, -130).w(130);
            this.lighting = new GuiToggleElement(mc, IKey.lang((String)"blockbuster.gui.structure_morph.lighting"), b -> {
                ((StructureMorph)this.morph).lighting = b.isToggled();
            });
            this.lighting.flex().relative((GuiElement)this).x(1.0f, -10).y(1.0f, -10).w(110).anchor(1.0f, 1.0f);
            this.anchorX = new GuiTrackpadElement(mc, v -> {
                ((StructureMorph)this.morph).anchorX = v.floatValue();
            });
            this.anchorY = new GuiTrackpadElement(mc, v -> {
                ((StructureMorph)this.morph).anchorY = v.floatValue();
            });
            this.anchorZ = new GuiTrackpadElement(mc, v -> {
                ((StructureMorph)this.morph).anchorZ = v.floatValue();
            });
            this.anchorX.flex().relative((GuiElement)this.anchorY).y(-5).w(1.0f).anchorY(1.0f);
            this.anchorY.flex().relative((GuiElement)this.anchorZ).y(-5).w(1.0f).anchorY(1.0f);
            this.anchorZ.flex().relative((GuiElement)this.lighting).y(-5).w(1.0f).anchorY(1.0f);
            this.biomes = new GuiSearchBiomeList(mc, this::accept);
            this.biomes.list.sort();
            this.biomes.flex().relative((GuiElement)this).x(0.0f).w(150).h(1.0f).anchorX(0.0f);
            this.biomes.list.background(Integer.MIN_VALUE);
            this.biomes.resize();
            this.biomes.list.scroll.scrollSpeed = 15;
            this.add(new IGuiElement[]{this.pose, this.animation, this.lighting, this.anchorZ, this.anchorY, this.anchorX, this.biomes});
        }

        public void fillData(StructureMorph morph) {
            super.fillData((AbstractMorph)morph);
            this.pose.set(morph.pose);
            this.animation.fill((Animation)morph.animation);
            this.lighting.toggled(morph.lighting);
            this.biomes.filter("", true);
            this.biomes.list.setCurrent((Object)morph.biome);
            this.anchorX.setValue((double)morph.anchorX);
            this.anchorY.setValue((double)morph.anchorY);
            this.anchorZ.setValue((double)morph.anchorZ);
        }

        private void accept(List<ResourceLocation> sel) {
            ((StructureMorph)this.morph).biome = sel.get(0);
        }

        public void draw(GuiContext context) {
            this.font.func_175063_a(ANCHOR_POINT.get(), (float)this.anchorX.area.x, (float)(this.anchorX.area.y - 12), 0xFFFFFF);
            super.draw(context);
        }
    }
}

